// dep_item.h (This is -*-c++-*-)
//
//  Copyright 1999 Daniel Burrows
//
//  This program is free software; you can redistribute it and/or modify
//  it under the terms of the GNU General Public License as published by
//  the Free Software Foundation; either version 2 of the License, or
//  (at your option) any later version.
//
//  This program is distributed in the hope that it will be useful,
//  but WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//  GNU General Public License for more details.
//
//  You should have received a copy of the GNU General Public License
//  along with this program; see the file COPYING.  If not, write to
//  the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
//  Boston, MA 02111-1307, USA.
//
//  An dependency chart for a package.

#ifndef DEP_ITEM_H
#define DEP_ITEM_H

#include "pkg_grouppolicy.h"
#include "vs_tree.h"
#include "pkg_item.h"
#include "vs_subtree.h"
#include "pkg_subtree.h"
#include "pkg_item_with_subtree.h"

// Inserts subtrees ("Depends", "Recommends", etc) for the package's
// dependencies into the given tree.
void setup_package_deps(pkgCache::VerIterator ver, pkg_item_with_generic_subtree *tree);

// Each package added to the following policy will expand to a tree listing its
// dependencies.
class pkg_grouppolicy_dep_factory:public pkg_grouppolicy_factory
{
public:
  virtual pkg_grouppolicy *instantiate(pkg_subtree *root);
};

class pkg_dep_screen:public vs_tree
{
  vscreen *prev;
public:
  pkg_dep_screen(pkgCache::VerIterator ver);

  void dispatch_char(chtype ch);

  virtual ~pkg_dep_screen() {}
};

#endif
