// dep_item.cc
//
//  Copyright 1999 Daniel Burrows
//
//  This program is free software; you can redistribute it and/or modify
//  it under the terms of the GNU General Public License as published by
//  the Free Software Foundation; either version 2 of the License, or
//  (at your option) any later version.
//
//  This program is distributed in the hope that it will be useful,
//  but WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//  GNU General Public License for more details.
//
//  You should have received a copy of the GNU General Public License
//  along with this program; see the file COPYING.  If not, write to
//  the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
//  Boston, MA 02111-1307, USA.
//
// Implementation of 'dependency items'.
//
//  For now we use the current version..

#include "dep_item.h"
#include "pkg_subtree.h"
#include "pkg_grouppolicy_hash.h"
#include "pkg_ver_item.h"

#include "apt.h"

#include <apt-pkg/version.h>

class pkg_depitem:public pkg_subtree
{
  pkgCache::DepIterator firstdep;
public:
  pkg_depitem(pkgCache::DepIterator &_first);

  int get_normal_attr();
};

pkg_depitem::pkg_depitem(pkgCache::DepIterator &first):
  pkg_subtree(""),firstdep(first)
{
  string currlabel="";
  bool firstiter=true;
  bool saw_or=(first->CompareOp & pkgCache::Dep::Or) == pkgCache::Dep::Or;

  do
    {
      if(!firstiter)
	currlabel+=" | ";

      firstiter=false;

      currlabel+=first.TargetPkg().Name();
      if(first.TargetVer())
	{
	  currlabel+=" (";
	  currlabel+=first.CompType();
	  currlabel+=" ";
	  currlabel+=first.TargetVer();
	  currlabel+=")";
	}

      for(pkgCache::VerIterator i=first.TargetPkg().VersionList(); !i.end(); i++)
	if(pkgCheckDep(first.TargetVer(), i.VerStr(), first->CompareOp))
	  add_child(new pkg_ver_item(i, saw_or));

      for(pkgCache::PrvIterator i=first.TargetPkg().ProvidesList(); !i.end(); i++)
	if(pkgCheckDep(first.TargetVer(), i.OwnerVer().VerStr(), first->CompareOp))
	  add_child(new pkg_ver_item(i.OwnerVer(), true));

      first++;
      saw_or=(first->CompareOp & pkgCache::Dep::Or) == pkgCache::Dep::Or;
    } while(saw_or && !first.end());
  pkg_subtree::set_label(currlabel.c_str());
}

int pkg_depitem::get_normal_attr()
{
  // Uhh, this appears to be how we find broken dependencies:
  if((*apt_cache_file)->IsImportantDep(firstdep) &&
     !((*apt_cache_file)[firstdep]&pkgDepCache::DepGInstall))
    return COLOR_PAIR(get_color("dep_broken", COLOR_BLACK, COLOR_RED));
  else
    return pkg_subtree::get_normal_attr();
}

class pkg_grouppolicy_dep:public pkg_grouppolicy
{
public:
  pkg_grouppolicy_dep(pkg_subtree *_root):pkg_grouppolicy(_root) {}

  void add_package(pkgCache::PkgIterator pkg)
  {
    pkg_item_with_generic_subtree *newtree=new pkg_item_with_generic_subtree(pkg);

    get_root()->add_child(newtree);

    setup_package_deps(pkg.CurrentVer(), newtree);
  }

  virtual ~pkg_grouppolicy_dep() {}
};

pkg_grouppolicy *pkg_grouppolicy_dep_factory::instantiate(pkg_subtree *_root)
{
  return new pkg_grouppolicy_dep(_root);
}

pkg_dep_screen::pkg_dep_screen(pkgCache::VerIterator ver)
{
  pkg_item_with_generic_subtree *newtree=new pkg_item_with_generic_subtree(ver.ParentPkg(), true);

  setup_package_deps(ver, newtree);

  set_root(newtree, true);
  set_header("Dependencies of "+string(ver.ParentPkg().Name()));

  prev=vscreen_show(this);
}

void pkg_dep_screen::dispatch_char(chtype ch)
{
  if(global_bindings.key_matches(ch, "ExitScreen"))
    {
      vscreen_show(prev);
      vscreen_preparedelete(this);
    }
  else
    vs_tree::dispatch_char(ch);
}

typedef hash_map<string, pkg_subtree *> tree_map;

void setup_package_deps(pkgCache::VerIterator ver, pkg_item_with_generic_subtree *tree)
{
  tree_map subtrees;

  if(ver.end())
    return;

  pkgCache::DepIterator D=ver.DependsList();
  while(!D.end())
    {
      pkg_subtree *subtree;

      tree_map::iterator found=subtrees.find(D.DepType());
      if(found==subtrees.end())
	{
	  subtree=new pkg_subtree(D.DepType(), true);
	  subtrees[D.DepType()]=subtree;
	  tree->add_child(subtree);
	}
      else
	subtree=found->second;

      subtree->add_child(new pkg_depitem(D));
    }
}
