// apt.h  -*-c++-*-
//
//  Copyright 1999 Daniel Burrows
//
//  This program is free software; you can redistribute it and/or modify
//  it under the terms of the GNU General Public License as published by
//  the Free Software Foundation; either version 2 of the License, or
//  (at your option) any later version.
//
//  This program is distributed in the hope that it will be useful,
//  but WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//  GNU General Public License for more details.
//
//  You should have received a copy of the GNU General Public License
//  along with this program; see the file COPYING.  If not, write to
//  the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
//  Boston, MA 02111-1307, USA.
//
//  Argh.  It seems that it's pretty much necessary to have a central
// repository for apt structures -- the cache in particular.  This is it.
// No class wrapper because, well, the cache is already a class and you can't
// open more than one at once, so there :)

#ifndef APT_H
#define APT_H

#include <apt-pkg/pkgrecords.h>
#include <apt-pkg/progress.h>

#include "aptcache.h"

#include "config/keybindings.h"

extern aptitudeCacheFile *apt_cache_file;
extern pkgRecords *apt_package_records;
// I'm confused about whether this (the records object) really needs to be
// globally allocated.

void apt_init(OpProgress *progess_bar);
//  It actually doesn't do what you expect!  This routine is a NOP if
// it has already been called; the rationale is that it allows any apt-using
// class to call this in its constructor (thus guaranteeing that the cache
// file is in a sane state)  To force a reload, call reload_cache().

void apt_reload_cache(OpProgress *progress_bar);
//  Forces the cache to be reloaded.
//
//  NOTE: at the moment, the interface won't work too well while this
// routine runs :)  I have Plans [ insert evil laughter here ] to do this in
// a background thread, but I need to know more about various bits of apt
// first.

void load_bindings(const char *group, keybindings *toload);
//  Loads values from the given APT configuration group into the given
// keybindings.

void forget_new();
// Discard all in-memory information about what packages are newly seen.  This
// actually involves generating new information, but you can think of it as
// if it discarded info. :)

bool pending_err();
// Returns true if there's a pending error.

string first_err();
// Returns the /first/ pending error

void pop_err();
// Deletes the /first/ pending error

#endif
