#!/bin/sh

#
# Load the keymaps *as soon as possible*
#

test -f /bin/loadkeys || exit 0

PACKAGE=console-tools

CONFDIR=/etc/${PACKAGE}

EXT=kmap

#KERNEL_KEYMAP=/var/state/misc/kernel.${EXT}

case "$1" in
    start | restart | force-reload | reload)
# 	# save kernel keymap
# 	if [ -d ${KERNEL_KEYMAP%/*} -a ! -r ${KERNEL_KEYMAP} ]
# 	then
# 	    /usr/bin/dumpkeys > ${KERNEL_KEYMAP}
# 	fi

	# load new map
	if [ -r ${CONFDIR}/default.${EXT} ] ; then
	    /bin/loadkeys ${CONFDIR}/default.${EXT}
	elif [ -r ${CONFDIR}/default.${EXT}.gz ] ; then
	    /bin/loadkeys ${CONFDIR}/default.${EXT}.gz
	fi
	;;

    stop)
# 	# ensure the saved kernel keymap is removed before halt/reboot
# 	rm -f ${KERNEL_KEYMAP}
	;;

    *)
	echo "Usage: $0 {start|stop|restart|reload|force-reload}"
	exit 1
	;;
esac
