/*
 * Copyright (c) 1999 The Java Apache Project.  All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 *
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in
 *    the documentation and/or other materials provided with the
 *    distribution.
 *
 * 3. All advertising materials mentioning features or use of this
 *    software must display the following acknowledgment:
 *    "This product includes software and design ideas developed by the Java
 *    Apache Project (http://java.apache.org/)."
 *
 * 4. The names "Cocoon", "Cocoon Servlet" and "Java Apache Project" must
 *    not be used to endorse or promote products derived from this software
 *    without prior written permission.
 *
 * 5. Products derived from this software may not be called "Cocoon"
 *    nor may "Cocoon" and "Java Apache Project" appear in their names without
 *    prior written permission of the Java Apache Project.
 *
 * 6. Redistributions of any form whatsoever must retain the following
 *    acknowledgment:
 *    "This product includes software and design ideas developed by the Java
 *    Apache Project (http://java.apache.org/)."
 *
 * THIS SOFTWARE IS PROVIDED BY THE JAVA APACHE PROJECT "AS IS" AND ANY
 * EXPRESSED OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL THE JAVA APACHE PROJECT OR
 * ITS CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT
 * NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
 * LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT,
 * STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED
 * OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 * This software consists of voluntary contributions made by many
 * individuals on behalf of the Java Apache Project. For more information
 * on the Java Apache Project please see <http://java.apache.org/>.
 */

package org.apache.cocoon.processor.dcp;

import java.io.*;
import java.util.*;
import org.w3c.dom.*;
import javax.servlet.http.*;
import org.apache.cocoon.processor.*;
import org.apache.cocoon.framework.*;
import org.apache.cocoon.interpreter.*;

/**
 * This class implements a DOM processor that expands XML documents
 * replacing dynamic content generation processing instructions by the return
 * value of user-supplied logic.
 * 
 * @author <a href="mailto:rrocha@plenix.org">Ricardo Rocha</a>
 * @version $Revision: 1.2 $ $Date: 1999/10/22 22:19:26 $
*/

public class DCPProcessor extends AbstractActor implements Processor, Status {
    
    /**
     * This method scans a DOM tree replacing <I>&lt;?dcp?&gt;</I> processing instructions
     * by dynamic content generated by user-supplied programs. These programs are
     * dynamically loaded according to directives contained in <I>&lt;?dcp-object?&gt;</I>
     * processing instructions. 
     *
     * @param document The document to be processed for dynamic content
     * @param parameters The table of invocation environment variables to be used during processing 
     * @return The expanded document
     * @throws Exception When any error occurs during processing
     */
    public Document process(Document document, Dictionary parameters) throws Exception {
        InterpreterFactory factory = (InterpreterFactory) director.getActor("interpreters");
        (new DCPEngine(document, factory, parameters)).process();
        return document;
    }
    
    /**
     * This method is called by the cache system to evaluate the status
     * of this changeable point for the given context 
     * (normally an HTTP request). Since even if the scripts didn't change
     * we can't assume anything about it, this method is today
     * left unimplemented (it always returns "true") but should call 
     * similar hooks inside the DCP components if available.
     */
    public boolean hasChanged(Object context) {
        return true;
    }
    
    public String getStatus() {
        return "Dynamic Content Processor";
    }
    
}