/*
 * Copyright (c) 1999 The Java Apache Project.  All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 *
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in
 *    the documentation and/or other materials provided with the
 *    distribution.
 *
 * 3. All advertising materials mentioning features or use of this
 *    software must display the following acknowledgment:
 *    "This product includes software and design ideas developed by the Java
 *    Apache Project (http://java.apache.org/)."
 *
 * 4. The names "Cocoon", "Cocoon Servlet" and "Java Apache Project" must
 *    not be used to endorse or promote products derived from this software
 *    without prior written permission.
 *
 * 5. Products derived from this software may not be called "Cocoon"
 *    nor may "Cocoon" and "Java Apache Project" appear in their names without
 *    prior written permission of the Java Apache Project.
 *
 * 6. Redistributions of any form whatsoever must retain the following
 *    acknowledgment:
 *    "This product includes software and design ideas developed by the Java
 *    Apache Project (http://java.apache.org/)."
 *
 * THIS SOFTWARE IS PROVIDED BY THE JAVA APACHE PROJECT "AS IS" AND ANY
 * EXPRESSED OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL THE JAVA APACHE PROJECT OR
 * ITS CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT
 * NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
 * LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT,
 * STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED
 * OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 * This software consists of voluntary contributions made by many
 * individuals on behalf of the Java Apache Project. For more information
 * on the Java Apache Project please see <http://java.apache.org/>.
 */

package org.apache.cocoon;

import java.io.*;
import java.net.*;
import java.util.*;
import javax.servlet.*;
import javax.servlet.http.*;
import org.apache.cocoon.framework.*;

/**
 * This class implements wrapping methods that allow the engine to be
 * called even from other APIs or standalone applications.
 *
 * @author <a href="mailto:stefano@apache.org">Stefano Mazzocchi</a>
 * @version $Revision: 1.3 $ $Date: 1999/10/19 21:39:32 $
 */

public class EngineWrapper extends Engine {
    
    public EngineWrapper(Configurations confs) throws Exception {
        super(confs);
    }

    public void handle(PrintWriter out, String document) throws Exception {
        this.handle(new HttpServletRequestImpl(document), new HttpServletResponseImpl(out));
    }
    
    /**
     * Dummy implementation of the HttpServletRequest class to create a 
     * fake but funtional request for the main engine.
     * NOTE: this works only with the default file producer.
     */
    public class HttpServletRequestImpl implements HttpServletRequest {
        
        private String pathTranslated;
        
        public HttpServletRequestImpl(String pathTranslated) {
            this.pathTranslated = pathTranslated;
        }

        public String getPathTranslated() {
            return this.pathTranslated;
        }

        public String getParameter(String name) { return null; }
        public Enumeration getParameterNames() { return null; }
        public String[] getParameterValues(String name) { return null; }
        public int getContentLength() { return -1; }
        public String getContentType() { return null; }
        public String getProtocol()  { return "none"; }
        public String getScheme() { return "none"; }
        public String getServerName() { return Cocoon.version(); }
        public int getServerPort() { return -1; }
        public String getRemoteAddr() { return null; }
        public String getRemoteHost() { return null; }
        public ServletInputStream getInputStream() throws IOException { return null; }
        public Object getAttribute(String name) { return null; }
        public BufferedReader getReader () throws IOException { return null; }
        public String getCharacterEncoding () { return null; }
        public Cookie[] getCookies() { return null; }
        public String getMethod() { return null; }
        public String getRequestURI() { return null; }
        public String getServletPath() { return null; }
        public String getPathInfo() { return null; }
        public String getQueryString() { return null; }
        public String getRemoteUser() { return null; }
        public String getAuthType() { return null; }
        public String getHeader(String name) { return null; }
        public int getIntHeader(String name) { return -1; }
        public long getDateHeader(String name) { return -1; }
        public Enumeration getHeaderNames() { return null; }
        public HttpSession getSession(boolean create) { return null; }
        public String getRequestedSessionId() { return null; }
        public boolean isRequestedSessionIdValid() { return false; }
        public boolean isRequestedSessionIdFromCookie() { return false; }
        public boolean isRequestedSessionIdFromURL() { return false; }
        public Enumeration getAttributeNames() { return null; }
        public void setAttribute(String name, Object value) {}
        public HttpSession getSession() { return null; }

        /** @deprecated */
        public String getRealPath(String path) { return null; }
        /** @deprecated */
        public boolean isRequestedSessionIdFromUrl() { return false; }
    }

    /**
     * Dummy implementation of the HttpServletResponse class to create a 
     * fake but funtional response for the main engine.
     */
    public class HttpServletResponseImpl implements HttpServletResponse {
        
        private PrintWriter out;
        
        public HttpServletResponseImpl(PrintWriter out) {
            this.out = out;
        }

        public PrintWriter getWriter() throws IOException {
            return this.out;
        }
        
        public void setContentLength(int len) {}
        public void setContentType(String type) {}
        public ServletOutputStream getOutputStream() throws IOException { return null; }
        public String getCharacterEncoding() { return null; }
        public void addCookie(Cookie cookie) {}
        public boolean containsHeader(String name) { return false; }
        public void setStatus(int sc) {}
        public void setHeader(String name, String value) {}
        public void setIntHeader(String name, int value) {}
        public void setDateHeader(String name, long date) {}
        public void sendError(int sc, String msg) throws IOException {}
        public void sendError(int sc) throws IOException {}
        public void sendRedirect(String location) throws IOException {}
        public String encodeURL (String url) { return url; }
        public String encodeRedirectURL (String url) { return url; }
        
        /** @deprecated */
        public void setStatus(int sc, String sm) {}
        /** @deprecated */
        public String encodeUrl (String url) { return url; }
        /** @deprecated */
        public String encodeRedirectUrl (String url) { return url; }
    }
}