/*
 * GQmpeg
 * (C)1998, 1999 John Ellis
 *
 * Author: John Ellis
 *
 * This software is released under the GNU General Public License.
 * Please read the included file COPYING for more information.
 * This software comes with no warranty of any kind, use at you own risk!
 */

#include "gqmpeg.h"

#include "default_skin/back.xpm"
#include "default_skin/back_mini.xpm"
#include "default_skin/btn_config.xpm"
#include "default_skin/btn_exit.xpm"
#include "default_skin/btn_iconify.xpm"
#include "default_skin/btn_mixer.xpm"
#include "default_skin/btn_mlist.xpm"
#include "default_skin/btn_mnext.xpm"
#include "default_skin/btn_mode.xpm"
#include "default_skin/btn_mpause.xpm"
#include "default_skin/btn_mplay.xpm"
#include "default_skin/btn_mprev.xpm"
#include "default_skin/btn_mrepeat.xpm"
#include "default_skin/btn_mshuffle.xpm"
#include "default_skin/btn_mstop.xpm"
#include "default_skin/btn_next.xpm"
#include "default_skin/btn_p1.xpm"
#include "default_skin/btn_p10.xpm"
#include "default_skin/btn_p2.xpm"
#include "default_skin/btn_p3.xpm"
#include "default_skin/btn_p4.xpm"
#include "default_skin/btn_p5.xpm"
#include "default_skin/btn_p6.xpm"
#include "default_skin/btn_p7.xpm"
#include "default_skin/btn_p8.xpm"
#include "default_skin/btn_p9.xpm"
#include "default_skin/btn_pause.xpm"
#include "default_skin/btn_play.xpm"
#include "default_skin/btn_playlist.xpm"
#include "default_skin/btn_prev.xpm"
#include "default_skin/btn_repeat.xpm"
#include "default_skin/btn_shuffle.xpm"
#include "default_skin/btn_stop.xpm"
#include "default_skin/dig_lrg.xpm"
#include "default_skin/dig_sml.xpm"
#include "default_skin/itm_minus.xpm"
#include "default_skin/itm_mminus.xpm"
#include "default_skin/itm_stereo.xpm"
#include "default_skin/itm_time.xpm"
#include "default_skin/letters.xpm"
#include "default_skin/slider_pos.xpm"
#include "default_skin/slider_vol.xpm"


SkinData *load_default_normal_skin()
{
	SkinData *s;
	GtkStyle *style;
	GdkPixmap *background;
	gint width, height;

	s = new_skin();

        style = gtk_widget_get_style(mainwindow);
	background = get_pixmap_from_data((gchar **)back_xpm);

	gdk_window_get_size (background, &width, &height);

	s->background = background;
	s->width = width;
	s->height = height;

	s->title = new_font_from_data((gchar **)letters_xpm, 32, FALSE, 104, 32);

	s->dig_small = new_digit_from_data((gchar **)dig_sml_xpm);
	s->dig_large = new_digit_from_data((gchar **)dig_lrg_xpm);

	s->pause = new_button_from_data((gchar **)btn_pause_xpm, TRUE, TRUE, 10, 87,
				btn_pause_pressed, NULL, NULL);
	s->play = new_button_from_data((gchar **)btn_play_xpm, TRUE, TRUE, 50, 87,
				btn_play_pressed, NULL, NULL);
	s->stop = new_button_from_data((gchar **)btn_stop_xpm, TRUE, TRUE, 90, 87,
				btn_stop_pressed, NULL, NULL);
	s->prev = new_button_from_data((gchar **)btn_prev_xpm, TRUE, FALSE, 130, 97,
				btn_prev_pressed, btn_prev_down, btn_prev_up);
	s->next = new_button_from_data((gchar **)btn_next_xpm, TRUE, FALSE, 165, 97,
				btn_next_pressed, btn_next_down, btn_next_up);

	s->shuffle = new_button_from_data((gchar **)btn_shuffle_xpm, TRUE, TRUE, 59, 57,
				btn_shuffle_pressed, NULL, NULL);
	s->repeat = new_button_from_data((gchar **)btn_repeat_xpm, TRUE, TRUE, 59, 31,
				btn_repeat_pressed, NULL, NULL);
	s->playlist = new_button_from_data((gchar **)btn_playlist_xpm, TRUE, FALSE, 10, 47,
				playlist_window_show, NULL, NULL);
	s->config = new_button_from_data((gchar **)btn_config_xpm, TRUE, FALSE, 311, 97,
				show_configuration_window, NULL, NULL);
	s->iconify = new_button_from_data((gchar **)btn_iconify_xpm, TRUE, FALSE, 301, 4,
				btn_iconify_pressed, NULL, NULL);
	s->exit = new_button_from_data((gchar **)btn_exit_xpm, TRUE, FALSE, 317, 4,
				gqmpeg_exit, NULL, NULL);
	s->mixer = new_button_from_data((gchar **)btn_mixer_xpm, TRUE, FALSE, 311, 75,
				btn_mixer_pressed, NULL, NULL);
	s->skin_mode = new_button_from_data((gchar **)btn_mode_xpm, TRUE, FALSE, 285, 4,
				mode_button_pressed, NULL, NULL);

	s->stereo = new_item_from_data((gchar **)itm_stereo_xpm, 3, 233, 93);
	s->item_minus = new_item_from_data((gchar **)itm_minus_xpm, 2, 104, 59);
	s->item_total_mode = new_item_from_data((gchar **)itm_time_xpm, 3, 106, 64);

	s->hour = new_number(s->dig_large, 2, FALSE, 112, 55);
	s->min = new_number(s->dig_large, 2, TRUE, 140, 55);
	s->sec = new_number(s->dig_large, 2, TRUE, 169, 55);

	s->song_current = new_number(s->dig_large, 3, FALSE, 218, 55);
	s->song_total = new_number(s->dig_large, 3, FALSE, 260, 55);

	s->input_bits = new_number(s->dig_small, 3, FALSE, 214, 75);
	s->input_hz = new_number(s->dig_small, 2, FALSE, 263, 75);
	s->cpu = new_number(s->dig_small, 2, FALSE, 263, 91);

	s->position = new_slider_from_data((gchar **)slider_pos_xpm, TRUE, FALSE, FALSE, 317, 10, 117,
			NULL, position_slider_moved, position_slider_released,
			position_slider_moved);
	s->volume = new_slider_from_data((gchar **)slider_vol_xpm, TRUE, TRUE, TRUE, 40, 315, 30,
			s->volume_item, volume_slider_moved, NULL, volume_slider_moved);

	s->preset[0] = new_button_from_data((gchar **)btn_p1_xpm, TRUE, FALSE, 11, 130,
				preset_1_pressed, NULL, NULL);
	s->preset[1] = new_button_from_data((gchar **)btn_p2_xpm, TRUE, FALSE, 43, 130,
				preset_2_pressed, NULL, NULL);
	s->preset[2] = new_button_from_data((gchar **)btn_p3_xpm, TRUE, FALSE, 75, 130,
				preset_3_pressed, NULL, NULL);
	s->preset[3] = new_button_from_data((gchar **)btn_p4_xpm, TRUE, FALSE, 107, 130,
				preset_4_pressed, NULL, NULL);
	s->preset[4] = new_button_from_data((gchar **)btn_p5_xpm, TRUE, FALSE, 139, 130,
				preset_5_pressed, NULL, NULL);
	s->preset[5] = new_button_from_data((gchar **)btn_p6_xpm, TRUE, FALSE, 171, 130,
				preset_6_pressed, NULL, NULL);
	s->preset[6] = new_button_from_data((gchar **)btn_p7_xpm, TRUE, FALSE, 203, 130,
				preset_7_pressed, NULL, NULL);
	s->preset[7] = new_button_from_data((gchar **)btn_p8_xpm, TRUE, FALSE, 235, 130,
				preset_8_pressed, NULL, NULL);
	s->preset[8] = new_button_from_data((gchar **)btn_p9_xpm, TRUE, FALSE, 267, 130,
				preset_9_pressed, NULL, NULL);
	s->preset[9] = new_button_from_data((gchar **)btn_p10_xpm, TRUE, FALSE, 299, 130,
				preset_10_pressed, NULL, NULL);

	return s;
}

SkinData *load_default_small_skin()
{
	SkinData *s;
	GtkStyle *style;
	GdkPixmap *background;
	gint width, height;

	s = new_skin();

        style = gtk_widget_get_style(mainwindow);
	background = get_pixmap_from_data((gchar **)back_mini_xpm);

	gdk_window_get_size (background, &width, &height);

	s->background = background;
	s->width = width;
	s->height = height;

	s->title = new_font_from_data((gchar **)letters_xpm, 15, FALSE, 6, 4);

	s->dig_large = new_digit_from_data((gchar **)dig_lrg_xpm);

	s->pause = new_button_from_data((gchar **)btn_mpause_xpm, TRUE, TRUE, 195, 4,
				btn_pause_pressed, NULL, NULL);
	s->play = new_button_from_data((gchar **)btn_mplay_xpm, TRUE, TRUE, 211, 4,
				btn_play_pressed, NULL, NULL);
	s->stop = new_button_from_data((gchar **)btn_mstop_xpm, TRUE, TRUE, 227, 4,
				btn_stop_pressed, NULL, NULL);
	s->prev = new_button_from_data((gchar **)btn_mprev_xpm, TRUE, FALSE, 248, 4,
				btn_prev_pressed, btn_prev_down, btn_prev_up);
	s->next = new_button_from_data((gchar **)btn_mnext_xpm, TRUE, FALSE, 264, 4,
				btn_next_pressed, btn_next_down, btn_next_up);

	s->playlist = new_button_from_data((gchar **)btn_mlist_xpm, TRUE, FALSE, 174, 4,
				playlist_window_show, NULL, NULL);

	s->iconify = new_button_from_data((gchar **)btn_iconify_xpm, TRUE, FALSE, 301, 4,
				btn_iconify_pressed, NULL, NULL);
	s->exit = new_button_from_data((gchar **)btn_exit_xpm, TRUE, FALSE, 317, 4,
				gqmpeg_exit, NULL, NULL);
	s->skin_mode = new_button_from_data((gchar **)btn_mode_xpm, TRUE, FALSE, 285, 4,
				mode_button_pressed, NULL, NULL);

	s->shuffle = new_button_from_data((gchar **)btn_mshuffle_xpm, TRUE, TRUE, 160, 12,
				btn_shuffle_pressed, NULL, NULL);
	s->repeat = new_button_from_data((gchar **)btn_mrepeat_xpm, TRUE, TRUE, 160, 4,
				btn_repeat_pressed, NULL, NULL);

	s->item_minus = new_item_from_data((gchar **)itm_mminus_xpm, 2, 100, 9);
	s->item_total_mode = new_item_from_data((gchar **)itm_time_xpm, 3, 100, 14);

	s->min = new_number(s->dig_large, 2, FALSE, 106, 5);
	s->sec = new_number(s->dig_large, 2, TRUE, 134, 5);

	return s;
}

