/*
 * GQmpeg
 * (C)1998, 1999 John Ellis
 *
 * Author: John Ellis
 *
 * This software is released under the GNU General Public License.
 * Please read the included file COPYING for more information.
 * This software comes with no warranty of any kind, use at your own risk!
 */

#include "gqmpeg.h"
#include "utildlg.h"

/*
 *-----------------------------------------------------------------------------
 * load a file
 *-----------------------------------------------------------------------------
 */

static void preset_dialog_set(GtkWidget *widget, gpointer data)
{
	FileDialog *fd = data;
	gchar *buf;
	gint n;

	n = GPOINTER_TO_INT(gtk_object_get_data(GTK_OBJECT(widget), "preset_num"));

	fd->dest_path = g_strdup(gtk_entry_get_text(GTK_ENTRY(fd->entry)));

	if (isdir(fd->dest_path))
		{
		destination_widget_sync_to_entry(fd->entry);
		g_free(fd->dest_path);
		fd->dest_path = NULL;
		return;
		}

	if (n > -1 && n < 10)
		{
		g_free(preset_name[n]);
		g_free(preset_file[n]);

		preset_name[n] = g_strdup(filename_from_path(fd->dest_path));
		preset_file[n] = g_strdup(fd->dest_path);

		create_preset_menu();
		}

	buf = remove_level_from_path(fd->dest_path);
	tab_completion_append_to_history(fd->entry, buf);
	g_free(buf);
	generic_dialog_close(NULL, fd);
}

static void preset_dialog_completion_sync(gchar *path, gpointer data)
{
	FileDialog *fd = data;
	destination_widget_sync_to_entry(fd->entry);
}

void preset_dialog(gchar *path, gint playlist)
{
	FileDialog *fd;
	GtkWidget *list;
	GtkWidget *tabcomp;
	GtkWidget *hbox;
	gchar *text;
	gchar *key;
	gchar *filter;
	gchar *last_path;
	gint i;
	gchar *src_path;

	if (!path)
		{
		if (playlist)
			{
			src_path = g_strconcat(homedir(), "/", GQMPEG_RC_DIR_PLAYLIST, NULL);
			}
		else
			{
			src_path = g_strdup(homedir());
			}
		}
	else
		{
		src_path = g_strdup(path);
		}

	if (playlist)
		{
		text = _("Set preset to playlist:");
		key = "preset_dlg_playlist";
		}
	else
		{
		text = _("Set preset to song:");
		key = "preset_dlg_file";
		}

	fd = generic_dialog_new(_("GQmpeg - set preset"), text, NULL, _("Cancel"),
		NULL, generic_dialog_close);

	tabcomp = tab_completion_new_with_history(&fd->entry, fd->dialog, src_path,
			key, 32, NULL, NULL);
	if (path)
		{
		last_path = NULL;
		}
	else
		{
		last_path = tab_completion_set_to_last_history(fd->entry);
		}
	if (last_path)
		{
		fd->source_path = g_strdup(last_path);
		}
	else
		{
		fd->source_path = g_strdup(src_path);
		}

	gtk_box_pack_start(GTK_BOX(fd->vbox), tabcomp, FALSE, FALSE,0);
	gtk_widget_show(tabcomp);
	
	gtk_widget_grab_focus(fd->entry);

	if (playlist)
		{
		filter = g_strdup(".gqmpeg");
		}
	else
		{
		filter = filter_get_text_list();
		}
	list = destination_widget_new_with_files(fd->source_path, filter, fd->entry);
	g_free(filter);
	gtk_box_pack_start(GTK_BOX(fd->vbox), list, TRUE, TRUE, 0);
	gtk_widget_show(list);

	tab_completion_add_tab_func(fd->entry, preset_dialog_completion_sync, fd);

	hbox = gtk_hbox_new(TRUE, 0);
	gtk_box_pack_start(GTK_BOX(fd->vbox), hbox, FALSE, FALSE, 0);
	gtk_widget_show(hbox);

	for (i = 0; i < 10; i++)
		{
		GtkWidget *button;
		gchar *buf;

		buf = g_strdup_printf("%d", i + 1);
		button = gtk_button_new_with_label(buf);
		g_free(buf);
		gtk_object_set_data(GTK_OBJECT(button), "preset_num", GINT_TO_POINTER(i));
		gtk_signal_connect(GTK_OBJECT(button), "clicked", preset_dialog_set, fd);
		gtk_box_pack_start(GTK_BOX(hbox), button, TRUE, TRUE, 0);
		gtk_widget_show(button);
		}

	g_free(src_path);
}

