/*
 * GQmpeg
 * (C)1998, 1999 John Ellis
 *
 * Author: John Ellis
 *
 * This software is released under the GNU General Public License.
 * Please read the included file COPYING for more information.
 * This software comes with no warranty of any kind, use at you own risk!
 */

#include "gqmpeg.h"

#include <gdk/gdkx.h>
#include <X11/Xlib.h>
#include <X11/Xatom.h>

/*
 *-----------------------------------------------------------------------------
 * these are the dock routines, for embedding into other programs, panels, etc.
 *-----------------------------------------------------------------------------
 */ 

static guchar *check_wm_prop(Display *dpy, Window window, Atom hint, Atom type,
			     int format, int count, int *retCount);
static gint is_winmaker_wm(Display *dpy);
static void create_winmaker_dock(char *argv[]);

void winmaker_setup_dock(char *argv[])
{
	if (is_winmaker_wm(GDK_DISPLAY()))
		{
		create_winmaker_dock(argv);
		}
	else
		{
		printf(_("Window Maker not detected!\n"));
		}
}

/*
 *-----------------------------------------------------------------------------
 * The Windowmaker docking code (wm_*() functions)
 * is originally from Kimball Thurston <kimball@sgrail.com>
 * I have made a few modifications to enclose all relevent code into this
 * file.
 *-----------------------------------------------------------------------------
 */ 

static guchar *check_wm_prop(Display *dpy, Window window, Atom hint, Atom type,
			     int format, int count, int *retCount)
{
	Atom type_ret;
	int fmt_ret;
	unsigned long nitems_ret;
	unsigned long bytes_after_ret;
	unsigned char *data;
	int tmp;

	if (count <= 0)
		tmp = 0xffffff;
	else
		tmp = count;

	if (XGetWindowProperty(dpy, window, hint, 0, tmp, False, type,
			       &type_ret, &fmt_ret, &nitems_ret, &bytes_after_ret,
			       (unsigned char **)&data) != Success
	    || !data)
		return NULL;

	if ((type!=AnyPropertyType && type!=type_ret)
	    || (count > 0 && nitems_ret != count)
	    || (format != 0 && format != fmt_ret))
		{
		XFree(data);
		return NULL;
		}

	if (retCount)
		*retCount = nitems_ret;

	return data;
}

/******************************************************************************/
/******************************************************************************/
/* Window Maker Specific Functions - so gqmpeg can operate in the wmaker dock */
/******************************************************************************/
/******************************************************************************/

static gint is_winmaker_wm(Display *dpy)
{
	gint retval = FALSE;
	Atom *data;
	Atom atom;
	Atom noticeboard;
	gint i, count;

	atom = XInternAtom(dpy, "_WINDOWMAKER_WM_PROTOCOLS", False);
	noticeboard = XInternAtom(dpy, "_WINDOWMAKER_NOTICEBOARD", False);

	data = (Atom*)check_wm_prop(dpy, DefaultRootWindow(dpy), atom,
				    XA_ATOM, 32, -1, &count);

	if (!data)
		return FALSE;

	for (i = 0; i < count; i++)
		{
		if (data[i] == noticeboard)
			{
			Window *win;
			void *d;

			win = (Window*)check_wm_prop(dpy, DefaultRootWindow(dpy), 
						     noticeboard, XA_WINDOW, 32, -1, &count);

			if (win)
				{
				d = check_wm_prop(dpy, *win, noticeboard,
						  XA_WINDOW, 32, 1, NULL);
				if (d)
					{
					XFree(d);
					retval = TRUE;
					}
				}

			break;
		}
	}

	XFree(data);

	return retval;
}

static void create_winmaker_dock(char *argv[])
{
	char *progName = NULL;

	Window dockiconwin = None;
	Window dockgroupleader = None;
	XClassHint *chint;
	XWMHints *hints;

	progName = strrchr(argv[0], '/');
	if ( NULL == progName )
		progName = argv[0];
	else
		progName++;

	dockiconwin = XCreateSimpleWindow(GDK_DISPLAY(),
					  DefaultRootWindow(GDK_DISPLAY()),
					  0, 0, skin->width, skin->height, 0, 0, 0);
	dockgroupleader = XCreateSimpleWindow(GDK_DISPLAY(),
					      DefaultRootWindow(GDK_DISPLAY()),
					      0, 0, 1, 1, 0, 0, 0);
	chint = XAllocClassHint();
	if (!chint)
		{
		printf("%s: cant allocate memory for class hints!\n", progName);
		exit(1);
		}
	chint->res_class = "GQmpeg";
	chint->res_name = progName;

	XSetClassHint(GDK_DISPLAY(), dockgroupleader, chint);
	XFree(chint);

	hints = XAllocWMHints();
	if (!hints)
		{
		printf("%s: cant allocate memory for hints!\n", progName);
		exit(1);
		}
	hints->flags = IconWindowHint|WindowGroupHint|StateHint;

	hints->initial_state = WithdrawnState;
	hints->window_group = dockgroupleader;
	hints->icon_window = dockiconwin;

	XSetWMHints(GDK_DISPLAY(), dockgroupleader, hints);
	XReparentWindow(GDK_DISPLAY(), GDK_WINDOW_XWINDOW( mainwindow->window ),
			dockiconwin, 0, 0);
	XFlush(GDK_DISPLAY());

	if (None != dockgroupleader)
		{
		XMapRaised(GDK_DISPLAY(), dockgroupleader);
	}
}


