/* -*- mode: C++; tab-width: 4 -*- */
/* ================================================================================== */
/* Copyright (c) 1998-1999 3Com Corporation or its subsidiaries. All rights reserved. */
/* ================================================================================== */

#include "EmulatorCommon.h"
#include "CGremlinsStubs.h"

#include "Platform.h"			// Platform::ViewDrawLine

// ---------------------------------------------------------------------------
//		 StubEnqueuePt
// ---------------------------------------------------------------------------
// This is a stub routine that called the application object's method that
// enqueues a point.

void	StubAppEnqueuePt(PointType* pen)
{
	::EvtEnqueuePenPoint(pen);
}


// ---------------------------------------------------------------------------
//		 StubAppEnqueueKey
// ---------------------------------------------------------------------------
// This is a stub routine that called the Application object's method that
// enqueues a key.

void StubAppEnqueueKey (UInt16 ascii, UInt16 keycode, UInt16 modifiers)
{
	switch (ascii)
	{
		// This translates some control characters into system chars
		case 0x01:	// control-A
			ascii = menuChr;
			modifiers = commandKeyMask;
			break;
		case 0x02:	// control-B
			ascii = lowBatteryChr;
			modifiers = commandKeyMask;
			break;			
		case 0x03:	// control-C
			ascii = commandChr;
			modifiers = commandKeyMask;
			break;
		case 0x04:	// control-D
			ascii = confirmChr;
			modifiers = commandKeyMask;
			break;
		case 0x05:	// control-E
			ascii = launchChr;
			modifiers = commandKeyMask;
			break;
		case 0x06:	// control-F
			ascii = keyboardChr;
			modifiers = commandKeyMask;
			break;
		case 0x0D:	// control-M
			ascii = linefeedChr;
			break;
		case 0x0E:	// control-N
			ascii = nextFieldChr;
			modifiers = commandKeyMask;
			break;			
		case 0x13:	// control-S
			ascii = autoOffChr;
			modifiers = commandKeyMask;
			break;			
		case 0x14:	// control-T
			ascii = hardContrastChr;
			modifiers = commandKeyMask;
			break;			
		case 0x15:	// control-U
			ascii = backlightChr;
			modifiers = commandKeyMask;
			break;
	}


	// If this is one of the hard keys, send it through the Key Manager so that
	//  it can do the right things concering double-taps, etc.
	if ((modifiers & commandKeyMask) &&
			(ascii > hardKeyMin || (ascii == pageUpChr) || (ascii == pageDownChr)))
	{

		DWord		status = 0;

		switch (ascii)
		{
			case hard1Chr: 		status = keyBitHard1; break;
			case hard2Chr: 		status = keyBitHard2; break;
			case hard3Chr: 		status = keyBitHard3; break;
			case hard4Chr: 		status = keyBitHard4; break;
			case hardPowerChr: 	status = keyBitPower; break;
			case pageUpChr: 	status = keyBitPageUp; break;
			case pageDownChr: 	status = keyBitPageDown; break;
		}

		// I'm dubious that this is the correct thing to do in the emulator.
		// This is an interrupt routine that we're calling directly.  But
		// what if a "real" interrupt is triggered from some other source
		// while this call is executing (for instance, the user clicks on
		// one of the "keyboard buttons", thus generating a keyboard
		// interrupt)?  It's possible that the two will stomp on each other.
		// The best thing to do is to post events the emulator way.
		// However, I'm hard-pressed to do that.  That would require calling
		// Hardware_ButtonEvent twice (once to signal the keyboard
		// interrupt, and another to clear it), but I don't know how to give
		// the processor time in between to respond to the first call.

		if (status != 0)
			::KeyHandleInterrupt (false, status);
	}

	// For other keys, enqueue them directly.
	else
	{
		::EvtEnqueueKey (ascii, keycode, modifiers);

		// Added - during Gremlin runs, we found that the timeout
		// could get set to 30 seconds and that a Gremlin may type
		// characters for more than 30 seconds at a time. EvtEnqueueKey
		// doesn't reset the event timer, so it was possible for the
		// device to go to sleep, even when typing was occuring.

		::EvtResetAutoOffTimer ();
	}
}


// ---------------------------------------------------------------------------
//		 StubAppGremlinsOn
// ---------------------------------------------------------------------------
// Stub routine that update the Gremlins menu an the global variable the
// keeps track of the ????

void StubAppGremlinsOn (void)
{
	// Called from Gremlins::Initialize.
}


// ---------------------------------------------------------------------------
//		 StubAppGremlinsOff
// ---------------------------------------------------------------------------
// Stub routine that update the Gremlins menu an the global variable the
// keeps track of the ????

void StubAppGremlinsOff (void)
{
	// Called by Gremlins when counter > until.
}


// ---------------------------------------------------------------------------
//		 StubViewDrawLine
// ---------------------------------------------------------------------------
// This is a stub routine that called the View object's method that draw
// a line.

void StubViewDrawLine (int xStart, int yStart, int xEnd, int yEnd)
{
	Platform::ViewDrawLine (xStart, yStart, xEnd, yEnd);
}


// ---------------------------------------------------------------------------
//		 StubViewDrawPixel
// ---------------------------------------------------------------------------
// This is a stub routine that called the View object's method that draw
// a pixel.

void StubViewDrawPixel (int xPos, int yPos)
{
	Platform::ViewDrawPixel (xPos, yPos);
}


