/* -*- mode: C++; tab-width: 4 -*- */
/* ================================================================================== */
/* Copyright (c) 1998-1999 3Com Corporation or its subsidiaries. All rights reserved. */
/* ================================================================================== */

#ifndef _CGREMLINS_H_
#define _CGREMLINS_H_

class SessionFile;

extern unsigned long int gGremlinNext;

class Gremlins
{
public:
				Gremlins();
				~Gremlins();

	void		New(const GremlinInfo& info);

	Boolean		IsInitialized() const;
	void		Initialize(UInt16 newNumber = -1, UInt32 untilStep = -1);

	void		Save(SessionFile &f);
	Boolean		Load(SessionFile &f);

	void		Status(UInt16 *currentNumber, UInt32 *currentStep,
					UInt32 *currentUntil);
	Boolean		SetSeed(UInt32 newSeed);
	void		SetUntil(UInt32 newUntil);

	void 		Step();
	void		Resume();
	void		Stop();


	Boolean		GetFakeEvent();
	void		GetPenMovement();
	Boolean 	SendCharsToType();

	void		BumpCounter();

	UInt32	GetStartTime()		{ return gremlinStartTime; }
	UInt32	GetStopTime()		{ return gremlinStopTime;  }

private:

	UInt16		keyProbabilitiesSum;	// The sum of all the key possiblities.
//	PointType	lastPoint;				// The previous point enqueued to TD.
	Int16		lastPointX, lastPointY;
	Boolean		lastPenDown;			// TRUE - last point caused a penDownEvent, FALSE - pen is up or already down.
	UInt16		number;					// the random seed (-1 means not started)
	UInt32		counter;				// The number of "events" produced by Gremlins.
	UInt32		until;					// The maximum number of "events" to produce.
	UInt32		saveUntil;
	Boolean		inited;					// TRUE - Gremlins has been initialized, FALSE - not inited.
	Boolean		catchUp;				// TRUE - Event loop needs time to catch up, FALSE - event loop doesn't need time.
	Boolean		needPenUp;				// TRUE - A pen up need to be enqueued, FALSE - pen up doesn't need to be  enqueued.
	char		charsToType[2048];		// Chars to send to the emulator.

	UInt32		gremlinStartTime;
	UInt32		gremlinStopTime;
};


#ifdef __cplusplus
extern "C" {
#endif

extern void GremlinsSendEvent (void);

extern void GremlinsProcessPacket (void* pktBodyP);

#ifdef __cplusplus 
}
#endif


#endif /* _CGREMLINS_H_ */

