/* -*- mode: C++; tab-width: 4 -*- */
/* ================================================================================== */
/* Copyright (c) 1998-1999 3Com Corporation or its subsidiaries. All rights reserved. */
/* ================================================================================== */

#ifndef _BANK_PLD_H_
#define _BANK_PLD_H_

class SessionFile;

class PLDBank
{
	public:
		static void				Initialize		(void);
		static void				Reset			(void);
		static void				Save			(SessionFile&);
		static void				Load			(SessionFile&);
		static void				Dispose			(void);

		static void				InstallHandlers	(void);

		static uae_u32			GetLong			(uaecptr iAddress);
		static uae_u32			GetWord			(uaecptr iAddress);
		static uae_u32			GetByte			(uaecptr iAddress);
		static void				SetLong			(uaecptr iAddress, uae_u32 iLongValue);
		static void				SetWord			(uaecptr iAddress, uae_u32 iWordValue);
		static void				SetByte			(uaecptr iAddress, uae_u32 iByteValue);
		static int				ValidAddress	(uaecptr iAddress, uae_u32 iSize);
		static uae_u8*			GetRealAddress	(uaecptr iAddress);

		static Bool				IsSerialPortOn	(void);

	private:
		static void				InvalidAccess	(uaecptr iAddress, long size, Bool forRead);
		static void				PreventedAccess	(uaecptr iAddress, long size, Bool forRead);

		friend class PLDReg;	// Calls PLDBank::InvalidAccess
};

#endif /* _BANK_PLD_H_ */
  
