/*
 * (C) Copyright Keith Visco 1998, 1999  All rights reserved.
 *
 * The program is provided "as is" without any warranty express or
 * implied, including the warranty of non-infringement and the implied
 * warranties of merchantibility and fitness for a particular purpose.
 * The Copyright owner will not be liable for any damages suffered by
 * you as a result of using the Program. In no event will the Copyright
 * owner be liable for any special, indirect or consequential damages or
 * lost profits even if the Copyright owner has been advised of the
 * possibility of their occurrence.
 */

package xslp.xml.parsers;

import org.w3c.dom.*;
import org.openxml.parser.XMLParser;
import org.openxml.*;
      
import java.io.Reader;
import java.io.PrintWriter;
/**
 * Creates a DOM Parser for use with the OpenXML package
 * @author Keith Visco (kvisco@ziplink.net)
**/
public class OpenXMLParser 
    implements com.kvisco.xml.parser.DOMPackage {
    
    private boolean validate = false;
    
      //----------------/    
     //- Constructors -/
    //----------------/    
    
    public OpenXMLParser() {
        super();
    }
    
      //---------------------------------------------------/    
     //- Interfaces for com.kvisco.xml.parser.DOMPackage -/
    //---------------------------------------------------/    
    
    /**
     * Creates a DOM Document using the DOM Package of this DOMReader
     * @return the new Document
    **/
    public Document createDocument() {
        return new org.openxml.dom.DocumentImpl();
    } //-- createDocument
    
    /**
     * Creates a DOM DocumentType using the DOM package of this DOMReader
     * @return the new DocumentType
    **/
    public void setDocumentType(Document document, String systemId) {
        //org.openxml.dom.DocumentTypeImpl dt = 
        //    new org.openxml.dom.DocumentTypeImpl(systemId);
        //((org.openxml.dom.DocumentImpl)document).assignDoctype(dt);
    } //-- setDocumentType
    
    /**
     * Sets whether or not to Validate the Document
     * @param validate a boolean indicating whether or not to
     * validate the Document
    **/
    public void setValidation(boolean validate) {
        this.validate = validate;
    } //-- setValidation

    /**
     * Reads an XML Document from the given Reader
     * @param reader the Reader for reading the XML stream
     * @param filename
     * @param errorWriter the PrintWriter to write all errors to
    **/
    public Document readDocument(Reader reader, String filename, PrintWriter errorWriter) {
        
		Document doc = null;
		try {
            XMLParser parser;
            short mode = XMLParser.MODE_PRESERVE_WS;
            mode = (short) (mode | XMLParser.MODE_STORE_PI);
            short stopAt = XMLParser.STOP_SEVERITY_WELL_FORMED;
            
	        if (validate) {
	            mode = (short) (mode | XMLParser.MODE_VALIDATE_XML_PARSER);
	            stopAt = XMLParser.STOP_SEVERITY_VALIDITY;
    		}
   		    parser = new XMLParser(reader, filename, mode, stopAt);
  		    doc = parser.parseDocument();
		}
		catch (Exception ex) {
		    errorWriter.println("error while trying to read document.");
		    errorWriter.println(" - " + ex.getMessage());
		    errorWriter.flush();
		}
		
		
        return doc;
		
	} //-- readDocument
    
} //-- OpenXMLParser

