/*
 * (C) Copyright Keith Visco 1998, 1999  All rights reserved.
 *
 * The program is provided "as is" without any warranty express or
 * implied, including the warranty of non-infringement and the implied
 * warranties of merchantibility and fitness for a particular purpose.
 * The Copyright owner will not be liable for any damages suffered by
 * you as a result of using the Program. In no event will the Copyright
 * owner be liable for any special, indirect or consequential damages or
 * lost profits even if the Copyright owner has been advised of the
 * possibility of their occurrence.
 */

package com.kvisco.xml.parser;

import org.w3c.dom.*;
import java.io.Reader;
import java.io.PrintWriter;

/**
 * This class is the basic interface the different DOM Packages need
 * to implement for XSL:P support. 
**/
public interface DOMPackage {
    
    
    /**
     * Creates a DOM Document for this DOMPackage
     * @return the new Document
    **/
    public Document createDocument();
    
    /**
     * Reads an XML Document from the given Reader.
     * @param reader the Reader for reading the XML stream
     * @param filename the filename used for reporting errors
     * @param errorWriter the PrintWriter to write all errors to
    **/
    public Document readDocument
        (Reader reader, String filename, PrintWriter errorWriter);
        
    /**
     * Sets the DocumentType for the given Document. The
     * Document must be a Document supported by this
     * DOMPackage
    **/
    public void setDocumentType(Document document, String systemId);
        
    /**
     * Sets whether or not to Validate the Document
     * @param validate a boolean indicating whether or not to
     * validate the Document
    **/
    public void setValidation(boolean validate);

    
} //-- DOMPackage

