/*
 * Decompiled with CFR 0.152.
 */
package org.openxml.io;

import java.io.IOException;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import org.openxml.DTDDocument;
import org.openxml.io.DTDPrinter;
import org.openxml.io.Printer;
import org.openxml.io.XMLStreamWriter;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentFragment;
import org.w3c.dom.DocumentType;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

public class XMLPrinter
extends Printer {
    public XMLPrinter(OutputStream outputStream, int n) throws IOException {
        this(new XMLStreamWriter(outputStream), n, 70, 4);
    }

    public XMLPrinter(OutputStream outputStream, String string, int n) throws IOException, UnsupportedEncodingException {
        this(new XMLStreamWriter(outputStream, string), n, 70, 4);
    }

    public XMLPrinter(Writer writer) throws IOException {
        this(writer, 0, 70, 4);
    }

    public XMLPrinter(Writer writer, int n) throws IOException {
        this(writer, n, 70, 4);
    }

    public XMLPrinter(Writer writer, int n, int n2, int n3) throws IOException {
        super(writer, n, n2, n3);
    }

    protected String getCharacterRef(char c) {
        switch (c) {
            case '<': {
                return "&lt;";
            }
            case '>': {
                return "&gt;";
            }
            case '\"': {
                return "&quot;";
            }
            case '\'': {
                return "&apos;";
            }
            case '&': {
                return "&amp;";
            }
        }
        return null;
    }

    public void print(Document document) throws IOException {
        this.printNode(document);
        this.flush();
    }

    public void print(DocumentFragment documentFragment) throws IOException {
        this.printNode(documentFragment);
        this.flush();
    }

    public void print(Element element) throws IOException {
        this.printNode(element);
        this.flush();
    }

    protected void printDocument(Node node, StringBuffer stringBuffer) throws IOException {
        if (node instanceof Document) {
            stringBuffer.append("<?xml version=\"1.0\"");
            if (this.getEncoding() != null) {
                stringBuffer.append(" encoding=\"").append(this.getEncoding()).append('\"');
            }
            if (this.mode(16)) {
                stringBuffer.append(" standalone=\"yes\"");
            }
            this.printPart(stringBuffer.append("?>"));
            DocumentType documentType = ((Document)node).getDoctype();
            if (documentType != null) {
                stringBuffer.setLength(0);
                stringBuffer.append("<!DOCTYPE ").append(documentType.getNodeName());
                if (documentType instanceof DTDDocument && !this.mode(16)) {
                    if (((DTDDocument)documentType).getPublicId() != null) {
                        stringBuffer.append(" PUBLIC ");
                        this.appendLiteral(stringBuffer, ((DTDDocument)documentType).getPublicId());
                        stringBuffer.append(" ");
                        this.appendLiteral(stringBuffer, ((DTDDocument)documentType).getSystemId());
                    } else if (((DTDDocument)documentType).getSystemId() != null) {
                        stringBuffer.append(" SYSTEM ");
                        this.appendLiteral(stringBuffer, ((DTDDocument)documentType).getSystemId());
                    }
                }
                this.printPart(stringBuffer.append(" ["));
                this.indent();
                if (!this.mode(2)) {
                    this.breakLine();
                }
                stringBuffer.setLength(0);
                DTDPrinter dTDPrinter = new DTDPrinter(this.getWriter(), this.getMode());
                dTDPrinter.printSubset(documentType, stringBuffer);
                this.unindent();
                if (!this.mode(2)) {
                    this.breakLine();
                }
                this.printPart("]>");
            }
        }
        this.breakLine();
        Node node2 = node.getFirstChild();
        while (node2 != null) {
            this.printNode(node2);
            node2 = node2.getNextSibling();
        }
        this.breakLine();
    }

    protected void printElement(Element element, StringBuffer stringBuffer) throws IOException {
        stringBuffer.append("<").append(element.getTagName());
        this.printPart(stringBuffer);
        NamedNodeMap namedNodeMap = element.getAttributes();
        int n = 0;
        while (n < namedNodeMap.getLength()) {
            Attr attr = (Attr)namedNodeMap.item(n);
            this.printSpace();
            stringBuffer.setLength(0);
            stringBuffer.append(attr.getName());
            if (attr.getValue() != null) {
                stringBuffer.append("=\"");
                stringBuffer.append(this.encode(attr.getValue(), true));
                stringBuffer.append('\"');
            }
            this.printPart(stringBuffer);
            ++n;
        }
        if (element.hasChildNodes()) {
            this.printPart(">");
            this.indent();
            int n2 = this.getMode();
            this.setMode(this.getMode() & 0xFFFFFFFD);
            Node node = element.getFirstChild();
            boolean bl = true;
            boolean bl2 = false;
            while (node != null) {
                if (node instanceof Element) {
                    if (this.mode(1) && bl) {
                        this.breakLine();
                        bl2 = true;
                    }
                    bl = true;
                } else {
                    bl = false;
                }
                this.printNode(node);
                node = node.getNextSibling();
            }
            if (bl && bl2) {
                this.breakLine();
            }
            stringBuffer.setLength(0);
            this.setMode(n2);
            this.unindent();
            stringBuffer.append("</").append(element.getTagName()).append('>');
            this.printPart(stringBuffer);
        } else {
            this.printPart("/>");
        }
    }
}

