/*
 * Decompiled with CFR 0.152.
 */
package org.openxml.source.holders;

import java.io.Serializable;
import org.openxml.source.Holder;
import org.openxml.source.Source;
import org.openxml.source.holders.HolderFinderImpl;
import org.openxml.util.Log;
import org.w3c.dom.Document;

public class SourceImpl
extends Source
implements Runnable,
Serializable {
    protected String _uri;
    protected String _publicId;
    protected String _encoding;
    protected Class _docClass;
    protected transient Document _document;
    protected transient Exception _lastException;
    protected boolean _readOnly;
    protected transient Thread _asyncThread;
    protected transient Holder _holder;

    public SourceImpl() {
        this(null, null, null, null);
    }

    public SourceImpl(String string, String string2, String string3, Class clazz) {
        this._uri = string;
        this._publicId = string2;
        this._encoding = string3;
        this._docClass = clazz;
    }

    public final synchronized void asynch() {
        if (this._asyncThread == null) {
            this._asyncThread = new Thread(this);
            this._asyncThread.start();
        }
    }

    public final synchronized void forget() {
        this._document = null;
        this._holder = null;
        this._lastException = null;
    }

    public static final Class getClassDTD() {
        return Source.DOCUMENT_DTD;
    }

    public static final Class getClassHTML() {
        return Source.DOCUMENT_HTML;
    }

    public static final Class getClassXML() {
        return Source.DOCUMENT_XML;
    }

    public Class getDocClass() {
        return this._docClass;
    }

    public final synchronized Document getDocument() {
        if (this._document == null) {
            this.run();
        }
        Document document = this._document;
        this._document = null;
        this.notifyComplete();
        return document;
    }

    public String getEncoding() {
        return this._encoding;
    }

    public final Exception getLastException() {
        return this._lastException;
    }

    public String getPublicId() {
        return this._publicId;
    }

    public String getURI() {
        return this._uri;
    }

    protected void notifyComplete() {
    }

    public final synchronized void run() {
        if (this._holder == null) {
            this._holder = HolderFinderImpl.getHolderFinder().findHolder(this);
        }
        if (this._holder != null && this._document == null) {
            this._document = this._readOnly ? this._holder.getReadOnly() : this._holder.newInstance();
            if (this._document != null) {
                this.setDocClass(this._document.getClass());
                if (this._holder.getEncoding() != null) {
                    this.setEncoding(this._holder.getEncoding());
                }
                this._lastException = this._holder.getLastException();
                if (this._lastException != null) {
                    Log.error("Source.getDocument/asynch: Error parsing document [" + this.toString() + "]");
                    Log.error(this._lastException);
                }
            }
        } else {
            Log.error("Source.getDocument/asynch: Could not locate document [" + this.toString() + "]");
        }
        this.notify();
        this._asyncThread = null;
        this.notifyComplete();
    }

    public synchronized void setDocClass(Class clazz) {
        this._docClass = clazz;
    }

    public synchronized void setEncoding(String string) {
        this._encoding = string;
    }

    public synchronized void setPublicId(String string) {
        this._publicId = string;
    }

    public synchronized void setReadOnly(boolean bl) {
        this._readOnly = bl;
    }

    public synchronized void setURI(String string) {
        this._uri = string;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer("Source:");
        if (this._uri != null) {
            stringBuffer.append(" URI [").append(this._uri).append("]");
        }
        if (this._publicId != null) {
            stringBuffer.append(" PublicID [").append(this._publicId).append("]");
        }
        if (this._encoding != null) {
            stringBuffer.append(" Encoding [").append(this._encoding).append("]");
        }
        if (this._docClass != null) {
            stringBuffer.append(" DocClassName [").append(this._docClass.getName()).append("]");
        }
        if (this._holder != null) {
            stringBuffer.append(" Loaded");
        }
        return stringBuffer.toString();
    }
}

