
import java.sql.*;


/**
 * test the setMaxRows() method
 *
 */
public class t0003
{
   static public boolean passed = true;

   static public void main(String args[])
      throws SQLException, java.lang.ClassNotFoundException, java.lang.Exception
   {
      System.out.println("test the setMaxRows() method");

      // open the database
      Class.forName("com.internetcds.jdbc.tds.Driver");

      int         i;
      int         count    = 0;
      Connection  cx       = Common.getConnection();
      Statement   stmt     = cx.createStatement();

      try
      {
         stmt.executeUpdate("drop table t0003");
      }
      catch (SQLWarning e)
      {
         if (! (e.getMessage().startsWith("Cannot drop the table 't0003', because it does")))
         {
            throw e;
         }
      }
      
      count = stmt.executeUpdate("create table t0003              "
                                 + "  (i  integer not null)       ");
      System.out.println("Creating table affected " + count + " rows");
      
      PreparedStatement  pStmt = cx.prepareStatement(
         "insert into t0003 values (?)");
      
      final int rowsToAdd = 100;
      count = 0;
      for(i=1; i<=rowsToAdd; i++)
      {
         pStmt.setInt(1, i);
         count += pStmt.executeUpdate();
      }
      System.out.println("Added " + count + " rows");
      if (count != rowsToAdd)
      {
         throw new Exception("Did not add the correct number of rows");
      }

      
      pStmt = cx.prepareStatement(
         "select i from t0003 order by i");
      int   rowLimit = 32;
      pStmt.setMaxRows(rowLimit);
      
      if (pStmt.getMaxRows() != rowLimit)
      {
         throw new Exception("setMaxRow() and getMaxRow() can't agree");
      }
      ResultSet  rs = pStmt.executeQuery();
      count = 0;
      while(rs.next())
      {
         int   n = rs.getInt("i");
         System.out.println("row is " + n);
         count++;
      }
      if (count != rowLimit)
      {
         throw new Exception("setMaxRow() didn't limit the # of rows");
      }
      System.out.println("Read " + count + " rows");




      rowLimit = 32;
      stmt.setMaxRows(rowLimit);
      rs = stmt.executeQuery("select * from t0003");
      
      if (stmt.getMaxRows() != rowLimit)
      {
         throw new Exception("setMaxRow() and getMaxRow() can't agree");
      }
      count = 0;
      while(rs.next())
      {
         int   n = rs.getInt("i");
         System.out.println("row is " + n);
         count++;
      }
      if (count != rowLimit)
      {
         throw new Exception("setMaxRow() didn't limit the # of rows");
      }
      System.out.println("Read " + count + " rows");


      rowLimit = 0;
      stmt.setMaxRows(rowLimit);
      rs = stmt.executeQuery("select * from t0003");
      
      if (stmt.getMaxRows() != rowLimit)
      {
         throw new Exception("setMaxRow() and getMaxRow() can't agree");
      }
      count = 0;
      while(rs.next())
      {
         int   n = rs.getInt("i");
         System.out.println("row is " + n);
         count++;
      }
      if (count != rowsToAdd)
      {
         throw new Exception("setMaxRow() didn't limit the # of rows");
      }
      System.out.println("Read " + count + " rows");

      System.out.println("\n" + (passed ? "Passed" : "Failed") 
                         + " t0003.\n");
      System.exit(passed ? 0 : 1);
   }
}

