open Safestd
open Safetk
open Safeapplets
open Safemmm

module Provide = struct
  let capabilities = Capabilities.get()
  end

module Mmm = Safemmm.Get(Provide)

open Printf
open Html
open Hyper
open Viewers


(* We remap frames to links *)
let _ =
   Mmm.add_html_display_hook (fun mach ->
     let cnter = ref 0 in
     mach#add_tag "frame" 
       (fun fo t ->
	 let src = get_attribute t "src" in
	 let name = try sprintf "Frame %s" (get_attribute t "name")
                    with Not_found -> (incr cnter; sprintf "frame%d" !cnter)
         in
	  mach#send (OpenTag {tag_name = "link";
			      attributes = ["rel", sprintf "%s (%s)" name src;
					    "href", src]}))
       (fun _ -> ()))
	 
