/*

------------------------------------------------------------------------------

A license is hereby granted to reproduce this software source code and
to create executable versions from this source code for personal,
non-commercial use.  The copyright notice included with the software
must be maintained in all copies produced.

THIS PROGRAM IS PROVIDED "AS IS". THE AUTHOR PROVIDES NO WARRANTIES
WHATSOEVER, EXPRESSED OR IMPLIED, INCLUDING WARRANTIES OF
MERCHANTABILITY, TITLE, OR FITNESS FOR ANY PARTICULAR PURPOSE.  THE
AUTHOR DOES NOT WARRANT THAT USE OF THIS PROGRAM DOES NOT INFRINGE THE
INTELLECTUAL PROPERTY RIGHTS OF ANY THIRD PARTY IN ANY COUNTRY.

Copyright (c) 1995, John Conover, All Rights Reserved.

Comments and/or bug reports should be addressed to:

    john@johncon.com (John Conover)

------------------------------------------------------------------------------

bmhsearch.h, general include file for bmhsearch.c

$Revision: 1.0 $
$Date: 1995/04/22 05:14:50 $
$Id: bmhsearch.h,v 1.0 1995/04/22 05:14:50 john Exp $
$Log: bmhsearch.h,v $
 * Revision 1.0  1995/04/22  05:14:50  john
 * Initial revision
 *

*/

#ifndef _BMHSEARCH_H /* if not defined then searchfile.h has not yet been included */

#define _BMHSEARCH_H

#define BMHSEARCH_H_ID "$Id: bmhsearch.h,v 1.0 1995/04/22 05:14:50 john Exp $" /* module version */

typedef struct bmhpattern_struct /* pattern element structure */
{
    unsigned char *pattern; /* reference to pattern */
    int *table; /* reference to pattern jump table */
    int length; /* length of pattern */
    int count; /* count of matches for this pattern */
    struct bmhpattern_struct *next; /* reference to next bmhpattern structure in list */
} BMHPATTERN;

#ifdef __STDC__

extern BMHPATTERN *bmhcompile_postfix (ELEMENT *postfix_list);
extern void bmhsearch_list (unsigned char *page, int count, BMHPATTERN *bmhlist);

#else

extern BMHPATTERN *bmhcompile_postfix ();
extern void bmhsearch_list ();

#endif

#endif
