/*************************************************************************/
/*                                                                       */
/*                Centre for Speech Technology Research                  */
/*                     University of Edinburgh, UK                       */
/*                         Copyright (c) 1996                            */
/*                        All Rights Reserved.                           */
/*                                                                       */
/*  Permission to use, copy, modify, distribute this software and its    */
/*  documentation for research, educational and individual use only, is  */
/*  hereby granted without fee, subject to the following conditions:     */
/*   1. The code must retain the above copyright notice, this list of    */
/*      conditions and the following disclaimer.                         */
/*   2. Any modifications must be clearly marked as such.                */
/*   3. Original authors' names are not deleted.                         */
/*  This software may not be used for commercial purposes without        */
/*  specific prior written permission from the authors.                  */
/*                                                                       */
/*  THE UNIVERSITY OF EDINBURGH AND THE CONTRIBUTORS TO THIS WORK        */
/*  DISCLAIM ALL WARRANTIES WITH REGARD TO THIS SOFTWARE, INCLUDING      */
/*  ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS, IN NO EVENT   */
/*  SHALL THE UNIVERSITY OF EDINBURGH NOR THE CONTRIBUTORS BE LIABLE     */
/*  FOR ANY SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES    */
/*  WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN   */
/*  AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION,          */
/*  ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE OF       */
/*  THIS SOFTWARE.                                                       */
/*                                                                       */
/*************************************************************************/
/*                       Author: Paul Taylor                             */
/*                       Date  : April 1996                              */
/*-----------------------------------------------------------------------*/
/*                  Multivariate Statistical Techniques                  */
/*                                                                       */
/*=======================================================================*/
#include "EST.h"
#include "EST_multistats.h"

int main(int argc, char *argv[])
{
    EST_String out_file;
    EST_StrList files;
    EST_Option al, op;
    EST_FMatrix m, c;
    EST_FVector u, v;
    float f;

    print_help(argc, argv);

    parse_command_line(argc, argv, "-covar -corr -det -inv -mean -norm -std \n\
		 -trans -var", files, al);

    init_lib_ops(al, op);

    out_file = al.present("-o") ? al.val("-o") : (EST_String)"-";

    m.load(files.first());

    if (al.present("-det"))
    {
	f = determinant(m);
	cout << "determinant\n" << f;
    }
    
    if (al.present("-inv"))
    {
	c = inverse(m);
	cout << "inverse\n" << c;
    }

    if (al.present("-trans"))
    {
	c = transpose(m);
	cout << c;
    }
    
    if (al.present("-var"))
    {
	v = sample_variance(m);
	cout << v;
    }
    
    if (al.present("-std"))
    {
	v = sample_stdev(m);
	cout << v;
    }
    
    if (al.present("-mean"))
    {
	v = mean(m);
	cout << v;
    }
    
    if (al.present("-covar"))
    {
	c = sample_covariance(m);
	cout << c;
    }

    if (al.present("-corr"))
    {
	c = sample_correlation(m);
	cout << c;
    }

    if (al.present("-norm"))
    {
	EST_FMatrix z;
	u = mean(m);
	v = sample_stdev(m);
	z = normalise(m, u, v);
	cout << z;
    }
    return 0;
}

void override_lib_ops(EST_Option &a_list, EST_Option &al)
{
    (void)a_list;
    (void)al;
}

void print_help(int argc, char *argv[])
{
    for (int i = 0;i < argc; ++i)
	if (strncmp(argv[i],"-help", 2) == 0)
	{
	    cout << "Usage:\n";
	    cout << "ch_lab  <input matrix> <options>\n";
	    cout << "use \"-\" to make input and output files stdin/out\n";
	    cout << "-h      options help\n";
	    exit (0);
	}
}
