/*************************************************************************/
/*                                                                       */
/*                Centre for Speech Technology Research                  */
/*                     University of Edinburgh, UK                       */
/*                         Copyright (c) 1996                            */
/*                        All Rights Reserved.                           */
/*                                                                       */
/*  Permission to use, copy, modify, distribute this software and its    */
/*  documentation for research, educational and individual use only, is  */
/*  hereby granted without fee, subject to the following conditions:     */
/*   1. The code must retain the above copyright notice, this list of    */
/*      conditions and the following disclaimer.                         */
/*   2. Any modifications must be clearly marked as such.                */
/*   3. Original authors' names are not deleted.                         */
/*  This software may not be used for commercial purposes without        */
/*  specific prior written permission from the authors.                  */
/*                                                                       */
/*  THE UNIVERSITY OF EDINBURGH AND THE CONTRIBUTORS TO THIS WORK        */
/*  DISCLAIM ALL WARRANTIES WITH REGARD TO THIS SOFTWARE, INCLUDING      */
/*  ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS, IN NO EVENT   */
/*  SHALL THE UNIVERSITY OF EDINBURGH NOR THE CONTRIBUTORS BE LIABLE     */
/*  FOR ANY SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES    */
/*  WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN   */
/*  AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION,          */
/*  ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE OF       */
/*  THIS SOFTWARE.                                                       */
/*                                                                       */
/*************************************************************************/
/*                      Authors:  Paul Taylor                            */
/*                      Date   :  April 1996                             */
/*-----------------------------------------------------------------------*/
/*                    Calculate Confusion Matrix                         */
/*                                                                       */
/*=======================================================================*/
#include "EST.h"
#include "EST_multistats.h"
#include "EST_Token.h"

void read_results(EST_String file, EST_StrStr_KVL &list);
void read_lex(EST_String file, EST_StrList &lex);

int main(int argc, char *argv[])
{
    EST_StrList files;
    EST_String out_file;
    EST_Option al, op;
    EST_StrStr_KVL list;
    EST_StrList lex;
    EST_FMatrix m;

    print_help(argc, argv);

    parse_command_line(argc, argv, "-l:s -o:s", files, al);
    init_lib_ops(al, op);

    out_file = al.present("-o") ? al.val("-o") : (EST_String)"-";

    read_results(files.first(), list);
    read_lex(al.val("-l"), lex);

//    cout << "List\n";
//
//    for (p = list.list.head(); p != 0; p = next(p))
//	cout << list.key(p) << " " << list.val(p) << endl;;

//    cout << "Lex\n";
//    for (p = lex.head(); p != 0; p = next(p))
//	cout << lex(p) << endl;;

    m = confusion(list, lex);

    print_confusion(m, list, lex);
    
    m.save(out_file);
    return 0;
}

void read_results(EST_String file, EST_StrStr_KVL &list)
{
    EST_TokenStream ts;

    if (ts.open(file) == -1)
    {
	cerr << "Can't open results file " << file << endl;
	exit (0);
    }

    while (!ts.eof())
    {
	EST_String real = ts.get();
	EST_String predict = ts.get();
	if (!ts.eoln())
	    cerr << "Missing argument for key " << real;
	list.add_item(real,predict,1);
    }

    ts.close();
}

void read_lex(EST_String file, EST_StrList &list)
{
    EST_TokenStream ts;

    if (ts.open(file) == -1)
    {
	cerr << "Can't open lexicon file " << file << endl;
	exit (0);
    }

    while (!ts.eof())
	list.append(ts.get());

    ts.close();
}

void override_lib_ops(EST_Option &a_list, EST_Option &al)
{
    (void)a_list;
    (void)al;
}

void print_help(int argc, char *argv[])
{
    for (int i = 0;i < argc; ++i)
	if (strncmp(argv[i],"-help", 2) == 0)
	{
	    cout << "Usage:\n";
	    cout << "confusion  <options> <results-file>\n";
	    cout << "use \"-\" to make input and output files stdin/out\n";
	    cout << "-l:s      lexicon file\n";
	    cout << "-o:s      output file for confusion matrix\n";
	    exit (0);
	}
}
