/*************************************************************************/
/*                                                                       */
/*                Centre for Speech Technology Research                  */
/*                     University of Edinburgh, UK                       */
/*                      Copyright (c) 1995,1996                          */
/*                        All Rights Reserved.                           */
/*                                                                       */
/*  Permission to use, copy, modify, distribute this software and its    */
/*  documentation for research, educational and individual use only, is  */
/*  hereby granted without fee, subject to the following conditions:     */
/*   1. The code must retain the above copyright notice, this list of    */
/*      conditions and the following disclaimer.                         */
/*   2. Any modifications must be clearly marked as such.                */
/*   3. Original authors' names are not deleted.                         */
/*  This software may not be used for commercial purposes without        */
/*  specific prior written permission from the authors.                  */
/*                                                                       */
/*  THE UNIVERSITY OF EDINBURGH AND THE CONTRIBUTORS TO THIS WORK        */
/*  DISCLAIM ALL WARRANTIES WITH REGARD TO THIS SOFTWARE, INCLUDING      */
/*  ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS, IN NO EVENT   */
/*  SHALL THE UNIVERSITY OF EDINBURGH NOR THE CONTRIBUTORS BE LIABLE     */
/*  FOR ANY SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES    */
/*  WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN   */
/*  AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION,          */
/*  ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE OF       */
/*  THIS SOFTWARE.                                                       */
/*                                                                       */
/*************************************************************************/
/*                      Author :  Paul Taylor                            */
/*                      Date   :  June 1995                              */
/*-----------------------------------------------------------------------*/
/*                     Stream linked list class                          */
/*                                                                       */
/*=======================================================================*/
#ifndef __STREAM_IO_H__
#define __STREAM_IO_H__

#include "EST_Stream.h"
#include "EST_String.h"
#include "EST_Token.h"
#include "EST_rw_status.h"

EST_read_status load_esps_label(EST_String filename, EST_Stream &s, EST_String comment = ";");

EST_read_status load_htk_label(EST_String filename, EST_Stream &s);
EST_read_status load_ogi_label(EST_String filename, EST_Stream &s);

EST_read_status load_sample_label(EST_String filename, EST_Stream &s, int sample);
EST_read_status load_words_label(EST_String filename, EST_Stream &s);

EST_write_status save_label_esps(EST_String filename, EST_Stream &a, int num);
EST_write_status save_label_htk(EST_String filename, EST_Stream &a);
EST_write_status save_label_spn(EST_String filename, EST_Stream &a);
EST_write_status save_label_names(EST_String filename, EST_Stream &a, int n=0);

void parse_fields(const EST_String &s, EST_StrList &l);
EST_read_status read_esps_portion(EST_TokenStream &ts, EST_Stream &s);

#endif /* __stream_io.h__ */
