/*************************************************************************/
/*                                                                       */
/*                Centre for Speech Technology Research                  */
/*                     University of Edinburgh, UK                       */
/*                      Copyright (c) 1995,1996                          */
/*                        All Rights Reserved.                           */
/*                                                                       */
/*  Permission to use, copy, modify, distribute this software and its    */
/*  documentation for research, educational and individual use only, is  */
/*  hereby granted without fee, subject to the following conditions:     */
/*   1. The code must retain the above copyright notice, this list of    */
/*      conditions and the following disclaimer.                         */
/*   2. Any modifications must be clearly marked as such.                */
/*   3. Original authors' names are not deleted.                         */
/*  This software may not be used for commercial purposes without        */
/*  specific prior written permission from the authors.                  */
/*                                                                       */
/*  THE UNIVERSITY OF EDINBURGH AND THE CONTRIBUTORS TO THIS WORK        */
/*  DISCLAIM ALL WARRANTIES WITH REGARD TO THIS SOFTWARE, INCLUDING      */
/*  ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS, IN NO EVENT   */
/*  SHALL THE UNIVERSITY OF EDINBURGH NOR THE CONTRIBUTORS BE LIABLE     */
/*  FOR ANY SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES    */
/*  WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN   */
/*  AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION,          */
/*  ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE OF       */
/*  THIS SOFTWARE.                                                       */
/*                                                                       */
/*************************************************************************/
/*                    Author :  Paul Taylor                              */
/*                    Date   :  June 1995                                */
/*-----------------------------------------------------------------------*/
/*             Instantiation of template functions                       */
/*                                                                       */
/*=======================================================================*/

// This file is to instaniate template functions. This is necessary
// due to the strange nature of templates in C++. In future this should
// be redundant.
#include "EST_String.h"

#include "EST_Stream.h"
#include "EST_Track.h"
#include "EST_Wave.h"

#include "EST_KV.h"
#include "EST_TMatrix.h"
#include "EST_TVector.h"

#if defined(INSTANTIATE_TEMPLATES)

#include "../base_class/EST_TList.cc"
#include "../base_class/EST_TSortable.cc"
#include "../base_class/EST_KV.cc"
#include "../base_class/EST_TMatrix.cc"
#include "../base_class/EST_TVector.cc"

template class EST_TList<EST_Stream>;
template class EST_TItem<EST_Stream>;
template class EST_TList<EST_Track>;
template class EST_TItem<EST_Track>;
template class EST_TList<EST_Relation>;
template class EST_TItem<EST_Relation>;
template class EST_TList<EST_Wave>;
template class EST_TItem<EST_Wave>;

template class EST_TList<EST_Val>;
template class EST_TItem<EST_Val>;
template class EST_TList<int>;
template class EST_TItem<int>;
template class EST_TList<float>;
template class EST_TItem<float>;
template class EST_TList<double>;
template class EST_TItem<double>;
template class EST_TList<EST_TList<int> >;
template class EST_TItem<EST_TList<int> >;
template class EST_TList<EST_String>;
template class EST_TItem<EST_String>;
template class EST_TSortable<EST_String>;
template class EST_TList<EST_StrVector>;
template class EST_TItem<EST_StrVector>;

template class KVL<EST_String, EST_String>;
template class KVI<EST_String, EST_String>;
template class KVL<EST_String, int>;
template class KVI<EST_String, int>;
template class KVL<EST_String, float>;
template class KVI<EST_String, float>;
template class KVL<EST_String, double>;
template class KVI<EST_String, double>;
template class KVL<EST_String, EST_Val>;
template class KVI<EST_String, EST_Val>;
template class KVL<int, int>;
template class KVI<int, int>;

//template class KVI<float, int>;

// for sparse vectors
template class EST_TList< KVI<float, int> >;
template class EST_TItem< KVI<float, int> >;

template class EST_TMatrix<float>;
template class EST_TMatrix<int>;

template class EST_TVector<double>;
template class EST_TVector<float>;
template class EST_TVector<int>;
template class EST_TVector<EST_String>;

template void sort_unique(EST_StrList &l);
template void sort(EST_StrList &l);

//delete?? 
//template class EST_TVector< EST_TList<EST_String> >;

//  The following are unfortunately required by gcc-2.6.x, even though
//  they could be deleted in 2.7.2.
template class EST_TList<KVI<int, int> >;
template class EST_TItem<KVI<int, int> >;
template class EST_TList<KVI<EST_String, EST_String> >;
template class EST_TItem<KVI<EST_String, EST_String> >;
template class EST_TList<KVI<EST_String, int> >;
template class EST_TItem<KVI<EST_String, int> >;
template class EST_TList<KVI<EST_String, float> >;
template class EST_TItem<KVI<EST_String, float> >;
template class EST_TList<KVI<EST_String, double> >;
template class EST_TItem<KVI<EST_String, double> >;

template ostream& operator << (ostream &st, const EST_TList<EST_String> &list);
template ostream& operator << (ostream &st, const EST_TList<int> &list);
template ostream& operator << (ostream &st, const EST_TList<float> &list);
template ostream& operator << (ostream &st, const EST_TList<double> &list);
template ostream& operator << (ostream &st, const EST_TVector<EST_String> &v);
template ostream& operator << (ostream &st, const EST_TVector<float> &v);
template ostream& operator << (ostream &st, const EST_TVector<double> &v);

template ostream& operator << (ostream &st, const EST_TMatrix<int> &v);
template ostream& operator << (ostream &st, const EST_TMatrix<float> &v);


bool operator==(const EST_TList<EST_String> &a,const EST_TList<EST_String> &b);

template class EST_TList<KVI<EST_String, EST_Val> >;
template class EST_TItem<KVI<EST_String, EST_Val> >;
#endif


// this is the only way I could get this to compile. I'm lost as to
// how to do it properly through templates.

// Earlier versions of gcc require explicit instatiation of these functions

ostream& operator << (ostream &st, const KVL<int, int> &x)
{
    EST_TBI *ptr;
    
    for (ptr = x.list.head(); ptr != 0; ptr= next(ptr))
	cout << x.list.item_C(ptr).k << "\t" << x.list.item_C(ptr).v << endl;
    
    st << endl;
    return st;
}

ostream& operator << (ostream &st, const KVL<EST_String, int> &x)
{
    EST_TBI *ptr;
    
    for (ptr = x.list.head(); ptr != 0; ptr= next(ptr))
	cout << x.list.item_C(ptr).k << "\t" << x.list.item_C(ptr).v << endl;
    
    st << endl;
    return st;
}

