/*************************************************************************/
/*                                                                       */
/*                Centre for Speech Technology Research                  */
/*                     University of Edinburgh, UK                       */
/*                      Copyright (c) 1995,1996                          */
/*                        All Rights Reserved.                           */
/*                                                                       */
/*  Permission to use, copy, modify, distribute this software and its    */
/*  documentation for research, educational and individual use only, is  */
/*  hereby granted without fee, subject to the following conditions:     */
/*   1. The code must retain the above copyright notice, this list of    */
/*      conditions and the following disclaimer.                         */
/*   2. Any modifications must be clearly marked as such.                */
/*   3. Original authors' names are not deleted.                         */
/*  This software may not be used for commercial purposes without        */
/*  specific prior written permission from the authors.                  */
/*                                                                       */
/*  THE UNIVERSITY OF EDINBURGH AND THE CONTRIBUTORS TO THIS WORK        */
/*  DISCLAIM ALL WARRANTIES WITH REGARD TO THIS SOFTWARE, INCLUDING      */
/*  ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS, IN NO EVENT   */
/*  SHALL THE UNIVERSITY OF EDINBURGH NOR THE CONTRIBUTORS BE LIABLE     */
/*  FOR ANY SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES    */
/*  WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN   */
/*  AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION,          */
/*  ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE OF       */
/*  THIS SOFTWARE.                                                       */
/*                                                                       */
/*************************************************************************/
/*                    Author :  Paul Taylor                              */
/*                    Date   :  May 1995                                 */
/*-----------------------------------------------------------------------*/
/*                  EST_Utterance Class header file                      */
/*                                                                       */
/*=======================================================================*/
#ifndef __Utterance_H__
#define __Utterance_H__

#include "EST_String.h"
#include "EST_Stream.h"
#include "EST_TList.h"

class EST_Utterance{
private:
    int refcount;  // used to keep track of LISP refs to this utt
public:
    EST_Utterance();
    ~EST_Utterance() {clear();}
    void add_ref(void) { refcount++; }
    int del_ref(void)  { return --refcount; }

    void init();
    EST_TList<EST_Stream> s;

    int create_stream(const EST_String &name); // make new stream
    void remove_stream(const EST_String &name); //rm stream & contents from utt
    int stream_present(const EST_String &name);

    EST_Stream & stream(const EST_String &name);
    EST_Stream_Item *item(const EST_String &s, int add);
    EST_Stream_Item &ritem(const EST_String &s, int add);

    void remove_item(const EST_String &s, int add);

    EST_Relation &rlink(const EST_String &s, int add, const EST_String &r);

    EST_read_status load(const EST_String &filename);
    EST_write_status save(const EST_String &filename, int num);

    void clear();

    friend ostream& operator << (ostream &s, const EST_Utterance &u);
};

#endif
