/*************************************************************************/
/*                                                                       */
/*                Centre for Speech Technology Research                  */
/*                     University of Edinburgh, UK                       */
/*                      Copyright (c) 1995,1996                          */
/*                        All Rights Reserved.                           */
/*                                                                       */
/*  Permission to use, copy, modify, distribute this software and its    */
/*  documentation for research, educational and individual use only, is  */
/*  hereby granted without fee, subject to the following conditions:     */
/*   1. The code must retain the above copyright notice, this list of    */
/*      conditions and the following disclaimer.                         */
/*   2. Any modifications must be clearly marked as such.                */
/*   3. Original authors' names are not deleted.                         */
/*  This software may not be used for commercial purposes without        */
/*  specific prior written permission from the authors.                  */
/*                                                                       */
/*  THE UNIVERSITY OF EDINBURGH AND THE CONTRIBUTORS TO THIS WORK        */
/*  DISCLAIM ALL WARRANTIES WITH REGARD TO THIS SOFTWARE, INCLUDING      */
/*  ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS, IN NO EVENT   */
/*  SHALL THE UNIVERSITY OF EDINBURGH NOR THE CONTRIBUTORS BE LIABLE     */
/*  FOR ANY SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES    */
/*  WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN   */
/*  AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION,          */
/*  ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE OF       */
/*  THIS SOFTWARE.                                                       */
/*                                                                       */
/*************************************************************************/
/*                      Author :  Paul Taylor                            */
/*                      Date   :  May 1995                               */
/*-----------------------------------------------------------------------*/
/*                 Key/value List Class source file                      */
/*                                                                       */
/*=======================================================================*/

#include <stdlib.h>
#include "EST_KV.h"

template <class K, class V> KVL<K, V>::KVL(KVL<K, V> &kv)
{
    list = kv.list;
}

// look for key rkey in list. If found, change its value to rval and
// return true, otherwise return false.
template <class K, class V> 
int KVL<K, V>::change_item(const K &rkey,const V &rval)
{
    EST_TBI *ptr;

    for (ptr = list.head(); ptr != 0; ptr= next(ptr))
	if (list.item(ptr).k == rkey)
	{
	    list.item(ptr).v = rval;
	    return 1;
	}

    return 0;
}

template <class K, class V> 
void KVL<K, V>::clear(void)
{
    list.clear();
}

// look for pointer kptr in list. If found, change its value to rval and
// return true, otherwise return false.

template <class K, class V> 
int KVL<K, V>::change_item(EST_TBI *kptr, const V &rval)
{
    EST_TBI *ptr;

    for (ptr = list.head(); ptr != 0; ptr= next(ptr))
	if (ptr == kptr)
	{
	    list.item(ptr).v = rval;
	    return 1;
	}
    return 0;
}

template <class K, class V> 
int KVL<K, V>::change_key(EST_TBI *kptr, const K &rkey)
{
    EST_TBI *ptr;

    for (ptr = list.head(); ptr != 0; ptr= next(ptr))
	if (ptr == kptr)
	{
	    list.item(ptr).k = rkey;
	    return 1;
	}
    return 0;
}

// Warning - undefined behaviour in case where key isn't found
template<class K, class V> 
const V &KVL<K, V>::val(const K &rkey, int must) const
{ 
    EST_TBI *ptr;
    
    for (ptr = list.head(); ptr != 0; ptr= next(ptr))
	if (list.item_C(ptr).k == rkey)
	    return list.item_C(ptr).v;
    
    if (must)
	cerr << "Error: No value set for " << rkey << endl;
    exit(0);
    static V dummyV;
    return dummyV;
}

template<class K, class V> 
const V &KVL<K, V>::val_def(const K &rkey, const V &def) const
{ 
    EST_TBI *ptr;
    
    for (ptr = list.head(); ptr != 0; ptr= next(ptr))
	if (list.item_C(ptr).k == rkey)
	    return list.item_C(ptr).v;

    return def;
}

template<class K, class V> 
const V &KVL<K, V>::valp(EST_TBI *kptr, int must) const
{ 
    if (must == 0)
	return list.item_C(kptr).v;
    else   /* check kptr is one of mine */
    {
	EST_TBI *ptr;
	for (ptr = list.head(); ptr != 0; ptr= next(ptr))
	    if (ptr == kptr)
		return list.item_C(kptr).v;
	cerr << "Error: No value set in KVL \n";
	// What should I do here?  The following will be uninitialized 
	// if V is a C base clase (int float etc)
	exit(0);
//	V def;
//	return def;
    }
    static V dummyV;
    return dummyV;
}

template<class K, class V> 
const K &KVL<K, V>::key(EST_TBI *kptr, int must) const
{ 
    if (must == 0)
	return list.item_C(kptr).k;
    else
    {
	EST_TBI *ptr;
	for (ptr = list.head(); ptr != 0; ptr= next(ptr))
	    if (ptr == kptr)
		return list.item_C(ptr).k;
	cerr << "Error: No key set in KVL \n";
	// What should I do here?  The following will be uninitialized 
	// if V is a C base clase (int float etc), worse itll be a reference
	// to a local variable
	exit(0);
//	K def;
//	return def;
    }
    static K dummyK;
    return dummyK;
}


template<class K, class V> 
const int KVL<K, V>::present(const K &rkey) const
{ 
    EST_TBI *ptr;
    
    for (ptr = list.head(); ptr != 0; ptr= next(ptr))
	if (list.item_C(ptr).k == rkey)
	    return 1;
    
    return 0;
}

// map a function over the pairs

template<class K, class V>
void KVL<K,V>::map(void (*func)(K&, V&))
{
  EST_TBI *p;
  for(p=list.head(); p; p=next(p))
    {
      KVI<K,V> item = list.item(p);
      (*func)(item.k, item.v);
    }
}

// add item to list. By default, the list is searched to see if the
// item exists already. If so, its value is overwritten. This facility
// can be turned off by setting no_search = 1;

template<class K, class V> 
int KVL<K, V>::add_item(const K rkey, const V rval, int no_search)
{
    KVI<K,V>  item;
    if (!no_search)
	if (change_item(rkey, rval)) // first see if key exists
	    return 1;

    item.k = rkey;
    item.v = rval;

    list.append(item);
    return 1;
}

template<class K, class V> KVL<K, V> &KVL<K, V>::operator = 
                 (const KVL<K, V> &kv)
{
    list = kv.list;
    return *this;
}

template<class K, class V> KVL<K, V> &KVL<K, V>::operator += 
                 (const KVL<K, V> &kv)
{
    list += kv.list;
    return *this;
}

template<class K, class V> KVL<K, V> KVL<K, V>::operator + (const KVL<K, V> &kv)
{
    KVL<K, V> result;
    result = *this;
    result += kv;
    return result;
}

template<class K, class V>
ostream& operator << (ostream& s, const KVI<K,V> &i)
{
  s << i.k << "\t" << i.v << endl;
  return s;
}
