/*************************************************************************/
/*                                                                       */
/*                Centre for Speech Technology Research                  */
/*                     University of Edinburgh, UK                       */
/*                      Copyright (c) 1995,1996                          */
/*                        All Rights Reserved.                           */
/*                                                                       */
/*  Permission to use, copy, modify, distribute this software and its    */
/*  documentation for research, educational and individual use only, is  */
/*  hereby granted without fee, subject to the following conditions:     */
/*   1. The code must retain the above copyright notice, this list of    */
/*      conditions and the following disclaimer.                         */
/*   2. Any modifications must be clearly marked as such.                */
/*   3. Original authors' names are not deleted.                         */
/*  This software may not be used for commercial purposes without        */
/*  specific prior written permission from the authors.                  */
/*                                                                       */
/*  THE UNIVERSITY OF EDINBURGH AND THE CONTRIBUTORS TO THIS WORK        */
/*  DISCLAIM ALL WARRANTIES WITH REGARD TO THIS SOFTWARE, INCLUDING      */
/*  ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS, IN NO EVENT   */
/*  SHALL THE UNIVERSITY OF EDINBURGH NOR THE CONTRIBUTORS BE LIABLE     */
/*  FOR ANY SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES    */
/*  WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN   */
/*  AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION,          */
/*  ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE OF       */
/*  THIS SOFTWARE.                                                       */
/*                                                                       */
/*************************************************************************/
/*             Author :  Paul Taylor                                     */
/*             Date   :  June 1996                                       */
/*-----------------------------------------------------------------------*/
/*                  HMM Class Source                                     */
/*                                                                       */
/*=======================================================================*/

#include "HMM.h"
#include "EST.h"
#include "fstream.h"
#include "iostream.h"


int parse_global(EST_TokenStream &ts, int &n_streams, int &v_size,
		 EST_String &c_kind, EST_String &d_kind, EST_String &s_kind);


EST_read_status load_HMMList(EST_String filename, EST_HMMList &hlist)
{
    EST_TokenStream ts;
    EST_String fns, name;
    HMM s;
    int n_streams, v_size;
    EST_String covkind, durkind, sampkind;
        
    if (((filename == "-") ? ts.open(cin) : ts.open(filename)) != 0)
    {
	cerr << "Can't open label input file " << filename << endl;
	return misc_read_error;
    }
    // set up the character constant values for this stream
    ts.set_SingleCharSymbols(";");

    if (parse_global(ts, n_streams, v_size, covkind, durkind, sampkind) == -1)
	return misc_read_error;

    while(!ts.eof())
    {
	s.clear();
	if (ts.get().string() == "~h")
	{
	    s.name = ts.get().string();
	    strip_quotes(s.name);
	}
	else
	{
	    cerr << "Expected HMM macro name start (~h name)\n";
	    return misc_read_error;

	}

	// put filename in as stream name. The filename is usually surrounded
	// by quotes, so remove these.
	
    	if (s.load_portion(ts, v_size, n_streams) == misc_read_error)
	{
	    cerr << "error: in reading HMM file\n";
	    cerr << "section for file " << filename << 
		" at line " << ts.linenum() << " is badly formatted\n";
	    
	    return misc_read_error;
	}
	hlist.append(s);
    }
    return format_ok;
}

EST_write_status save_HMMList(EST_String filename, EST_HMMList &hlist)
{
    EST_TBI *p;
    ostream *outf;

    if (hlist.head() == 0)
    {
	cerr << "Can't save empty HMM list\n";
	return misc_write_error;
    }

    if (filename == "-")
	outf = &cout;
    else
	outf = new ofstream(filename);

    if (outf == 0)
    {
	cerr << "Couldn't open file " << filename << " for writing\n";
	return misc_write_error;
    }

    *outf << "~o\n";
    *outf << "<STREAMINFO> " << hlist.first().num_streams << " "<<
	hlist.first().vecsize << "\n";
    *outf << "<VECSIZE> " << hlist.first().vecsize << "";
    *outf << " <NULLD> <FBANK_D_A>\n"; // hard wired for now


    for (p = hlist.head(); p ; p = next(p))
    {
	*outf << "~h \"" << hlist(p).name << "\"\n";
	*outf << hlist(p);
    }
    
    return write_ok;
}
