/*
 Handling of MPEG Audio Headers.
 */

#include <stdio.h>
#include <stdlib.h>
#include "mp3info.h"

char *mode_names[5] = { "stereo", "j-stereo", "dual-ch", "single-ch" , "multi-ch"};
char *layer_names[3] = { "I", "II", "III" };
char *version_names[3] = { "MPEG-1", "MPEG-2 LSF", "MPEG-2.5" };
char *version_nums[3] = { "1", "2", "2.5" };


unsigned int     bitrates[3][3][15] = {
     {
	  {0,32,64,96,128,160,192,224,256,288,320,352,384,416,448},
	  {0,32,48,56,64,80,96,112,128,160,192,224,256,320,384},
	  {0,32,40,48,56,64,80,96,112,128,160,192,224,256,320}
     },{
	  {0,32,48,56,64,80,96,112,128,144,160,176,192,224,256},
	  {0,8,16,24,32,40,48,56,64,80,96,112,128,144,160},
	  {0,8,16,24,32,40,48,56,64,80,96,112,128,144,160}
     },{
	  {0,32,48,56,64,80,96,112,128,144,160,176,192,224,256},
	  {0,8,16,24,32,40,48,56,64,80,96,112,128,144,160},
	  {0,8,16,24,32,40,48,56,64,80,96,112,128,144,160}
     }};


unsigned int  s_freq[3][4] = {
     {44100, 48000, 32000, 0},
     {22050, 24000, 16000, 0},
     {11025, 8000, 8000, 0} 
};

char *Layer::mode_name() {
   return(mode_names[mode]);
}

char *Layer::layer_name() {
   return(layer_names[lay-1]);
}

char *Layer::version_name() {
   return(version_names[version]);
}

char *Layer::version_num() {
   return(version_nums[version]);
}

unsigned int Layer::bitrate() {
   return(bitrates[version][lay-1][bitrate_index]);
}

unsigned int Layer::sfreq() {
   return(s_freq[version][sampling_frequency]);
}

bool Layer::get(FILE *file) {
   unsigned char buffer[5];
   size_t temp;
   
   fseek(file, 0, SEEK_SET) ;
   temp=fread(&buffer,4,1,file);
   
   temp=((buffer[0]<<4) & 0xFF0) | ((buffer[1]>>4) & 0xE);
   if (temp != 0xFFE) {
      return(false);
   } else {
      switch((buffer[1]>>2 & 0x3)) {
        case 2:
          version = 0;
          break;
        case 3:
          version = 1;
          break;
        case 0:
          version = 2;
          break;
        default:
          return(false);
      }
      lay = 4-((buffer[1]>>1) & 0x3);
      error_protection = !(buffer[1] & 0x1);
      bitrate_index = (buffer[2]>>4) & 0x0F;
      sampling_frequency = (buffer[2]>>2) & 0x3;
      padding = (buffer[2]>>1) & 0x01;
      extension = buffer[2] & 0x01;
      mode = (buffer[3]>>6) & 0x3;
      mode_ext = (buffer[3]>>4) & 0x03;
      copyright = (buffer[3]>>3) & 0x01;
      original = (buffer[3]>>2) & 0x1;
      emphasis = ( buffer[3] ) & 0x3;
      stereo = (mode == MPG_MD_MONO) ? 1 : 2; 
      return(true);
   }
}
