.TH XZX 1
.SH NAME
XZX \- an Sinclair ZX Spectrum emulator
.SH SYNOPSIS
.B xzx
.B [options]
.B [\fIsnaphot-file\fR]
.SH DESCRIPTION
\fBXZX\fR is a Z80 emulator with reasonable support for the 48K, 128K and +3
Sinclair ZX Spectrum machines.  Although a usable Spectrum is emulated, a few
features are missing; sound is only emulated on some hardware, for obvious
reasons, and ZX printer support is absent.
.SH OPTIONS
\fBXZX\fR accepts the following command line options.  Options may also be
specified as X Resources using the same spelling.  Note that the shortest
unique spelling of a resource is acceptable, e.g. \fIxzx -ma 128\fR is
equivalent to \fIxzx -machine 128\fR.
.TP
.BI \-help
Print a synopsis of the accepted options and exit.
.TP
.BI \-version
Display the version of this \fBXZX\fR and exit.
.TP
.BI \-libDir " \fI<path>\fR"
Use \fIpath\fR as the colon-separated directory list to check when loading the
Spectrum ROM and any snapshots specified.  Directories are guaranteed to be
searched in the order they are listed.  Defaults to
 \fI".:/usr/local/lib/xzx"\fR.
.TP
.BI \-quiet " \fI<boolean>\fR"
Supresses all non-error messages.  You will see neither warnings nor
informations.  Use at your own risk!  Defaults to \fIfalse\fR.
.TP
.BI \-display " \fI<displayname>\fR"
Specifies the X display to connect to.
.TP
.BI \-geometry " \fI<geomspec>\fR"
An X11 geometry specification.  The width and height field will be ignored;
only the positioning fields count.
.TP
.BI \-pixmap " \fI<boolean>\fR"
Force to use pixmap rather then X image.  This is very slow!  Using pixmaps
can be the only way to run \fBXZX\fR on X servers where the \fBXZX\fR's image
routines do not work.  Defaults to \fIfalse\fR.
.TP 
.BI \-mono " \fI<boolean>\fR"
Force \fBXZX\fR to use only Black and White In this case, the foreground and
background will contrast, e.g. blue on black will appear as white on black, and
green on white will appear as black on white.
The default for monochrome X servers is halftoning if the scaling factor is
increased.  Defaults to \fIfalse\fR.
.TP
.BI \-private " \fI<boolean>\fR"
Force \fBXZX\fR to use a private colormap.  This is the default if \fBXZX\fR
fails to get all the colours it needs, but be warned, every other window on
your display is likely to go technicolor.  Defaults to \fIfalse\fR.
.TP
.BI \-mitshm " \fI<boolean>\fR"
Attempt to use the MIT-SHM X extension for rapid image transfer.  Defaults
to \fItrue\fR.
.TP 
.BI \-debug " \fI<n>\fR"
If \fBXZX\fR has been built with -DDEBUG defined, specifies the level for
debuging.  You should not have any reason to mess with this one.  It just
allows developers to set the debug level and display debug information
depending on what the debug level is.  Defaults to \fI0\fR.
.TP
.BI \-machine " \fI<48|128|3>\fR"
Specifies the memory model to emulate.  Defaults to 48K operation (48).
.TP
.BI \-cycles " \fI<n>\fR"
On the Spectrum, an interrupt occurs 50 times a second (every 20 ms).  The
window between two interrupts we call a frame.  During each frame, one new
picture field is sent to the TV.  During each frame, the Z80 CPU manages to do
some amount of processing (including servicing the interrupt).

A "cycle" is a number of clock ticks taken by the processor to execute
certain instructions.  Every so often (after a certain number of cycles), a
line on the screen gets updated.  Some games rely on the fact that lines on the
screen get updated at certain times, in order to do efficient drawing of
sprites etc.

When this number has passed since the last frame, the emulator goes on to the
next frame, waiting for the timer interrupt if it hasn't already ocurred.

Change this number if you can not see the sprites or they flicker heavily.  Try
to stay within range of \fI69888\fR, which is the default setting for Spectrum
48K.
.TP
.BI \-ms " \fI<n>\fR"
The minimum real time in milliseconds that elapses beetween interrupts, that is
the minimum number of milliseconds in a frame. Defaults to \fI20\fR.

Raise this value to make the emulation "slower than life".  This is more CPU
friendly than the slowdown option since the emulator process spends the spare
time halted (waiting for a timer signal).  If you have a powerful machine with
a high-resolution timer, then you can run the emulation extra fast by lowering
this value.
.TP
.BI \-fast " \fI<boolean>\fR"
Normaly the emulator tries to run at the speed a real Spectrum runs.  However
it may be useful to run the emulator as fast as possible.  Defaults to
\fIfalse\fR.
.PP
If \fBXZX\fR has been built with -DSLOWDOWN defined, it is possible to set and
control \fBXZX\fR's speed.  The following options apply:
.TP
.BI \-slowdown " \fI<n>\fR"
Slow \fBXZX\fR down.  A larger value of \fIn\fR slows \fBXZX\fR more.  This is
implemented by simply running \fIn\fR nop instructions for every instruction.
.TP
.BI \-keySlower " \fI<keysym>\fR"
The key to dynamically slow \fBXZX\fR down.  Defaults to \fIKP_Subtract\fR,
i.e. the keypad Minus key.
.TP
.BI \-keyFaster " \fI<keysym>\fR"
The key to dynamically speed \fBXZX\fR up.  Defaults to \fIKP_Add\fR, i.e. the
keypad Plus key.
.PP
A full list of keysyms can be obtained by viewing the file
\f(CR<X11/keysymdef.h>\fR, and removing the \fIXK_\fR prefix from the
definitions listed there.
.TP
.BI \-scale " \fI<n>\fR"
Specify the Spectrum to X11 pixel magnification.  Valid values are 1, 2 and
3.  Defaults to \fI1\fR.
.TP
.BI \-flashing " \fI<boolean>\fR"
Enable/disable flashing.  If disabled any attribute bytes with the FLASH bit
set will instead appear in inverse video.  The FLASH implementation is not very
optimal (i.e. slow :-), so you may want to disable flashing for action
games.  Defaults to \fItrue\fR.
.TP
.BI \-border " \fI<boolean>\fR"
Toggles "border" emulation on/off.  At this point, \fBXZX\fR does not emulate
the border exactly as it is done in the real spectrum (drawing it line by
line); rather it updates the "X-window" surrounding the main window of the
Spectrum.  Consequently, if you have a game that tries to do fancy things with
the border (like Sentinel or Aquaplane), the emulator will go into a coma
because it tries to reupdate the entire border window time and again.  Defaults
to \fItrue\fR.
.TP
.BI \-rr " \fI<n>\fR"
This option overrites the options \fI-rrShm\fR and \fI-rrNoShm\fR.
.TP
.BI \-rrShm " \fI<n>\fR"
This option specifies how often your screen is refreshed when running \fBXZX\fR
with MITSHM active.  The screen is refreshed every \fIn\fR interrupts, so a
lower number means more frequent refreshes.  Specifying it too low, however,
could result in more time being spent in screen painting than in CPU
emulation!  Defaults to every \fI3\fR interrupts, you might get away with every
interrupt if you are lucky.
.TP
.BI \-rrNoshm " \fI<n>\fR"
Similar to above, but used when MITSHM is not active.  This should be somewhat
higher than the value used for \fIrrShm\fR.  Defaults to every \fI6\fR
interrupts - again, you may get away with lower values, or you may need to
raise it slightly.
.TP
.BI \-pause " \fI<boolean>\fR"
Pause after loading a tape block.  The emulator prints the message "Loading
paused - press key" in the bottom line of the screen and waits for a key to be
pressed.  If F1 is hit then \fBXZX\fR enters the OSD's.  Any other key continues
loading.  Defaults to \fIfalse\fR.
.PP
It is possible to redefine keys to emulate a Kempston joystick.  The following
resources apply:
.TP
.BI \-joyUp " \fI<keysym>\fR"
The key to emulate moving the joystick forwards.  Default is \fIq\fR.
.TP
.BI \-joyDown " \fI<keysym>\fR"
The key to emulate moving the joystick backwards.  Default is \fIa\fR.
.TP
.BI \-joyLeft " \fI<keysym>\fR"
The key to emulate moving the joystick to the left.  Default is \fIo\fR.
.TP
.BI \-joyRight " \fI<keysym>\fR"
The key to emulate moving the joystick to the right.  Default is \fIp\fR.
.TP
.BI \-joyFire " \fI<keysym>\fR"
The key to emulate pressing the joystick Fire button.  Default is
\fIspace\fR.
.PP
Note that it is possible for a key to emulate both a keyboard keypress and a
joystick movement.  No checks are made to ensure that the same key is not
mapped to two or more joystick directions.  It is also possible to fool
\fBXZX\fR into thinking that the joystick is being simultaneously moved in
opposite directions!
.PP
If you are running \fBXZX\fR on Linux or FreeBSD, and you have installed the
joystick kernel patches (available from tsx-11.mit.edu and sunsite.unc.edu),
then it is possible to use a PC analogue joystick to emulate a Kempston 
joystick.  In this case, the following options also apply.
.TP
.BI \-joystick " \fI<boolean>\fR"
Enable/disable joystick emulation.  This is disabled by default.  If emulation
is enabled, you must calibrate your joystick before you can use it (see OSD
chapter in the README file).
.TP
.BI \-joyDev " \fI<path>\fR"
This is the device that \fBXZX\fR uses to read the joystick status, 
\fI/dev/js0\fR by default.  You may want to use \fI/dev/js1\fR, depending on
how your system is setup.
.TP
.BI -tolerance " \fI<int>\fR"
This specifies how far from centre your joystick must be displaced before it
registers with \fBXZX\fR as being moved.  The default displacement tolerance is
20.  You may have to experiment with this to get the best response for your
joystick.
.PP
If you are running \fBXZX\fR on a machine with Sun Sparc \fI/dev/audio\fR style
sound support, then it is possible to get sound emulation.  This option will
also work on Linux with the kernel sound drivers (tested with a SoundBlaster
Pro - quality is poor), and on the NEC EWS 4800/330 workstation (works very
well, but with a 150MHz Mips R4400, it ought to :-).  Alternatively, if you are
on Linux, and \fBXZX\fR is compiled with \fI-DPCSPKR_AUDIO\fR, you can get
Spectrum sound from the PC Speaker.  This works much better than
\fI/dev/audio\fR style sound on Linux.  No extra kernel support is necessary
for this, but \fBXZX\fR must be run with root privileges.  The AY-3-8912 sound
chip is emulated too.  The following options apply:
.TP
.BI -sound " \fI<boolean>\fR"
Enable/disable sound.  Sound is disabled by default.
.TP
.BI -audioDev " \fI<path>\fR"
Specifies the audio device that \fBXZX\fR uses.  By default, this is
\fI/dev/audio\fR; you should not need to change this, unless your system is set
up very strangely, or you are on an EWS 4800/330, in which case, use
\fI/dev/audio/audio\fR.  This does not apply if you use Linux PC Speaker audio.
.TP
.BI -volume " \fI<n>\fR"
Sets audio volume as a percentage.  Defaults to \fI50\fR.
.PP
.TP
.BI \-rom48 " \fI<filename>\fR"
Use \fIfilename\fR as the file containing the 48K Spectrum ROM image.  This
defaults to \fIspectrum.rom\fR.
.TP
.BI \-issue " \fI<2|3>\fR"
Emulate the specified keyboard issue.  Issue 3 is by far the most
common.  Occasionally a program will need this option to be set to 2 (usually
an old program for instance Spinads) otherwise the keys will not respond.  Note
that all 128K Spectrums were issue 3 and some Spectrum 48K were issue 2, but
not that many.  Defaults to \fI3\fR.
.TP
.BI \-kbdlayout " \fI<filename>\fR"
Use \fIfilename\fR as the file containing an picture of the Spectrum
keyboard.  The file must be in .SCR format an exactly 6912 bytes
long.  Defaults to \fIkeyboard.scr\fR.
.TP
.BI \-rom1280 " \fI<filename>\fR"
Specify the 128K ROM0 image.  Defaults to \fI128-0.rom\fR.
.TP
.BI \-rom1281 " \fI<filename>\fR"
Specify the 128K ROM1 image.  Defaults to \fI128-1.rom\fR.
.PP
If \fBXZX\fR has been built with -DXZX_PLUS3 defined, it is possible to emulate
a Spetcrum +3.  The following options apply:
.TP
.BI \-rompl30 " \fI<filename>\fR"
Specify the +3 ROM0 image.  Defaults to \fIpl3-0.rom\fR.
.TP
.BI \-rompl31 " \fI<filename>\fR"
Specify the +3 ROM1 image.  Defaults to \fIpl3-1.rom\fR.
.TP
.BI \-rompl32 " \fI<filename>\fR"
Specify the +3 ROM2 image.  Defaults to \fIpl3-2.rom\fR.
.TP
.BI \-rompl33 " \fI<filename>\fR"
Specify the +3 ROM3 image.  Defaults to \fIpl3-3.rom\fR.
.TP
.BI \-fda " \fI<filename>\fR"
In +3 emulation mode, specifies the filename of the A: disk image.  Defaults to
\fIdiska.dsk\fR.
.TP
.BI \-fdb " \fI<filename>\fR"
In +3 emulation mode, specifies the filename of the B: disk image.  Defaults to
\fIdiskb.dsk\fR.
.PP
If you have compiled in the ZX Microdrive emulation you can use .MDR files as
Microdrive cartridges.  The following options apply:
.TP
.BI -if1 " \fI<boolean>\fR"
Enable or disable the Interface I.  Enabled by default.  In that case, an image
if the Interface I ROM must be present.  The ROM switching is done in lower
16K.

With the emulator, a new version of the 8K ZX Interface ROM is supported (there
were two different versions of ROMs).  Some ill-based programs will not work
with new the version, but there are also programs which work only with new
version.  Some programs (for example, Beta Basic 3.0.) have two versions, one
for the old ROM and one for the new one.

Turn it off if you want to work without extended basic / microdrive support.
.TP
.BI -if1Rom " \fI<filename>\fR"
Specify the filename to load an image of the Interface I ROM.  The current
directory and the lib directory (see above) are searched for the file 
\fIif1.rom\fR by default.
.TP
.BI -crlf " \fI<boolean>\fR"
If set to to true, \fBXZX\fR converts linefeeds (ASCII 10) to carriage returns
(ASCII 13) on RS232 input, and vice versa on RS232 output.  This is necessary
if you are transferring textual data from Unix to \fBXZX\fR, since the
Spectrum expects to see a carriage return as end-of-line, and Unix uses
linefeeds.  Do not use it if you want to transfer binary data.  See the
"Extensions and Alterations" section below for more details on RS232 I/O.
Default to \fIfalse\fR.
.TP
.BI -strcr " \fI<boolean>\fR"
If set to true, \fBXZX\fR will strip carriage returns on RS232 output.  This
is only useful when listing BASIC programs to the IF1 'T' channel.  Defaults to
\fIfalse\fR.
.TP
.BI -m\fI<n>\fR " \fI<filename>\fR"
Load a cartridge file into an emulated Microdrive (n is 1-8).  A blank,
unformatted cartridge file can be created by a command such as
"\fIdd if=/dev/zero of=test.mdr bs=137923 count=1\fR".  A shell script,
\fBmkcart\fR has also been provided to do this.  You can then format it with
the Sinclair BASIC \fBFORMAT\fR command as normal.  Defaults to
\fIcart<n>.mdr\fR.  If you like keeping your Microdrive data intact, do not
load the same file into more than one drive!
.PP
If you have compiled in the Multiface 128 emulation, the following options
apply:
.TP
.BI -mf128 " \fI<boolean>\fR"
Enable or disable the Multiface 128.  Disabled by default.
.TP
.BI -mf128 " \fI<filename>\fR"
Specify the filename to load an image of the Multiface 128 ROM.  The current
directory and the lib directory (see above) are searched for the file 
\fImf128.rom\fR by default.  \fBNOTE:\fR The ROM image is not distributed
with \fBXZX\fR.
.SH RUNNING THE EMULATOR
If \fBXZX\fR is started with no snapshot file as a command-line argument, it
will reset the machine and start either Sinclair BASIC (48K mode), or display
the start-up menu (128K and +3 modes).  If exactly one argument is passed (not
counting options), \fBXZX\fR will search each directory in turn on its
\fIlibDir\fR resource.  \fBXZX\fR is able to read and write .SNA format
snapshots and any .Z80 format snapshots, although only 3.05+ format .Z80
snapshots will be written.
.PP
Once the emulator is up and running, the following keys have special meanings:
.TP 12
.B F1
Display HELP screen, that gives meaning of all function keys and the layout of
the Spectrum keyboard.
.TP 12
.B F2
Pops up a file selector for saving a snapshot of the memory of the Spectrum in
whatever current mode it is in.  The format is either .SNA, .Z80 (compatible
with Gerton Lunter's Z80 emulator version 3.05+) or .SLT.  If \fBXZX\fR is in
128K or +3 mode, a .Z80 format snapshot will be dumped no matter what filename is
given.  If \fBXZX\fR is in 48K mode, the decision is the same as for reading
snapshots as described above.
.TP 12
.B F3
Ditto for loading snapshots.
.TP 12
.B F4
Produce a .SCR file containing a screenshot of the screen of the emulator in
the current state.
.TP 12
.B F5
Resets the Spectrum in whatever current mode it is in.
.TP 12
.B F6
Pressing this generates an NMI.  With the default ROMs, this has the effect of
resetting the machine, but some contributed ROMs have hooks for extensions on
receipt of an NMI.  With the Multiface 128 in use this will enter the
Multiface.
.TP 12
.B F7
Calls the the built-in debugger, which contains some options interesting even
to those who has no interest in machine code programming.
.TP 12
.B F9
Choose a certain architecture for the Spectrum emulation and does or does not
perform a reset.
.TP 12
.B F10
Shuts down the emulator cleanly.
.PP
Support for the original Spectrum keyboard is emulated as follows:

Left Shift emulates Caps Shift and this is guaranteed to work (only) for the
basic Spectrum keys, that is letters, numbers and Space.  Alt/Meta emulates
Symbol Shift, Control emulates Extend mode.  Also guaranteed for basic Spectrum
keys.  Return emulates Enter, Backspace and Delete emulate CapsShift-0
(Rubout).  The cursor keys emulate CapsShift-5 to 8, or plain 5 to 8 (Cursor
Joystick).  The Tab key toggles between the two.  Escape emulates CapsShift-1
(Edit).  Right Shift and other local modifier keys(*) work locally: The
character printed on your key is emulated wherever possible.  This actually
goes for all "non-Spectrum" keys with or without local shift.

The keyboard emulation is not perfect and it can get confused at times.  If you
think this has happened, try presssing Bar or Backslash which clears all
Spectrum input ports.

The emulator turns keyboard autorepeat off when the mouse pointer is in the XZX
window.

If XZX was compiled with X terminal support, then the the keyboard emulation
works slightly differently.  When you are actually using an X terminal, you
will in fact need to have keyboard autorepeat activated.

(*) like some "Alt" keys that are used to get extra characters.  On both DEC
and Sun (when I tried), this key is not decoded as Alt or Meta but as
Mode_switch.
.SH EXTENSIONS AND ALTERATIONS TO THE BASIC
.PP
If \fBXZX\fR has been compiled with the \fI-DPSEUDO_IO\fR define, it will be
possible to read characters from stdin and write characters to stdout and
stderr using I/O ports.  By default the ports are as follows: reading port
0x00bf (191) will read a character from stdin, returning 255 if no input is
pending; writing port 0x01bf (447) will send a character to stdout; and writing
port 0x02bf (703) will send a character to stderr.  These port numbers can be
overriden at compile\-time by changing the definitions in io.h.  This is not
particularly useful interactively, especially if the Interface I is active, but
has possibilities as an unusual filtering shelltool.
.PP
The BASIC LOAD and SAVE commands will behave differently.  Instead of trying to
read or write data to a tape, SAVE will immediately dump data to a file on
disk, and LOAD will try and read data from a file on disk.
.PP
If \fBXZX\fR as been compiled with the \fI-DZX_IF1\fR define the emulator
behaves as though an Interface I is attached in terms of paging the shadow ROM
in and out, allowing the use of extended basic commands and emulating the
Microdrive hardware.
.PP
The microdrive cartridge file format used is the .MDR format used by several
other Spectrum emulators.
.PP
When the IF1 emulation is active the RS232 channels are connected to stdio so
listings and blocks of code can be obtained and transferred by appropriate
redirections.  For example: "\fIXZX -crlf yes > listing.bas\fR", followed by
the BASIC commands to
\fBXZX\fR:  "\fIOPEN #4, 'T': LIST #4: CLOSE #4\fR".  Channel 'T' is a text
channel; BASIC keywords are expanded and end-of-line is converted to
CR/LF.  Channel 'B' is a binary channel; no conversion is performed.  Channel
'T' is only really useful for listing BASIC programs to the RS232 port, as
above.
.PP
\fBXZX\fR tries to emulate RS232 I/O as sensibly as possible, but please note
that piping input to \fBXZX\fR simply does not work well.  Reading input from
terminals & special devices (using the Unix file redirection mechanism) does
work, as does reading from files.
.PP
The +3 floppy disk format used is identical to that of Marco Vieth's Amstrad
CPC emulator.  Disk images should therefore be compatible between the two
emulators, though I have not tested this personally.
.SH BUGS AND DEFICIENCIES
\fBXZX\fR does not run all of the snapshots I have tried, but I do not know
whether the emulator is at fault 100% of the time.
.SH AUTHOR
Erik Kunze <Erik.Kunze@fantasy.muc.de>, Des Herriott, and plenty
others.  See the README and ChangeLog files.
