/********************************************************************************
 * Copyright (c) Des Herriott 1993, 1994
 *               Erik Kunze   1995, 1996, 1997
 *
 * Permission to use, distribute, and sell this software and its documentation
 * for any purpose is hereby granted without fee, provided that the above
 * copyright notice appear in all copies and that both that copyright notice and
 * this permission notice appear in supporting documentation, and that the name
 * of the copyright holder not be used in advertising or publicity pertaining to
 * distribution of the software without specific, written prior permission.  The
 * copyright holder makes no representations about the suitability of this
 * software for any purpose.  It is provided "as is" without express or implied
 * warranty. THE CODE MAY NOT BE MODIFIED OR REUSED WITHOUT PERMISSION!
 *
 * THE COPYRIGHT HOLDER DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE,
 * INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS, IN NO
 * EVENT SHALL THE COPYRIGHT HOLDER BE LIABLE FOR ANY SPECIAL, INDIRECT OR
 * CONSEQUENTIAL DAMAGES OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE,
 * DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER
 * TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR
 * PERFORMANCE OF THIS SOFTWARE.
 *
 * Author: Des Herriott
 *         Erik Kunze
 *
 * changed by EKU
 *******************************************************************************/
#ifndef lint
static char rcsid[] = "$Id: main.c,v 3.13 1997/09/19 15:00:00 erik Rel $";
#endif

#include <sys/types.h>
#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>
#include <signal.h>
#include <string.h>
#include <time.h>
#include "z80.h"
#include "resource.h"
#include "mem.h"
#include "io.h"
#include "util.h"
#ifdef AUDIO
#include "audio.h"
#endif
#include "dialog.h"
#ifdef XZX_PLUS3
#include "fdc.h"
#endif
#include "emul.h"
#ifdef XZX_IF1
#include "if1.h"
#endif
#ifdef JOY
#include "joystick.h"
#endif
#if defined(PRINTER) && defined(REGISTERED)
#include "printer.h"
#endif
#include "screen.h"
#include "snapshot.h"
#include "version.h"
#include "main.h"

#ifndef EXPIRATION
#define EXPIRATION		0
#endif

static int initEmulator(int, char **);
static void quitEmulator(int);

char *ProgName, *Version;
time_t StartupTime;
int StdinFileType, StdoutFileType;


int
main(int argc, char **argv)
{
	char *s;
	int *t;
	if ((s = strrchr(argv[0], '/')) != NULL)
	{
		ProgName = ++s;
	}
	else
	{
		ProgName = argv[0];
	}
	Version = (char *)Malloc(sizeof("XZX X.XX.XXR") + 1, "main");
#ifdef REGISTERED
	(void)sprintf(Version, "XZX %d.%d.%dR", ZX_Major, ZX_Minor, ZX_Patch);
#else
	(void)sprintf(Version, "XZX %d.%d.%d", ZX_Major, ZX_Minor, ZX_Patch);
#endif

	t = (int *)"\01\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0";
#ifdef LITTLE_ENDIAN
	if (*t != 1)
	{
		(void)fprintf(stderr,
					  "********* This machine is high-endian. **********\n"
					  "Take #define LSB_FIRST out and compile XZX again.\n");
		return 1;
 	}
#else
	if (*t == 1)
	{
		(void)fprintf(stderr,
					  "********* This machine is low-endian. *********\n"
					  "Insert #define LSB_FIRST and compile XZX again.\n");
		return 1;
	}
#endif

	StartupTime = time(NULL);
	if (EXPIRATION && (EXPIRATION < StartupTime))
	{
		(void)fprintf(stderr,
					  "Sorry, your version has expired! Get a new one.\n");
		return 1;
	}
	if (initEmulator(argc, argv) != -1)
	{
		Emulate();
	}
	Quit(1);

	return 0;
}

static int
initEmulator(int ac, char **av)
{
	int i;

	(void)signal(SIGINT,  SIG_IGN);
	(void)signal(SIGHUP,  SIG_IGN);
	(void)signal(SIGTERM, SIG_IGN);
	(void)signal(SIGQUIT, SIG_IGN);
#ifdef SIG_XCPU
	(void)signal(SIG_XCPU, SIGIGN);
#endif

	InitX(&ac, av);
	SetBlocking(STDIN_FILENO, 1);
	StdinFileType = ClassifyDescriptor(STDIN_FILENO);
	SetBlocking(STDOUT_FILENO, 1);
	StdoutFileType = ClassifyDescriptor(STDOUT_FILENO);
#ifdef AUDIO
	(void)AudioInit();
#endif
#ifdef JOY
	(void)JoyInit();
#endif
	MemoryInit();
	(void)ReadROMs();
	Z80_Init();
#ifdef XZX_PLUS3
	FdcInit();
#endif
#ifdef XZX_IF1
	If1Init();
#endif
#if defined(PRINTER) && defined(REGISTERED)
	(void)PrinterInit();
#endif
	DialogInit(!av[1]);

	if (!av[1] || ReadSnapshot(av[1]) == -1)
	{

		srand(getpid());
		for (i = DFILE; i < (DFILE + PIXEL_LENGTH + ATTR_LENGTH); i++)
		{
			WR_BYTE(i, (uns8)rand());
		}
	}
	ScreenRefresh();
	(void)signal(SIGINT,  quitEmulator);
	(void)signal(SIGHUP,  quitEmulator);
	(void)signal(SIGTERM, quitEmulator);
	(void)signal(SIGQUIT, quitEmulator);
	return 0;
}

static void
quitEmulator(int signo)
{
	SetBlocking(STDIN_FILENO, 0);
	SetBlocking(STDOUT_FILENO, 0);

	Quit(2);

}

