/********************************************************************************
 * Copyright (c) Des Herriott 1993, 1994
 *               Erik Kunze   1995, 1996, 1997
 *
 * Permission to use, distribute, and sell this software and its documentation
 * for any purpose is hereby granted without fee, provided that the above
 * copyright notice appear in all copies and that both that copyright notice and
 * this permission notice appear in supporting documentation, and that the name
 * of the copyright holder not be used in advertising or publicity pertaining to
 * distribution of the software without specific, written prior permission.  The
 * copyright holder makes no representations about the suitability of this
 * software for any purpose.  It is provided "as is" without express or implied
 * warranty. THE CODE MAY NOT BE MODIFIED OR REUSED WITHOUT PERMISSION!
 *
 * THE COPYRIGHT HOLDER DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE,
 * INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS, IN NO
 * EVENT SHALL THE COPYRIGHT HOLDER BE LIABLE FOR ANY SPECIAL, INDIRECT OR
 * CONSEQUENTIAL DAMAGES OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE,
 * DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER
 * TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR
 * PERFORMANCE OF THIS SOFTWARE.
 *
 * Author: Martin Smith (msmith@lssec.bt.co.uk)
 *         Erik Kunze
 *
 * changed by EKU
 *******************************************************************************/
#ifndef _XZX_IF1_H
#define _XZX_IF1_H
/* $Id: if1.h,v 3.4 1997/05/17 15:57:49 erik Rel $ */
#include "z80.h"


#define MAX_DRIVES				8
#define KEEP_DRIVES_IN_RAM		2

#define SHADOW_ROM_SIZE			16384

#define CART_FILE_SIZE			137923
#define CART_FILE_SECTOR_SIZE	543
#define CART_FILE_NUM_SECTORS	254

#define WRITE_PROT_BIT			1
#define SYNC_BIT				2
#define GAP_BIT					4
#define DTR_BIT					8
#define BUSY_BIT				16

#define GAP_CLOCK_RATE			10

#define COMMS_DATA_BIT			1
#define COMMS_CLK_BIT			2
#define RW_BIT					4
#define ERASE_BIT				8
#define CTS_BIT					16
#define WAIT_BIT				32

typedef struct drivedata
{
	long tapepos;
	int protect;
	int dirty;
	long sequence;
	char *filename;
	uns8 *buffer;
} mdriveData;

#define RS232_IP_ADDR_V1		0x0b9a
#define RS232_OP_ADDR_V1		0x0c5a
#define RS232_IP_ADDR_V2		0x0b98
#define RS232_OP_ADDR_V2		0x0d07
#define RS232_IP_BPT_BYTE		0xf3
#define RS232_OP_BPT_BYTE		0x06
#define RS232_IP_BPT			0xfe
#define RS232_OP_BPT			0xff

extern void If1Init(void);
extern void If1OnOff(int);
extern void SetRS232Traps(void);
extern int InsertCartridge(int);
extern void EjectCartridge(int);
extern char *GetCartName(int);
extern void OutPortEF(uns8);
extern void OutPortE7(uns8);
extern uns8 InPortE7(void);
extern uns8 InPortEF(void);
extern void RS232IpTrap(void);
extern void RS232OpTrap(void);
#endif

