/********************************************************************************
 * Copyright (c) Des Herriott 1993, 1994
 *               Erik Kunze   1995, 1996, 1997
 *
 * Permission to use, distribute, and sell this software and its documentation
 * for any purpose is hereby granted without fee, provided that the above
 * copyright notice appear in all copies and that both that copyright notice and
 * this permission notice appear in supporting documentation, and that the name
 * of the copyright holder not be used in advertising or publicity pertaining to
 * distribution of the software without specific, written prior permission.  The
 * copyright holder makes no representations about the suitability of this
 * software for any purpose.  It is provided "as is" without express or implied
 * warranty. THE CODE MAY NOT BE MODIFIED OR REUSED WITHOUT PERMISSION!
 *
 * THE COPYRIGHT HOLDER DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE,
 * INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS, IN NO
 * EVENT SHALL THE COPYRIGHT HOLDER BE LIABLE FOR ANY SPECIAL, INDIRECT OR
 * CONSEQUENTIAL DAMAGES OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE,
 * DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER
 * TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR
 * PERFORMANCE OF THIS SOFTWARE.
 *
 * Author: Des Herriott
 *         Erik Kunze
 *
 * changed by EKU
 *******************************************************************************/
#ifndef lint
static char rcsid[] = "$Id: emul.c,v 3.12 1997/08/09 14:34:01 erik Rel $";
#endif

#include <stdio.h>
#include <signal.h>
#include <sys/types.h>
#include "z80.h"
#include "debug.h"
#include "resource.h"
#include "mem.h"
#ifdef SUN_AUDIO
#include "audio.h"
#endif
#include "dis.h"
#if defined(XZX_PLUS3) && !defined(REGISTERED)
#include "fdc.h"
#endif
#ifdef XZX_IF1
#include "if1.h"
#endif
#ifdef REGISTERED
#include "monitor.h"
#endif
#include "screen.h"
#include "snapshot.h"
#include "emul.h"
#include "z80.c"


static void frameInterrupt(int);
#ifdef SLOWDOWN
static void nop(void);
#endif

int CyclesPerLine;
int Vline = 0;
unsigned int Vlines = 0;

static int interrupted = 0;

static void
frameInterrupt(int signo)
{
	interrupted++;
}

#ifdef SLOWDOWN
static void
nop(void)
{
}
#endif

void
Emulate(void)
{
	register uns8 op = 0;
	struct sigaction sigact;
	int nInterrupts = 0;
	int *refreshInterval;
#ifdef SLOWDOWN
	int i;
#endif
	CyclesPerLine = GETCFG(cycles) / TVLINES;
#ifdef MITSHM
	if (GETCFG(mitshm))
	{
		refreshInterval = &GETCFG(rrShm);
	}
	else
#endif
	{
		refreshInterval = &GETCFG(rrNoShm);
	}

	sigact.sa_handler = frameInterrupt;
	(void)sigemptyset(&sigact.sa_mask);
#ifdef SA_RESTART
	sigact.sa_flags = SA_RESTART;
#else
	sigact.sa_flags = 0;
#endif
	(void)sigaction(SIGALRM, &sigact, NULL);
	IntFrequency(1000 * GETCFG(ms));
	for (;;)
	{

		if (Tstates >= CyclesPerLine)
		{
			Tstates -= CyclesPerLine;
			Vlines++;
			if (++Vline == TVLINES)
			{
				Vline = 0;

				if (!(++nInterrupts % 25))
				{
					DoFlashing();
				}
				CheckEvents();
				if (!(nInterrupts % *refreshInterval))
				{
					ScreenRefresh();
				}
#if defined(LINE_VIDEO) && !defined(REGISTERED)
				ScreenUpdateBuffers();
#endif
				if (!GETCFG(fast))
				{
#ifdef SUN_AUDIO
					SpeakerPlayBuffer();
#endif
					if (!interrupted)
					{
						(void)sigpause(SIGALRM);
					}
					interrupted = 0;
				}
				Z80_INTERRUPT;
			}
#ifdef REGISTERED

			if (!(nInterrupts % *refreshInterval))
			{
				UpdateLine(Vline);
			}
#endif
		}
#ifdef SLOWDOWN
		for (i = 0; i < GETCFG(slowdown); i++)
		{
			nop();
		}
#endif
#if defined(XZX_PLUS3) && !defined(REGISTERED)

		if (RPAGE(0) == ROM2 && GETCFG(machine) == 3)
		{
			DdCheck();
		}
#endif
#ifdef XZX_IF1

		if ((PC == 0x0008 || PC == 0x1708) && RPAGE(0) == BasicRom &&
			GETCFG(if1_active))
		{
			PageIn(0, IF1ROM);
		}
#endif
#ifdef REGISTERED
		if (DbgState != S_RUN)
		{
			Debugger(DBG_SINGLESTEP);
		}
#elif DEBUG
		if (GETCFG(debug) & (D_CPU | D_SYSVAR | D_MNEMO))
		{
			DebugZ80();
		}
#endif
		Z80_M1(op);
#ifdef XZX_IF1
		if (PC == 0x0701 && RPAGE(0) == IF1ROM)
		{
			PageIn(0, BasicRom);
		}
#endif
		switch (op)
		{
#			include "z80_ops.c"
		}
	}
}

