/* DD2CPCDISC v0.1
 * Thomas Kjaer, Apr/Jun - 1994
 *
 * DDTRANS is a special Un*x version of
 *   CPCTRANS v1.1
 *   Marco Vieth, 9.12.1993 (6.12.1993)
 *   transfer CPC-disks to CPCEMU disk-images and vice versa
 *
 * Used with permission from the author of CPCTRANS
 *
 * The program works on exact disc-images made with the Un*x command 'dd',
 * which hopefully for you, supports DDDSDT disks.
 * Only DD disc, e.g. vortex or PCW.
 *
 * to make a 'dd' file from a DD disk do this:
 *   dd if=/dev/fd0 of=image bs=737280
 *
 * Start this program and specify 'image' as the 'dd' file
 *
 * to write a DD disc from a 'dd' file do this:
 *   dd if=image of=/dev/fd0 bs=737280
 *
 * This program will also make newly formatted discs for the Amstrad emulator
 * CPCEMU by Marco Vieth, and the Sinclair Spectrum +3 emulator xzx for
 * Un*x/X-windows by Des Herriott.
 *
 * developed under Linux 1.0 with gcc
 */

static char rcsid[] = "$Id: ddtrans.c,v 1.5 1997/10/18 17:46:18 erik Rel $";
#include <sys/types.h>
#include <sys/param.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#define MAXSEC			18
#define IMG_DISK_INFO	0x100
#define IMG_TRACK_INFO	0x100
typedef unsigned char byte;
typedef unsigned short int word;
typedef struct {
	byte tracks;
	byte heads;
	word tsize;

} Disk_info;
typedef struct {
	byte track;
	byte head;
	byte sector;
	byte bps;
	byte state1;
	byte state2;
	byte unused1;
	byte unused2;
} Sector_info;
typedef struct {
	byte track;
	byte head;

	byte bps;
	byte spt;
	byte gap3;
	byte fill;

	Sector_info si[MAXSEC];

	byte snum;
	byte fsec;
} Track_info;
typedef struct {
	FILE *fp;
	char *fn;
} Drive;
typedef struct {
	char fname[MAXPATHLEN];
	FILE *f;
	byte disk_i[IMG_DISK_INFO];
	byte track_i[IMG_TRACK_INFO];
} Image;
static byte sbuff[0x1000];
static byte dpb_buff[0x10];

static char dpb_p3[] = {
	0x00, 0x00, 0x28, 0x09, 0x02, 0x01, 0x03, 0x02,
	0x2a, 0x52, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00
};
static char dpb_data[] = {
	0x02, 0x00, 0x28, 0x09, 0x02, 0x00, 0x03, 0x02,
	0x2a, 0x52, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00
};
static char dpb_system[] = {
	0x01, 0x00, 0x28, 0x09, 0x02, 0x02, 0x03, 0x02,
	0x2a, 0x52, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00
};
static char dpb_pcw[] = {
	0x03, 0x01, 0x50, 0x09, 0x02, 0x01, 0x04, 0x04,
	0x2a, 0x52, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00
};





static char
upcase(char ch)
{
	return (((ch >= 'a') && (ch <= 'z')) ? (ch - (char)0x20) : ch);
}
static char
*input(void)
{
	static char line[80];
	(void)gets(line);
	return line;
}





static int
drv_read_sector(Drive *dv, Track_info *t, byte *buffer)
{
#ifdef DEBUG
	(void)printf("read sector: drive=%s, head=%02d, track=%02d, sector=%02X\n",
				 dv->fn, t->head, t->track, (t->si[t->snum]).sector);
#endif
	if (fseek(dv->fp, 4608 * (2 * (int)t->track + (int)t->head) + 512 *
			  ((int)(t->si[(int)t->snum]).sector - 1), SEEK_SET))
	{
		(void)fprintf(stderr, "error in seek\n");
		(void)fclose(dv->fp);
		exit(EXIT_FAILURE);
	}
	if (fread(buffer, 512, 1, dv->fp) != 1)
	{
		(void)fprintf(stderr, "error in read\n");
		(void)fclose(dv->fp);
		exit(EXIT_FAILURE);
	}
#ifdef DEBUG
	(void)printf("ok.\n");
#endif
	return 0;
}
static int
drv_write_sector(Drive *dv, Track_info *t, byte *buffer)
{
#ifdef DEBUG
	(void)printf("write sector: drive=%s, head=%02d, track=%02d, sector=%02X\n",
				 dv->fn, t->head, t->track, (t->si[t->snum]).sector);
#endif
	if (fseek(dv->fp, 4608 * (2 * (int)t->track + (int)t->head) + 512 *
			  ((int)(t->si[(int)t->snum]).sector - 1) , SEEK_SET))
	{
		(void)fprintf(stderr, "error in seek\n");
		(void)fclose(dv->fp);
		exit(EXIT_FAILURE);
	}
	if (fwrite(buffer, 512, 1, dv->fp) != 1)
	{
		(void)fprintf(stderr, "error in write\n");
		(void)fclose(dv->fp);
		exit(EXIT_FAILURE);
	}
#ifdef DEBUG
	(void)printf("ok.\n");
#endif
	return 0;
}





static void
create_disk_info(byte *s, Disk_info *d)
{
	memset(s, 0, IMG_DISK_INFO);
	(void)strcpy((char *)s, "MV - CPCEMU Disk-File\r\nDisk-Info\r\n");
	s += 0x30;
	*(s++) = d->tracks;
	*(s++) = d->heads;
	*(s++) = (byte)d->tsize;
	*(s++) = (d->tsize >> 8);
}
static void
create_track_info(byte *s, Track_info *t)
{
	byte sec;
	memset(s, 0, IMG_TRACK_INFO);
	(void)strcpy((char *)s, "Track-Info\r\n");
	s += 0x10;
	*(s++) = t->track;
	*(s++) = t->head;
	*(s++) = (byte)0;
	*(s++) = (byte)0;

	*(s++) = t->bps;
	*(s++) = t->spt;
	*(s++) = t->gap3;
	*(s++) = t->fill;

	for (sec = (byte)0; sec < t->spt; sec++)
	{
		*(s++) = t->track;
		*(s++) = t->head;
		*(s++) = sec + t->fsec;
		*(s++) = t->bps;
		*(s++) = (byte)0;
		*(s++) = (byte)0;
		*(s++) = (byte)0;
		*(s++) = (byte)0;
	}
}
static int
img_write(FILE *stream, byte *buf, size_t len)
{
	if (fwrite(buf, sizeof(byte), len, stream) != len)
	{
		(void)fprintf(stderr, "error fwrite()\n");
		return 1;
	}
	return 0;
}
static int
drv_to_img(Drive *dv, Disk_info *d, Track_info *t, Image *im)
{
	byte trk, hd, sec;
	create_disk_info(im->disk_i, d);
	if (img_write(im->f, im->disk_i, IMG_DISK_INFO))
	{
		return 1;
	}
	for (trk = (byte)0; trk < d->tracks; trk++)
	{
		t->track = (byte)trk;
		for (hd = (byte)0; hd < d->heads; hd++)
		{
			t->head = hd;
			(void)printf("\rLoading track %d  head %d ...  ",
						 (int)trk, (int)hd);
			create_track_info(im->track_i, t);
			if (img_write(im->f, im->track_i, IMG_TRACK_INFO))
			{
				return 1;
			}
			for (sec = (byte)0; sec < t->spt; sec++)
			{
				t->snum = sec;
				t->si[(int)t->snum].sector = sec + t->fsec;
				if (drv_read_sector(dv, t, sbuff)
					||  img_write(im->f, sbuff, (size_t)(0x0080 << t->bps)))
				{
					return 1;
				}
			}
		}
	}
	return 0;
}
static int
format_to_img(Drive *dv, Disk_info *d, Track_info *t, Image *im)
{
	byte trk, hd, sec;
	create_disk_info(im->disk_i, d);
	if (img_write(im->f, im->disk_i, IMG_DISK_INFO))
		return 1;
	for (trk = (byte)0; trk < d->tracks; trk++) {
		t->track = trk;
		for (hd = (byte)0; hd < d->heads; hd++) {
			t->head = hd;
			(void)printf("\rFormatting track %d  head %d ...  ",
						 (int)trk, (int)hd);
			create_track_info(im->track_i, t);
			if (img_write(im->f, im->track_i, IMG_TRACK_INFO))
				return 1;
			for (sec = (byte)0; sec < t->spt; sec++) {
				t->snum = sec;
				t->si[(int)t->snum].sector = sec + t->fsec;

				memset(sbuff, (int)t->fill, (size_t)(0x0080 << t->bps));
				if (trk == (byte)0 && hd == (byte)0 && sec == (byte)0)
					(void)memcpy(sbuff, dpb_buff, 0x10);
				if (img_write(im->f, sbuff, (size_t)(0x0080 << t->bps)))
					return 1;
			}
		}
	}
	return 0;
}





static int
extract_disk_info(byte *s, Disk_info *d)
{
	if (memcmp(s, "MV - CPCEMU Disk-File\r\nDisk-Info\r\n", 8))
	{
		return 1;
	}
	s += 0x30;
	d->tracks = *(s++);
	d->heads = *(s++);
	d->tsize = (word)*(s++);
	d->tsize |= (word)(*(s++) << 8);
	return 0;
}
static int
extract_track_info(byte *s, Track_info *t)
{
#ifdef DEBUG
	(void)printf("extract_track_info\n");
#endif
	if (memcmp(s, "Track-Info\r\n", 5))
	{
		return 1;
	}
	s += 0x10;
	t->track = *(s++);
	t->head = *(s++);
	s+=2;

	t->bps = *(s++);
	t->spt = *(s++);
	t->gap3 = *(s++);
	t->fill = *(s++);

	(void)memcpy(t->si, s, (size_t)t->spt * sizeof(Sector_info));
	t->fsec = t->si[0].sector;
#ifdef DEBUG
	(void)printf("t->fsec = %02X\n", t->fsec);
#endif
	return 0;
}
static int
img_read(FILE *stream, byte *buf, size_t len)
{
	if (fread(buf, sizeof(byte), len, stream) != len)
	{
		(void)fprintf(stderr, "error fread()\n");
		return 1;
	}
	return 0;
}
static int
img_to_drv(Drive *dv, Disk_info *d, Track_info *t, Image *im)
{
	byte trk, hd, sec;
	if (img_read(im->f, im->disk_i, IMG_DISK_INFO)
		|| extract_disk_info(im->disk_i, d))
	{
		return 1;
	}
	for (trk = (byte)0; trk < d->tracks; trk++)
	{
		for (hd = (byte)0; hd < d->heads; hd++)
		{
			(void)printf("\rSaving track %d  head %d ...  ",
						 (int)trk, (int)hd);
			if (img_read(im->f, im->track_i, IMG_TRACK_INFO)
				|| extract_track_info(im->track_i, t)
				|| (trk != t->track)
				|| (hd != t->head))
			{
				return 1;
			}
			for (sec = (byte)0; sec < t->spt; sec++)
			{
				t->snum = sec;
				if (img_read(im->f, sbuff, (size_t)(0x0080 << t->bps))
					|| drv_write_sector(dv, t, sbuff))
				{
					return 1;
				}
			}
		}
	}
	return 0;
}





static void
set_f_data(Disk_info *d, Track_info *t)
{
	d->tracks = (byte)40;
	d->heads = (byte)1;
	t->bps = (byte)0x02;
	t->spt = (byte)9;
	t->gap3 = (byte)0x4E;
	t->fill = (byte)0xE5;
	t->fsec = (byte)0xC1;
}
static void
set_f_vortex(Disk_info *d, Track_info *t)
{
	d->tracks = (byte)80;
	d->heads = (byte)2;
	t->bps = (byte)0x02;
	t->spt = (byte)9;
	t->gap3 = (byte)0x4E;
	t->fill = (byte)0xE5;
	t->fsec = (byte)0x01;
}

static void
select_format_form(Disk_info *d, Track_info *t)
{
	char *s;
	d->tsize = (word)0xffff;
	t->track = (byte)0xff;
	t->head = (byte)0xff;
	t->snum = (byte)0xff;
	set_f_data(d, t);
	(void)memcpy(dpb_buff, dpb_data, 0x10);
	(void)printf("Select format :\n");
	do
	{
		(void)printf("d)ata 9x512x40x1; s)ystem 9x512x40x1;"
					 "v)ortex 9x512x80x2;\n"
					 "+)3 dos 9x512x40x1; a)mstrad PCW 9x512x80x2;\n"
					 "m)odify; o)k\n"
					 "Your choice: ");
		s = input();
		switch (upcase(s[0]))
		{
			case 'D' :
				set_f_data(d, t);
				(void)memcpy(dpb_buff, dpb_data, 0x10);
				(void)printf("DATA-format set.\n");
				break;
			case 'S' :
				set_f_data(d, t);
				t->fsec = (byte)0x41;
				(void)memcpy(dpb_buff, dpb_system, 0x10);
				(void)printf("SYSTEM-format set.\n");
				break;
			case 'V' :
				set_f_vortex(d, t);
				(void)memcpy(dpb_buff, dpb_pcw, 0x10);
				(void)printf("VORTEX-format set.\n");
				break;
			case '+' :
				set_f_data(d, t);
				t->fsec = (byte)0x00;
				(void)memcpy(dpb_buff, dpb_p3, 0x10);
				(void)printf("+3 DOS-format set.\n");
				break;
			case 'A' :
				set_f_vortex(d, t);
				(void)memcpy(dpb_buff, dpb_pcw, 0x10);
				(void)printf("Amstrad PCW-format set.\n");
				break;
			case 'M' :
				(void)printf("Modify: not implemented.\n");
				break;
			case 'O' :
				(void)printf("Ok.\n");
				break;
			default :
				(void)printf("unknown format.\n");
		}
	}
	while (upcase(s[0]) != 'O');
	d->tsize = (word)t->spt * (0x0080 << t->bps) + IMG_DISK_INFO;
}
static void
select_format(Disk_info *d, Track_info *t)
{
	char *s;
	d->tsize = (word)0xffff;
	t->track = (byte)0xff;
	t->head = (byte)0xff;
	t->snum = (byte)0xff;
	set_f_vortex(d, t);
	(void)memcpy(dpb_buff, dpb_pcw, 0x10);
	(void)printf("Select format :\n");
	do
	{
		(void)printf("v)ortex 9x512x80x2; a)mstrad PCW 9x512x80x2;\n"
					 "m)odify; o)k\n"
					 "Your choice: ");
		s = input();
		switch (upcase(s[0]))
		{
			case 'V' :
				set_f_vortex(d, t);
				(void)memcpy(dpb_buff, dpb_pcw, 0x10);
				(void)printf("VORTEX-format set.\n");
				break;
			case 'A' :
				set_f_vortex(d, t);
				(void)memcpy(dpb_buff, dpb_pcw, 0x10);
				(void)printf("Amstrad PCW-format set.\n");
				break;
			case 'M' :
				(void)printf("Modify: not implemented.\n");
				break;
			case 'O' :
				(void)printf("Ok.\n");
				break;
			default :
				(void)printf("unknown format.\n");
		}
	}
	while (upcase(s[0]) != 'O');
	d->tsize = (word)t->spt * (0x0080 << t->bps) + IMG_DISK_INFO;
}





static void
set_drive(Drive *drv)
{
	char *s;
	(void)printf("filename of 'dd' image: ");
	s = input();
	(void)memcpy(drv->fn, s, 80);
}
static void
set_image_file(Image *img)
{
	char *s;
	(void)printf("New image file (without .dsk) : ");
	s = input();
	(void)strcpy(img->fname, s);
	if (!strchr(img->fname, '.'))
	{
		strcat(img->fname, ".dsk");
	}
	(void)printf("Image file set to %s\n", img->fname);
}
static void
format_image(Drive *drv, Image *img, Disk_info *di, Track_info *ti)
{
	(void)printf("formatting image file %s\n", img->fname);
	if ((img->f = fopen(img->fname, "r")))
	{
		(void)fclose(img->f);
		(void)printf("file already exist. Overwrite (y/n) ? ");
		{
			char *s = input();
			if (upcase(s[0]) != 'Y')
				return;
		}
	}
	if (!(img->f = fopen(img->fname, "w")))
	{
		(void)printf("error opening %s\n", img->fname);
		return;
	}
	select_format_form(di, ti);

	if (format_to_img(drv, di, ti, img))
	{
		(void)printf("Operation terminated incorrectly.\n");
	}
	else
	{
		(void)printf("formatting ok.\n");
	}
	(void)fclose(img->f);
}
static void
copy_drive_image(Drive *drv, Image *img, Disk_info *di, Track_info *ti)
{
	(void)printf("Copy 'dd' file -> Image\n");
	(void)printf("reading from 'dd' file %s.\n", drv->fn);
	(void)printf("writing to image file %s\n", img->fname);
	if (!(drv->fp=fopen(drv->fn, "r")))
	{
		(void)fprintf(stderr, "error: can't open %s\n", drv->fn);
		exit(EXIT_FAILURE);
	}
	if ((img->f = fopen(img->fname, "r")))
	{
		(void)fclose(img->f);
		(void)printf("file already exist. Overwrite (y/n) ? ");
		{
			if (upcase((input())[0]) != 'Y')
			{
				return;
			}
		}
	}
	if (!(img->f = fopen(img->fname, "w")))
	{
		(void)printf("error opening %s\n", img->fname);
		return;
	}
	select_format(di, ti);

	if (drv_to_img(drv, di, ti, img))
	{
		(void)printf("Operation terminated incorrectly.\n");
	}
	else
	{
		(void)printf("transfer ok.\n");
	}
	(void)fclose(img->f);
	(void)fclose(drv->fp);
}
static void
copy_image_drive(Drive *drv, Image *img, Disk_info *di, Track_info *ti)
{
	(void)printf("Copy Image -> 'dd' file\n");
	(void)printf("reading from image file %s\n", img->fname);
	if (!(img->f = fopen(img->fname, "r")))
	{
		(void)fprintf(stderr, "error opening %s\n", img->fname);
		return;
	}
	if (!(drv->fp = fopen(drv->fn, "w")))
	{
		(void)fprintf(stderr, "error: can't open %s\n", drv->fn);
		exit(EXIT_FAILURE);
	}
	(void)printf("writing to 'dd' file %s ...\n", drv->fn);

	if (img_to_drv(drv, di, ti, img))
	{
		(void)printf("Operation terminated incorrectly.\n");
	}
	else
	{
		(void)printf("transfer ok.\n");
	}
	(void)fclose(img->f);
	(void)fclose(drv->fp);
}
static Disk_info *di;
static Track_info *ti;
static Drive *drv;
static Image *img;
static void
menu(void)
{
	char *s;
	(void)printf("\n\nDDTRANS v0.2\n"
				 "(Transfer CPC/+3/PCW-disks to disk-images and vice versa)\n"
				 "(and make newly formatted disks)");
	do
	{
		(void)printf("\n\n1) Set 'dd' file\n"
					 "2) Set Image file\n"
					 "3) Copy 'dd' file -> Image\n"
					 "4) Copy Image -> 'dd' file\n"
					 "5) Format disk\n"
					 "6) Quit\n\n"
					 "Your choice: ");
		s = input();
		switch (s[0]) {
			case '1' :
				set_drive(drv);
				break;
			case '2' :
				set_image_file(img);
				break;
			case '3' :
				copy_drive_image(drv, img, di, ti);
				break;
			case '4' :
				copy_image_drive(drv, img, di, ti);
				break;
			case '5' :
				format_image(drv, img, di, ti);
				break;
			case '6' :
				break;
			default :
				(void)printf(" only 1-6 : ");
		}
	}
	while (s[0] != '6');
}
int
main()
{
	if (!(drv = (Drive *) malloc(sizeof(Drive))))
	{
		(void)fprintf(stderr, "malloc: no memory\n");
		exit(EXIT_FAILURE);
	}
	if (!(drv->fn = malloc(MAXPATHLEN)))
	{
		(void)fprintf(stderr, "malloc: no memory\n");
		exit(EXIT_FAILURE);
	}
	(void)memcpy(drv->fn, "image.p3d", 9);
	if (!(img = (Image *)malloc(sizeof(Image))))
	{
		(void)fprintf(stderr, "malloc: no memory\n");
		exit(EXIT_FAILURE);
	}
	(void)strcpy(img->fname, "default.dsk");
	if (!(di = (Disk_info *)malloc(sizeof(Disk_info))))
	{
		(void)fprintf(stderr, "malloc: no memory\n");
		exit(EXIT_FAILURE);
	}
	if (!(ti = (Track_info *)malloc(sizeof(Track_info))))
	{
		(void)fprintf(stderr, "malloc: no memory\n");
		exit(EXIT_FAILURE);
	}
	menu();
	return 0;
}

