//============================================================================
//
//    SSSS    tt          lll  lll              
//   SS  SS   tt           ll   ll                
//   SS     tttttt  eeee   ll   ll   aaaa    "An Atari 2600 VCS Emulator"
//    SSSS    tt   ee  ee  ll   ll      aa      
//       SS   tt   eeeeee  ll   ll   aaaaa   Copyright (c) 1995,1996,1997
//   SS  SS   tt   ee      ll   ll  aa  aa         Bradford W. Mott
//    SSSS     ttt  eeeee llll llll  aaaaa    
//
//============================================================================

#ifndef RANDOM_HXX
#define RANDOM_HXX

#include "machine.hxx"

/**
  This is a quick-and-dirty random number generator based on information
  in Chapter 7 of the Numerical Recipes in C book.  It's a simple linear
  congruential generator.

  @author  Bradford W. Mott
  @version $Id: Random.hxx,v 1.2 1997/05/17 19:00:07 bwmott Exp $
*/
class Random
{
  public:
    /// Class member function to set the initial random seed
    static void seed(uLong value);

  public:
    /// Construct a random object
    Random();
    
  public:
    /// Answer a random uByte
    operator uByte();
    
    /// Answer a random Byte
    operator Byte();

    /// Answer a random uWord
    operator uWord();
    
    /// Answer a random Word
    operator Word();

    /// Answer a random uLong
    operator uLong();
    
    /// Answer a random Long
    operator Long();

  private:
    // Answer the next pseudo-random number
    uLong next();

  private:
    uLong myValue;

  private:
    static uLong ourSeed;
    static bool ourSeeded;
};
#endif

