//============================================================================
//
//    SSSS    tt          lll  lll              
//   SS  SS   tt           ll   ll                
//   SS     tttttt  eeee   ll   ll   aaaa    "An Atari 2600 VCS Emulator"
//    SSSS    tt   ee  ee  ll   ll      aa      
//       SS   tt   eeeeee  ll   ll   aaaaa   Copyright (c) 1995,1996,1997
//   SS  SS   tt   ee      ll   ll  aa  aa         Bradford W. Mott
//    SSSS     ttt  eeeee llll llll  aaaaa    
//
//============================================================================

#ifndef CONTROLLER_HXX
#define CONTROLLER_HXX

class Controller;
class System;

#include "machine.hxx"

/**
  Base class for 2600 controllers.

  @author  Bradford W. Mott
  @version $Id: Control.hxx,v 1.2 1997/05/17 19:00:05 bwmott Exp $
*/
class Controller
{
  public:
    /// TIA Configuration commands
    enum TIACommand
    {
      EnableDump,    // Enable the dump to ground for this controller
      DisableDump,   // Disable the dump to ground for this controller
      EnableLatch,   // Enable the latch for this controller
      DisableLatch   // Disable the latch for this controller
    };

  public:
    /// Constructor
    Controller(const System& system);
 
    /// Destructor
    virtual ~Controller();

  public: 
    /// Invoked before each frame is generated
    virtual void update();

  public:
    /// Read the PIA information from the controller
    virtual uByte readPIA() const;

    /// Read the TIA information from the controller
    virtual uByte readTIA() const;

    /// Configure the TIA portion of the controller
    virtual void configureTIA(TIACommand command);

  protected:
    const System& mySystem;

    // Bits 0 to 3 represent the state of the 4 inputs connected to the PIA 
    uByte myPIA;

    // Bits 0 to 1 represent the state of the dumped inputs while bit 2
    // represents the state of the latched input connected to the TIA
    uByte myTIA;
};
#endif

