/*
 * FILE:    statistics.h
 * PROGRAM: RAT
 * AUTHOR:  V.J.Hardman
 * CREATED: 23/03/95
 *
 * $Revision: 1.9 $
 * $Date: 1997/02/15 18:40:32 $
 *
 * This module houses the routine from the main execution loop that monitors
 * lost packets, duplicated packets etc.
 *
 * This routine fixes duplications - by throwing away the duplicates
 *
 * This module also contains irregularly executed stats analysis routines
 *
 * Input queue: netrx_queue Output Queue: receive_queue Stats Queue: Stats queue
 *
 * Copyright (c) 1995,1996 University College London
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, is permitted, for non-commercial use only, provided
 * that the following conditions are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. All advertising materials mentioning features or use of this software
 *    must display the following acknowledgement:
 *      This product includes software developed by the Computer Science
 *      Department at University College London
 * 4. Neither the name of the University nor of the Department may be used
 *    to endorse or promote products derived from this software without
 *    specific prior written permission.
 * Use of this software for commercial purposes is explicitly forbidden
 * unless prior written permission is obtained from the authors.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHORS AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESSED OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHORS OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 */


#ifndef _RAT_STATISTICS_H_
#define _RAT_STATISTICS_H_

#define RED_L(x)	((x) & 0x80000000)		/* More blocks      */
#define RED_PT(x)	(((x) & 0x7F000000) >> 24)	/* Payload type     */
#define RED_OFF(x)	(((x) & 0x00FFfC00) >> 10)	/* Timestamp offset */
#define RED_LEN(x)	((x) & 0x000003FF)		/* Block length     */

/*horrid little routines to determine wrap around*/
int ts_gt(u_int32 t1, u_int32 t2);
u_int32 ts_abs_diff(u_int32 t1, u_int32 t2);

int	unit_size(int coding);
int	state_size(int coding);
int	coding_value(int coding);

/*This is the main routine. It unpacks the packet and calculates the playoutpt
 */
void statistics(session_struct    *session_pointer, 
		pckt_queue_struct *netrx_pckt_queue,
		rx_queue_struct   *unitsrx_queue_ptr,
		cushion_struct    *cushion,
		u_int32            cur_time);

#endif /* _RAT_STATISTICS_H_ */

