/************************************************************
 *                                                          *
 *  Permission is hereby granted  to  any  individual   or  *
 *  institution   for  use,  copying, or redistribution of  *
 *  the xgobi code and associated documentation,  provided  *
 *  that   such  code  and documentation are not sold  for  *
 *  profit and the  following copyright notice is retained  *
 *  in the code and documentation:                          *
 *        Copyright (c) 1990, ..., 1996 Bellcore            *
 *                                                          *
 *  We welcome your questions and comments, and request     *
 *  that you share any modifications with us.               *
 *                                                          *
 *    Deborah F. Swayne            Dianne Cook              *
 *   dfs@research.att.com       dicook@iastate.edu          *
 *      (973) 360-8423    www.public.iastate.edu/~dicook/   *
 *                                                          *
 *                    Andreas Buja                          *
 *                andreas@research.att.com                  *
 *              www.research.att.com/~andreas/              *
 *                                                          *
 ************************************************************/

/* ARGSUSED */
XtActionProc
SetCurrentWindow(w, event, params, nparams)
  Widget w;
  XEvent *event;
  String *params;
  Cardinal nparams;
{
  xgobi.current_window = 1;
}

/* ARGSUSED */
XtActionProc
UnsetCurrentWindow(w, event, params, nparams)
  Widget w;
  XEvent *event;
  String *params;
  Cardinal nparams;
{
  XCrossingEvent *evnt = (XCrossingEvent *) event;

  if (evnt->detail != NotifyInferior)
    xgobi.current_window = 0;
}

/* to make xgobi work with motif */
/* ARGSUSED */
XtActionProc
WM_Quit(w, event, params, nparams)
  Widget w;
  XEvent *event;
  String *params;
  Cardinal nparams;
{
  if (w == xgobi.shell)
  {
    xgobi.is_realized = False;
    XtDestroyApplicationContext(XtWidgetToApplicationContext(w));
    exit(0);
  }
  else
    XtPopdown(w);
}

XtActionProc HelpSelect(), Bell();
XtActionProc ShowTarget(), DontShowTarget();
XtActionProc NullNearestPoint();
XtActionProc SetPlotMode();
/* For variable and case lists */
/* XtActionProc GetListSelection(); */
XtActionProc ToggleCurrentLine();
XtActionsRec added_actions[] = {
  {"HelpSelect", (XtActionProc) HelpSelect},
  {"Bell", (XtActionProc) Bell},
  {"SetCurrentWindow", (XtActionProc) SetCurrentWindow},
  {"UnsetCurrentWindow", (XtActionProc) UnsetCurrentWindow},
  {"ShowTarget", (XtActionProc) ShowTarget},
  {"DontShowTarget", (XtActionProc) DontShowTarget},
  {"NullNearestPoint", (XtActionProc) NullNearestPoint},
/* For variable and case lists */
  /* {"GetListSelection", (XtActionProc) GetListSelection}, */
  {"ToggleCurrentLine", (XtActionProc) ToggleCurrentLine},
/* to make xgobi work with motif */
  {"wm_quit", (XtActionProc) WM_Quit}, 
/* main menu */
  {"SetPlotMode", (XtActionProc) SetPlotMode},
};

/*
 * Dummy declarations so the compiler will pass the network
 * section of the code.
*/
/* ARGSUSED */
int
Sread_array_network(d, x)
  char *d;
  xgobidata *x;
{
  return(1);
}
/* ARGSUSED */
int
Sread_collabels_network(d, l, x)
  char *d, *l;
  xgobidata *x;
{
  return(1);
}
/* ARGSUSED */
int
Sread_rowlabels_network(d, l, x)
  char *d, *l;
  xgobidata *x;
{
  return(1);
}

String
fallback_resources[] = {
  "*XGobi.title:    XGobi",
  "*XGobi.iconName: XGobi",
  "*font:          -*-helvetica-bold-r-*-*-14-*-*-*-*-*-*-*",
  "*plotFont:      -*-helvetica-bold-r-*-*-14-*-*-*-*-*-*-*",
  "*helpFont:      -*-helvetica-bold-r-*-*-14-*-*-*-*-*-*-*",
  "*showAxes:      True",
  "*showPoints:    True",
  "*showLines:     False",
  "*linkGlyphBrush: True",
  "*linkColorBrush: True",
  "*linkEraseBrush: True",
  "*linkLineBrush: True",
  "*linkIdentify:  True",
  "*carryVars:     False",
  "*jumpBrush:     True",
  "*reshapeBrush:  False",
  "*plotSquare:    True",
  "*glyphType:     6",
  "*glyphSize:     1",
  "*brushColor0:   Red",
  "*brushColor1:   Green",
  "*brushColor2:   Yellow",
  "*brushColor3:   Orange",
  "*brushColor4:   YellowGreen",
  "*brushColor5:   HotPink",
  "*brushColor6:   SkyBlue",
  "*brushColor7:   SlateBlue",
  "*brushColor8:   Orchid",
  "*brushColor9:   Peru",
  "*defaultPrintCmd: lpr -Pps1",

  "*XGobi*horizDistance: 5",
  "*XGobi*vertDistance: 5",
  "*XGobi*Options*vertDistance: 2",

  "*XGobi*Form1.gripIndent: 5",
  "*XGobi*MainPanel.defaultDistance: 2",

  "*XGobi*PlotWindow.height: 350",
  "*XGobi*PlotWindow.width: 350",

  "*XGobi*VarPanel.hSpace: 1",
  "*XGobi*VarPanel.vSpace: 1",
  "*XGobi*VarPanel.borderWidth: 0",
  "*XGobi*VarPanel.width: 180",
  "*XGobi*VarPanel.top: ChainTop",
  "*XGobi*VarPanel.left: ChainLeft",
  "*XGobi*VarPanel.right: ChainRight",
  "*XGobi*VarPanel.bottom: ChainBottom",

  "*XGobi*VarForm.borderWidth: 0",
  "*XGobi*VarForm.hSpace: 0",
  "*XGobi*VarForm.vSpace: 0",
  "*XGobi*VarWindow.borderWidth: 0",
  "*XGobi*VarWindow.width: 44",
  "*XGobi*VarWindow.vertDistance: 0",

  "*XGobi*TourPanel*hSpace: 3",
  "*XGobi*TourPanel*vSpace: 3",
  "*XGobi*TourPanel*vertDistance: 3",
  "*XGobi*TourPanel*horizDistance: 3",
  "*XGobi*TourPanel*Panel.Scrollbar.vertDistance: 0",

  "*XGobi*PPplot.height:  180",
  "*XGobi*PPplot.width:   500",

  "*XGobi*ScaleShiftPanel*hSpace: 3",
  "*XGobi*ScaleShiftPanel*vSpace: 3",
  "*XGobi*ScaleShiftPanel*Icon.horizDistance: 0",
  "*XGobi*ScaleShiftPanel*Icon.vertDistance: 0",

  "*XGobi*StdizePanel*hSpace: 3",
  "*XGobi*StdizePanel*vSpace: 3",
  "*XGobi*StdizePanel*horizDistance: 3",
  "*XGobi*StdizePanel*vertDistance: 3",

  "*XGobi*BrushPanel.Panel.hSpace: 2",
  "*XGobi*BrushPanel.Panel.vSpace: 2",

  "*XGobi*FSavePopup*FSaveName.height: 25",
  "*XGobi*FSavePopup*FSaveName.width: 265",
  "*XGobi*FSavePopup*FSaveText.height: 25",

  "*XGobi*Help*Text.height: 250",
  "*XGobi*Help*Text.width: 600",

  "*XGobi*MouseLabel.left: ChainLeft",
  "*XGobi*MouseLabel.right: ChainLeft",
  "*XGobi*MouseLabel.top: ChainTop",
  "*XGobi*MouseLabel.bottom: ChainTop",
  "*XGobi*MouseLabel.mappedWhenManaged: False",
  "*XGobi*VarMouseLabel.left: ChainLeft",
  "*XGobi*VarMouseLabel.right: ChainLeft",
  "*XGobi*VarMouseLabel.top: ChainTop",
  "*XGobi*VarMouseLabel.bottom: ChainTop",

/* ... if we named each of these widgets,
   we could put the accelerators under user control.
   And save some code.  (This isn't so easy now that they're
   on the menu ....)
  "*XGobi*DotPlot.accelerators: <Key>D: set() notify()",
  "*XGobi*XYPlot.accelerators: <Key>X: set() notify()",
*/
  /* Accelerators */
  "*XGobi*ViewMenuButton.Menu.Accelerators: #augment\\n\
    <Key>d: SetPlotMode(d)\\n\
    <Key>x: SetPlotMode(x)\\n",

  /* Translations */
  "*XGobi*Form0.Translations: #augment \\n\
    <EnterWindow>:  SetCurrentWindow() \\n\
    <LeaveWindow>:  UnsetCurrentWindow()",
  "*XGobi*Subset0.Translations: #augment \\n\
    <EnterWindow>:  SetCurrentWindow() \\n\
    <LeaveWindow>:  UnsetCurrentWindow()",

  "*XGobi*VarPanel.Translations: #augment \\n\
    <EnterWindow>:  ShowTarget() \\n\
    <LeaveWindow>:  DontShowTarget()",

  "*XGobi*Scrollbar.Translations: #override \\n\
    <Btn1Down>:   StartScroll(Continuous) MoveThumb() NotifyThumb() \\n\
    <Btn1Motion>: MoveThumb() NotifyThumb() \\n\
    <Btn3Down>:   HelpSelect()",

  "*XGobi*List.Translations: #augment \\n\
    <EnterWindow>:  SetCurrentWindow() \\n\
    <LeaveWindow>:  UnsetCurrentWindow()",
  "*XGobi*List*Text.Translations: #replace \\n\
    <Btn1Down>:     select-start() ToggleCurrentLine() \\n\
    <Btn1Motion>:   select-start() ToggleCurrentLine()",
/*
 *  <Btn1Motion>:   ToggleCurrentLine()",
 *  Ctrl<Key>R:     search(backward) \\n\
 *  Ctrl<Key>S:     search(forward)",
*/

/*
 *  <Btn2Down>:     select-start() \\n\
 *  <Btn2Motion>:   extend-adjust() \\n\
 *  <Btn2Up>:       extend-end(PRIMARY, CUT_BUFFER0) GetListSelection() \\n\
*/

  "*XGobi*PrintText.Translations: #override <Key>Return: Bell()",
  "*XGobi*MissingText.Translations: #override <Key>Return: Bell()",

  "*XGobi*Toggle.Translations: #override \\n\
    <EnterWindow>:         highlight(Always) \\n\
    <LeaveWindow>:         unhighlight() \\n\
    <Btn1Down>, <Btn1Up>:  set()notify() \\n\
    <Btn3Down>:            HelpSelect()",

  "*XGobi*Command.Translations: #override <Btn3Down>: HelpSelect()",
  "*XGobi*MenuButton.Translations: #override <Btn3Down>: HelpSelect()",
  "*XGobi*PlotWindow.Translations: #override \\n\
     <LeaveWindow>:  NullNearestPoint() \\n\
     <Btn3Down>:     HelpSelect()",
  "*XGobi*VarLabel.Translations: #override <Btn3Down>: HelpSelect()",
  "*XGobi*VarWindow.Translations: #override <Btn3Down>: HelpSelect()",
  "*XGobi*Icon.Translations: #override <Btn3Down>: HelpSelect()",

  /* Menu Icon */
  "*XGobi*MenuButton.leftBitmap: menu12",

  /* Colors */

  "*XGobi*background: Moccasin",
  "*XGobi*foreground: NavyBlue",
  "*pointerColor: White",
  "*XGobi*MainPanel.background: DarkKhaki",
  "*XGobi*PlotWindow.background: blue4",
  "*XGobi*PlotWindow.foreground: white",
  "*XGobi*Command.background: SandyBrown",
  "*XGobi*Command.borderColor: NavyBlue",
  "*XGobi*Command.foreground: NavyBlue",
  "*XGobi*Toggle.background: SandyBrown",
  "*XGobi*Toggle.borderColor: NavyBlue",
  "*XGobi*Toggle.foreground: NavyBlue",
  "*XGobi*MenuButton.background: SandyBrown",
  "*XGobi*MenuButton.borderColor: NavyBlue",
  "*XGobi*MenuButton.foreground: NavyBlue",
  "*XGobi*Scrollbar.background: SandyBrown",
  "*XGobi*Scrollbar.borderColor: NavyBlue",
  "*XGobi*Scrollbar.foreground: NavyBlue",
  /*
   * This is ignored; the arrows are created with certain
   * color characteristics.  See make_arrows() in widgets.c.
  "*XGobi*Arrow.background: SandyBrown",
  "*XGobi*Arrow.borderColor: NavyBlue",
  */

  "*XGobi*PPplot.background: Blue4",
  "*XGobi*PPplot.foreground: white",

  "*XGobi*BrushPanel.background: PeachPuff",
  "*XGobi*BrushPanel.Panel.background: DarkKhaki",
  "*XGobi*BrushPanel*Menu*background: NavyBlue",
  "*XGobi*BrushPanel*Menu*borderColor: White",
  "*XGobi*BrushPanel*Menu*foreground: White",
  "*XGobi*Help*background: Gray85",
  "*XGobi*Help*foreground: NavyBlue",
  "*XGobi*Help*Done.background: Moccasin",

  "*XGobi*IdentifyPanel.Panel.background: DarkKhaki",

  "*XGobi*ScalePanel.background: DarkKhaki",
  "*XGobi*ShiftPanel.background: DarkKhaki",
  "*XGobi*StdizePanel.background: DarkKhaki",

  "*XGobi*Subset*Param.background: DarkKhaki",

  "*XGobi*SpinPanel.Panel.background: DarkKhaki",
  "*XGobi*SpinPanel.background: PeachPuff",
  "*XGobi*TourPanel*Menu*background: DarkKhaki",
  "*XGobi*TourPanel*Menu*foreground: NavyBlue",
  "*XGobi*TourPanel*Panel.background: DarkKhaki",
  "*XGobi*TourPanel*TourLabel.background: PeachPuff",
  "*XGobi*TourPanel.background: PeachPuff",
  "*XGobi*XYPlotPanel.background: PeachPuff",

  /*"*XGobi*VarPanel.foreground: DarkKhaki",*/
  "*XGobi*VarPanel*VarLabel.background: PeachPuff",
  "*XGobi*VarPanel*VarLabel.foreground: NavyBlue",

  "*XGobi*MouseLabel.background: Salmon",
  "*XGobi*MouseLabel.foreground: NavyBlue",
  "*XGobi*VarMouseLabel.background: Salmon",
  "*XGobi*VarMouseLabel.foreground: NavyBlue",

  /* For Juergen */
  "*isCloned:  False",
  "*clonePID:  0",
  "*cloneTime: 0",
  "*cloneType: 0",
  "*cloneName: XGobi",
  "*deleteCloneData: True",

  NULL
};

void
XGobiMainLoop(xg)
  xgobidata *xg;
{
  XEvent event;
  XEvent ahead;
  Drawable root_window = DefaultRootWindow(display);
  void read_ids(), read_paint(), read_rows_in_plot(), read_line_paint();
  void read_tour_coefs();
  Boolean RunWorkProcs();

/*
 * Set up to receive Property Change events.
*/
  XSelectInput(display, DefaultRootWindow(display), PropertyChangeMask);

/* ? dfs */
  xgobi.current_window = 0;

  while (1)
  {
    XtAppNextEvent(app_con, &event);
    /*printf("event.type = %d\n", event.type);*/

    if (event.type == MotionNotify &&
        event.xmotion.window == xg->plot_window)
    {
      /* Compress motion events */
      while (XEventsQueued(display, QueuedAfterFlush) > 0)
      {
        XPeekEvent(display, &ahead);
        if (ahead.type == MotionNotify &&
            ahead.xmotion.window == xg->plot_window)
        {
          XtAppNextEvent(app_con, &event);
        }
        else if ( (ahead.type == PropertyNotify ||
                   ahead.type == NoExpose) &&
                   ahead.xany.window == xg->plot_window )
        {
          XtAppNextEvent(app_con, &ahead);
        }
        else
          break;
      }
      XtDispatchEvent(&event);
    }

    else if (event.type == PropertyNotify &&
             event.xproperty.window == root_window)
    {
      if (event.xproperty.atom == XG_NEWTOUR_ANNC)
      {
        if (xg->is_touring &&
            xg->tour_link_state == receive &&
            !xg->is_tour_paused &&
            !xg->is_scaling && !xg->is_brushing &&
            !xg->is_line_editing && !xg->is_identify)
        {
          read_tour_coefs(xg);
        }
      }
      else
      {
        Boolean link_brush = xg->link_erase_brushing ||
                             xg->link_glyph_brushing ||
                             xg->link_color_brushing;
        /*fprintf(stderr, "property notify event\n");*/
        if (!xg->current_window &&

            ( (event.xproperty.atom == XG_NEWPAINT_ANNC &&
               link_brush) ||

             (event.xproperty.atom == XG_IDS_ANNC &&
               xg->link_identify) ||

             (event.xproperty.atom == XG_ROWSINPLOT_ANNC &&
               link_brush) ||

             (event.xproperty.atom == XG_NEWLINEPAINT_ANNC &&
              xg->link_line_brushing) )
          )
        {
           /* Compress PropertyNotify events */
/*
 * Danger:  if line brushing and point brushing at the same
 * time, will some important events be thrown away?
*/
          while (XEventsQueued(display, QueuedAfterFlush) > 0)
          {
            XPeekEvent(display, &ahead);
            if (ahead.type == PropertyNotify && 
                ahead.xproperty.window == event.xproperty.window &&
                ahead.xproperty.atom == event.xproperty.atom)
            {
              XtAppNextEvent(app_con, &event);
            }
            else
              break;
          }
        
          if (event.xproperty.atom == XG_ROWSINPLOT_ANNC)
            read_rows_in_plot(xg);
          else if (event.xproperty.atom == XG_NEWPAINT_ANNC)
            read_paint(xg);
          else if (event.xproperty.atom == XG_NEWLINEPAINT_ANNC)
            read_line_paint(xg);
          else if (event.xproperty.atom == XG_IDS_ANNC)
            read_ids(xg) ;
        }
      }
    }
    /*
     * This section is to turn off identification when xgobi is
     * iconified.
    */
      /* Shut off the work proc if the main window is iconified */
    else if (event.type == UnmapNotify &&
             event.xany.window == XtWindow(xgobi.shell))
    {
      xgobi.is_iconified = True;
    }
    /*
     * Restart the work proc if deiconified.  If there shouldn't
     * be a work proc running, it will turn itself off after one
     * run-through
    */
    else if (event.type == MapNotify)
    {
      xgobi.is_iconified = False;
      XtAppAddWorkProc(app_con, RunWorkProcs, (XtPointer) NULL);
    }
    else if (event.xany.window == XtWindow(xgobi.shell) &&
             event.type == DestroyNotify)
    {
      XtDestroyApplicationContext(app_con);
      exit(0);
    }

    else
      XtDispatchEvent(&event);
  }
}


