/************************************************************
 *                                                          *
 *  Permission is hereby granted  to  any  individual   or  *
 *  institution   for  use,  copying, or redistribution of  *
 *  the xgobi code and associated documentation,  provided  *
 *  that   such  code  and documentation are not sold  for  *
 *  profit and the  following copyright notice is retained  *
 *  in the code and documentation:                          *
 *        Copyright (c) 1990, ..., 1996 Bellcore            *
 *                                                          *
 *  We welcome your questions and comments, and request     *
 *  that you share any modifications with us.               *
 *                                                          *
 *    Deborah F. Swayne            Dianne Cook              *
 *   dfs@research.att.com       dicook@iastate.edu          *
 *      (973) 360-8423    www.public.iastate.edu/~dicook/   *
 *                                                          *
 *                    Andreas Buja                          *
 *                andreas@research.att.com                  *
 *              www.research.att.com/~andreas/              *
 *                                                          *
 ************************************************************/

#include <stdio.h>
#include "xincludes.h"
#include "xgobitypes.h"
#include "xgobivars.h"
#include "xgobiexterns.h"

static Widget stdview_panel, stdview_sbar, stdview_label;
static Widget stdview_menu_cmd;
static Widget stdview_menu, stdview_menu_btn[3];
static Widget scale_shift_panel, scale_type_cmd ;
static Widget scale_panel[2], scale_cmd[6], shift_cmd[4] ;
static Widget scale_reset_cmd;
static Widget cntr_panel, shift_panel[2], shift_reset_cmd ;

void
map_scaling(xg, scaling)
  xgobidata *xg;
  Boolean scaling;
{
  if (scaling)
  {
    XtMapWidget(scale_shift_panel);
    XtMapWidget(stdview_panel);
    XtMapWidget(xg->scale_mouse);
  }
  else
  {
    XtUnmapWidget(scale_shift_panel);
    XtUnmapWidget(stdview_panel);
    XtUnmapWidget(xg->scale_mouse);
  }
}

/* ARGSUSED */
XtCallbackProc
scale_type_cback(w, xg, callback_data)
  Widget w;
  xgobidata *xg;
  caddr_t callback_data;
{
  xg->plot_square = !xg->plot_square ;
  plane_to_screen(xg);

  if (xg->is_xyplotting)
    init_ticks(&xg->xy_vars, xg);
  else if (xg->is_dotplotting)
    init_ticks(&xg->dotplot_vars, xg);

  plot_once(xg);
}

/* ARGSUSED */
XtEventHandler
scale_release_cback(w, xg, evnt, cont)
  Widget w;
  xgobidata *xg;
  XEvent *evnt;
  Boolean *cont;
{
  XButtonEvent *xbutton = (XButtonEvent *) evnt;

  if (xbutton->button == 1 || xbutton->button == 2)
    xg->run_scale_proc = False;
}

/* ARGSUSED */
XtCallbackProc
scale_reset_cback(w, xg, callback_data)
/*
 * Reset the screen image to original scale.
*/
  Widget w;
  xgobidata *xg;
  caddr_t callback_data;
{
  if (!xg->is_touring)
  {
    xg->scale.x = xg->scale0.x;
    xg->scale.y = xg->scale0.y;
  }
  else
  {
    xg->tour_scale.x = xg->tour_scale0.x;
    xg->tour_scale.y = xg->tour_scale0.y;
  }

/* This may need doing; it depends on scale.x and scale.y */
  set_shift_wrld0(xg);

  plane_to_screen(xg);

  if (xg->is_xyplotting)
  {
    convert_ticks(xg->minindex, xg->minindex, &xg->ticks0, xg);
    convert_axes(&xg->ticks0, xg);
    convert_ticks(xg->xy_vars.x, xg->xy_vars.y, &xg->ticks, xg);
    extend_axes(xg->xy_vars.x, xg->xy_vars.y, &xg->ticks, xg);
    build_ticks(xg->xy_vars.x, xg->xy_vars.y, &xg->ticks, xg);
  }

  else if (xg->is_dotplotting)
  {
    convert_ticks(xg->minindex, xg->minindex, &xg->ticks0, xg);
    convert_axes(&xg->ticks0, xg);
    convert_ticks(xg->dotplot_vars.x, xg->dotplot_vars.y, &xg->ticks, xg);
    extend_axes(xg->dotplot_vars.x, xg->dotplot_vars.y, &xg->ticks, xg);
    build_ticks(xg->dotplot_vars.x, xg->dotplot_vars.y, &xg->ticks, xg);
  }

  plot_once(xg);
}

/* ARGSUSED */
XtEventHandler
shift_release_cback(w, xg, evnt, cont)
  Widget w;
  xgobidata *xg;
  XEvent *evnt;
  Boolean *cont;
{
  XButtonEvent *xbutton = (XButtonEvent *) evnt;

  if (xbutton->button == 1 || xbutton->button == 2)
    xg->run_shift_proc = False;
}

/* ARGSUSED */
XtCallbackProc
shift_reset_cback(w, xg, callback_data)
/*
 * Reset the screen image to original center.
*/
  Widget w;
  xgobidata *xg;
  caddr_t callback_data;
{
  xg->shift_scrn.x = 0;
  xg->shift_scrn.y = 0;
  xg->shift_wrld.x = 0;
  xg->shift_wrld.y = 0;
  find_plot_center(xg);
  plane_to_screen(xg);

  if (xg->is_xyplotting)
  {
    convert_ticks(xg->minindex, xg->minindex, &xg->ticks0, xg);
    convert_axes(&xg->ticks0, xg);
    convert_ticks(xg->xy_vars.x, xg->xy_vars.y, &xg->ticks, xg);
    extend_axes(xg->xy_vars.x, xg->xy_vars.y, &xg->ticks, xg);
    build_ticks(xg->xy_vars.x, xg->xy_vars.y, &xg->ticks, xg);
  }

  else if (xg->is_dotplotting)
  {
    convert_ticks(xg->minindex, xg->minindex, &xg->ticks0, xg);
    convert_axes(&xg->ticks0, xg);
    convert_ticks(xg->dotplot_vars.x, xg->dotplot_vars.y, &xg->ticks, xg);
    extend_axes(xg->dotplot_vars.x, xg->dotplot_vars.y, &xg->ticks, xg);
    build_ticks(xg->dotplot_vars.x, xg->dotplot_vars.y, &xg->ticks, xg);
  }

  plot_once(xg);
}

void
set_cntr_label(xg)
  xgobidata *xg;
{
  if (xg->scale_cntr)
    XtVaSetValues(cntr_panel,
      XtNlabel, "Plot Center",
      NULL);
  else
    XtVaSetValues(cntr_panel,
      XtNlabel, "Data Center",
      NULL);
}

/* ARGSUSED */
XtCallbackProc
scale_cntr_cback(w, xg, callback_data)
/*
 * Change between using data center and plot center for scaling
*/
  Widget w;
  xgobidata *xg;
  caddr_t callback_data;
{
  set_cntr_label(xg);
  xg->scale_cntr = !xg->scale_cntr;

  if (xg->scale_cntr)
  {
    /*
     * switch from plot center to data center
    */
    xg->shift_scrn.x = xg->shift_scrn0 * xg->shift_wrld.x /
                       xg->shift_wrld0.x;
    xg->shift_scrn.y = xg->shift_scrn0 * xg->shift_wrld.y /
                       xg->shift_wrld0.y;
  }
  else
  {
    /*
     * switch from data center to plot center
    */
    xg->shift_wrld.x = xg->shift_wrld0.x * xg->shift_scrn.x /
                       xg->shift_scrn0;
    xg->shift_wrld.y = xg->shift_wrld0.y * xg->shift_scrn.y /
                       xg->shift_scrn0;
  }

  plane_to_screen(xg);
  plot_once(xg);
}

/*____Initialization section____*/

/* ARGSUSED */
XtCallbackProc
choose_stdview_cback(w, xg, callback_data)
  Widget w;
  xgobidata *xg;
  caddr_t callback_data;
{
  int k;
/*
 * Find out which transformation to do.
*/
  for (k=0; k<3; k++)
  {
    if (stdview_menu_btn[k] == w)
    {
      xg->std_type = k;
      break;
    }
  }

  for (k=0; k<3; k++)
    XtVaSetValues(stdview_menu_btn[k],
      XtNleftBitmap, None,
      NULL);

  XtVaSetValues(w,
    XtNleftBitmap, menu_mark,
    NULL);

  update_lims(xg);
  update_world(xg);
  world_to_plane(xg);
  plane_to_screen(xg);

  if (xg->is_xyplotting)
    init_ticks(&xg->xy_vars, xg);
  else if (xg->is_dotplotting)
    init_ticks(&xg->dotplot_vars, xg);
  plot_once(xg);
}

void
reset_std_width(xg)
  xgobidata *xg;
{
  char lab[5];

  (void) sprintf(lab, "%3.1f", xg->std_width);
  XtVaSetValues(stdview_label,
    XtNlabel, (String) lab,
    NULL);

  update_lims(xg);
  update_world(xg);
  world_to_plane(xg);
  plane_to_screen(xg);

  if (xg->is_xyplotting)
    init_ticks(&xg->xy_vars, xg);
  else if (xg->is_dotplotting)
    init_ticks(&xg->dotplot_vars, xg);

  plot_once(xg);
}

/*
 * In the following routines, we are allowing std_width to range
 * between 0.1 and 10.1, while most of the Xaw functions treat the
 * length of the scrollbar as 1.0.
*/

/* ARGSUSED */
XtEventHandler
scale_param_rightarr_cback(w, xg, evnt, cont)
  Widget w;
  xgobidata *xg;
  XEvent *evnt;
  Boolean *cont;
{
  XButtonEvent *xbutton = (XButtonEvent *) evnt;

  if (xbutton->button == 1 || xbutton->button == 2)
  {
    if (xg->std_width < 10.)
    {
      xg->std_width += .1;
      reset_std_width(xg);
      XawScrollbarSetThumb(stdview_sbar,
        .1*(xg->std_width-.1), -1.);
    }
  }
}
/* ARGSUSED */
XtEventHandler
scale_param_leftarr_cback(w, xg, evnt, cont)
  Widget w;
  xgobidata *xg;
  XEvent *evnt;
  Boolean *cont;
{
  XButtonEvent *xbutton = (XButtonEvent *) evnt;

  if (xbutton->button == 1 || xbutton->button == 2)
  {
    if (xg->std_width > .1)
    {
      xg->std_width -= .1;
      reset_std_width(xg);
      XawScrollbarSetThumb(stdview_sbar,
        .1*(xg->std_width-.1), -1.);
    }
  }
}

/* ARGSUSED */
XtEventHandler
scale_press_cback(w, xg, evnt, cont)
  Widget w;
  xgobidata *xg;
  XEvent *evnt;
  Boolean *cont;
{
  XButtonEvent *xbutton = (XButtonEvent *) evnt;
  int j;

  if (xbutton->button == 1 || xbutton->button == 2)
  {
    for (j=0; j<6; j++)
    {
      if (scale_cmd[j] == w)
      {
        xg->scaling_btn = j;
        break;
      }
    }
    reinit_nsteps();
    xg->run_scale_proc = True;
    (void) XtAppAddWorkProc(app_con, RunWorkProcs, (XtPointer) NULL);
  }
}

/* ARGSUSED */
XtEventHandler
shift_press_cback(w, xg, evnt, cont)
  Widget w;
  xgobidata *xg;
  XEvent *evnt;
  Boolean *cont;
{
  XButtonEvent *xbutton = (XButtonEvent *) evnt;
  int j;

  if (xbutton->button == 1 || xbutton->button == 2)
  {
    for (j=0; j<4; j++)
    {
      if (shift_cmd[j] == w)
      {
        xg->scaling_btn = j;
        break;
      }
    }
    reinit_nsteps();
    xg->run_shift_proc = True;
    (void) XtAppAddWorkProc(app_con, RunWorkProcs, (XtPointer) NULL);
  }
}



/* ARGSUSED */
XtCallbackProc
scale_param_cback(w, xg, slideposp)
  Widget w;
  xgobidata *xg;
  XtPointer slideposp;
{
  float fslidepos = * (float *) slideposp;

  xg->std_width = fslidepos * 10. + .1;
  reset_std_width(xg);
}


void
make_stdview_menu(xg)
/*
 * Build a menu to contain standardization options.
*/
  xgobidata *xg;
{
  int j;
  static char *stdview_names[] = {
    "Min/Max", /* default */ "Mean/StdDev", "Median/MAD"
  };

  stdview_menu_cmd = XtVaCreateManagedWidget("MenuButton",
    menuButtonWidgetClass, stdview_panel,
    XtNlabel, (String) "Stdization",
    XtNmenuName, (String) "Menu",
    NULL);
  if (mono) set_mono(stdview_menu_cmd);
  add_menupb_help(&xg->nhelpids.menupb,
    stdview_menu_cmd, "Sc_StdizeMenu");

  stdview_menu = XtVaCreatePopupShell("Menu",
    simpleMenuWidgetClass, stdview_menu_cmd,
    NULL);
  if (mono) set_mono(stdview_menu);

  for (j=0; j<3; j++)
  {
    stdview_menu_btn[j] = XtVaCreateWidget("Command",
      smeBSBObjectClass, stdview_menu,
      XtNlabel, (String) stdview_names[j],
      XtNleftMargin, (Dimension) 24,
      NULL);
    if (mono) set_mono(stdview_menu_btn[j]);
    XtAddCallback(stdview_menu_btn[j], XtNcallback,
      (XtCallbackProc) choose_stdview_cback, (XtPointer) xg);
  }

  XtManageChildren(stdview_menu_btn, 3);
}

void
init_stdview_menu(xg)
/*
 * Indicate the initial standardization type.
*/
  xgobidata *xg;
{
  XtVaSetValues(stdview_menu_btn[xg->std_type],
    XtNleftBitmap, menu_mark,
    NULL);
}

void
make_scaling(xg)
  xgobidata *xg;
{
  int j;
/*
 * ScaleShiftPanel
*/
  scale_shift_panel = XtVaCreateManagedWidget("ScaleShiftPanel",
    boxWidgetClass, xg->box0,
    XtNleft, (XtEdgeType) XtChainLeft,
    XtNright, (XtEdgeType) XtChainLeft,
    XtNtop, (XtEdgeType) XtChainTop,
    XtNbottom, (XtEdgeType) XtChainTop,
    XtNmappedWhenManaged, (Boolean) False,
    NULL);
  if (mono) set_mono(scale_shift_panel);

/*
 * ScalePanel
*/
  scale_panel[0] = XtVaCreateManagedWidget("ScalePanel",
    boxWidgetClass, scale_shift_panel,
    NULL);
  if (mono) set_mono(scale_panel[0]);
/*
 * Reset scale control button
*/
  scale_reset_cmd = CreateCommand(xg, "Reset Scale",
    True, (Widget) NULL, (Widget) NULL,
    scale_panel[0], "Sc_ResetScale");
  XtManageChild(scale_reset_cmd);
/*
 * Panel of arrow and pushbutton widgets for scale control
*/
  scale_panel[1] = XtVaCreateManagedWidget("Panel",
    formWidgetClass, scale_panel[0],
    XtNdefaultDistance, (Dimension) 0,
    NULL);
  if (mono) set_mono(scale_panel[1]);

  scale_cmd[0] = XtVaCreateWidget("Icon",
    labelWidgetClass, scale_panel[1],
    XtNinternalHeight, (Dimension) 0,
    XtNinternalWidth, (Dimension) 0,
    XtNborderColor, (Pixel) appdata.fg,
    XtNbitmap, (Pixmap) uparr,
    NULL);
  if (mono) set_mono(scale_cmd[0]);
  add_pb_help(&xg->nhelpids.pb,
    scale_cmd[0], "Sc_ScaleCtrl");

  scale_cmd[1] = XtVaCreateWidget("Icon",
    labelWidgetClass, scale_panel[1],
    XtNinternalHeight, (Dimension) 0,
    XtNinternalWidth, (Dimension) 0,
    XtNborderColor, (Pixel) appdata.fg,
    XtNfromHoriz, (Widget) scale_cmd[0],
    XtNbitmap, (Pixmap) plus,
    NULL);
  if (mono) set_mono(scale_cmd[1]);
  add_pb_help(&xg->nhelpids.pb, scale_cmd[1], "Sc_ScaleCtrl");

  scale_cmd[2] = XtVaCreateWidget("Icon",
    labelWidgetClass, scale_panel[1],
    XtNinternalHeight, (Dimension) 0,
    XtNinternalWidth, (Dimension) 0,
    XtNborderColor, (Pixel) appdata.fg,
    XtNbitmap, (Pixmap) rightarr,
    XtNfromHoriz, (Widget) scale_cmd[1],
    NULL);
  if (mono) set_mono(scale_cmd[2]);
  add_pb_help(&xg->nhelpids.pb,
    scale_cmd[2], "Sc_ScaleCtrl");

  scale_cmd[3] = XtVaCreateWidget("Icon",
    labelWidgetClass, scale_panel[1],
    XtNinternalHeight, (Dimension) 0,
    XtNinternalWidth, (Dimension) 0,
    XtNborderColor, (Pixel) appdata.fg,
    XtNbitmap, (Pixmap) downarr,
    XtNfromVert, (Widget) scale_cmd[0],
    NULL);
  if (mono) set_mono(scale_cmd[3]);
  add_pb_help(&xg->nhelpids.pb,
    scale_cmd[3], "Sc_ScaleCtrl");

  scale_cmd[4] = XtVaCreateWidget("Icon",
    labelWidgetClass, scale_panel[1],
    XtNinternalHeight, (Dimension) 0,
    XtNinternalWidth, (Dimension) 0,
    XtNborderColor, (Pixel) appdata.fg,
    XtNbitmap, (Pixmap) minus,
    XtNfromVert, (Widget) scale_cmd[1],
    XtNfromHoriz, (Widget) scale_cmd[3],
    NULL);
  if (mono) set_mono(scale_cmd[4]);
  add_pb_help(&xg->nhelpids.pb, scale_cmd[4], "Sc_ScaleCtrl");

  scale_cmd[5] = XtVaCreateWidget("Icon",
    labelWidgetClass, scale_panel[1],
    XtNinternalHeight, (Dimension) 0,
    XtNinternalWidth, (Dimension) 0,
    XtNborderColor, (Pixel) appdata.fg,
    XtNbitmap, (Pixmap) leftarr,
    XtNfromVert, (Widget) scale_cmd[2],
    XtNfromHoriz, (Widget) scale_cmd[4],
    NULL);
  if (mono) set_mono(scale_cmd[5]);
  add_pb_help(&xg->nhelpids.pb,
    scale_cmd[5], "Sc_ScaleCtrl");

  XtManageChildren(scale_cmd, 6);
/*
 * CenterPanel: for switching between using data center (default)
 *  and plot center for scaling purposes.
*/
  cntr_panel = CreateCommand(xg, "Data Center",
    True, (Widget) NULL, scale_panel[1],
    scale_panel[0], "Sc_Center");
  XtManageChild(cntr_panel);

/*
 * Make square plot or use max window size.
*/
   scale_type_cmd = CreateToggle(xg, "Plot Square", True,
    (Widget) NULL, (Widget) cntr_panel, (Widget) NULL,
    xg->plot_square, ANY_OF_MANY, scale_panel[0], "Sc_ScaleType");
  XtManageChild(scale_type_cmd);
  XtAddCallback(scale_type_cmd, XtNcallback,
    (XtCallbackProc) scale_type_cback, (XtPointer) xg);

/*
 * ShiftPanel
*/
  shift_panel[0] = XtVaCreateManagedWidget("ShiftPanel",
    boxWidgetClass, scale_shift_panel,
    NULL);
  if (mono) set_mono(shift_panel[0]);
/*
 * Shift reset control button
*/
  shift_reset_cmd = CreateCommand(xg, "Reset Shift",
    True, (Widget) NULL, (Widget) NULL,
    shift_panel[0], "Sc_ResetShift");
  XtManageChild(shift_reset_cmd);
/*
 * Panel of pushbutton and arrow widgets for shift control.
*/
  shift_panel[1] = XtVaCreateManagedWidget("Panel",
    formWidgetClass, shift_panel[0],
    XtNdefaultDistance, (Dimension) 0,
    NULL);
  if (mono) set_mono(shift_panel[1]);

  shift_cmd[0] = XtVaCreateWidget("Icon",
    labelWidgetClass, shift_panel[1],
    XtNinternalHeight, (Dimension) 0,
    XtNinternalWidth, (Dimension) 0,
    XtNborderColor, (Pixel) appdata.fg,
    XtNbitmap, (Pixmap) uparr,
    NULL);
  if (mono) set_mono(shift_cmd[0]);
  add_pb_help(&xg->nhelpids.pb,
    shift_cmd[0], "Sc_ShiftCtrl");

  shift_cmd[1] = XtVaCreateWidget("Icon",
    labelWidgetClass, shift_panel[1],
    XtNinternalHeight, (Dimension) 0,
    XtNinternalWidth, (Dimension) 0,
    XtNborderColor, (Pixel) appdata.fg,
    XtNfromHoriz, (Widget) shift_cmd[0],
    XtNbitmap, (Pixmap) rightarr,
    NULL);
  if (mono) set_mono(shift_cmd[1]);
  add_pb_help(&xg->nhelpids.pb,
    shift_cmd[1], "Sc_ShiftCtrl");

  shift_cmd[2] = XtVaCreateWidget("Icon",
    labelWidgetClass, shift_panel[1],
    XtNinternalHeight, (Dimension) 0,
    XtNinternalWidth, (Dimension) 0,
    XtNborderColor, (Pixel) appdata.fg,
    XtNfromVert, (Widget) shift_cmd[0],
    XtNbitmap, (Pixmap) downarr,
    NULL);
  if (mono) set_mono(shift_cmd[2]);
  add_pb_help(&xg->nhelpids.pb,
    shift_cmd[2], "Sc_ShiftCtrl");

  shift_cmd[3] = XtVaCreateWidget("Icon",
    labelWidgetClass, shift_panel[1],
    XtNinternalHeight, (Dimension) 0,
    XtNinternalWidth, (Dimension) 0,
    XtNborderColor, (Pixel) appdata.fg,
    XtNfromHoriz, (Widget) shift_cmd[2],
    XtNfromVert, (Widget) shift_cmd[1],
    XtNbitmap, (Pixmap) leftarr,
    NULL);
  if (mono) set_mono(shift_cmd[3]);
  add_pb_help(&xg->nhelpids.pb,
    shift_cmd[3], "Sc_ShiftCtrl");

  XtManageChildren(shift_cmd, 4);

/*
 * Scaling and shifting callbacks
*/
  for (j=0; j<6; j++)
  {
    XtAddEventHandler(scale_cmd[j], ButtonPressMask,
      FALSE, (XtEventHandler) scale_press_cback, (XtPointer) xg);
    XtAddEventHandler(scale_cmd[j], ButtonReleaseMask,
      FALSE, (XtEventHandler) scale_release_cback, (XtPointer) xg);
  }

  for (j=0; j<4; j++)
  {
    XtAddEventHandler(shift_cmd[j], ButtonPressMask,
      FALSE, (XtEventHandler) shift_press_cback, (XtPointer) xg);
    XtAddEventHandler(shift_cmd[j], ButtonReleaseMask,
      FALSE, (XtEventHandler) shift_release_cback, (XtPointer) xg);
  }

  XtAddCallback(scale_reset_cmd, XtNcallback,
    (XtCallbackProc) scale_reset_cback, (XtPointer) xg);
  XtAddCallback(shift_reset_cmd, XtNcallback,
    (XtCallbackProc) shift_reset_cback, (XtPointer) xg);
  XtAddCallback(cntr_panel, XtNcallback,
    (XtCallbackProc) scale_cntr_cback, (XtPointer) xg);
}

void
make_stdview(xg)
  xgobidata *xg;
{
  char lab[5], str[30];
  Dimension width;
  Widget std_cmd[2];

  stdview_panel = XtVaCreateManagedWidget("StdizePanel",
    formWidgetClass, xg->box0,
    XtNfromVert, (Widget) scale_shift_panel,
    XtNleft, (XtEdgeType) XtChainLeft,
    XtNright, (XtEdgeType) XtChainLeft,
    XtNtop, (XtEdgeType) XtChainTop,
    XtNbottom, (XtEdgeType) XtChainTop,
    XtNmappedWhenManaged, (Boolean) False,
    NULL);
  if (mono) set_mono(stdview_panel);

  make_stdview_menu(xg);
/*
 * number of scale factors around location scrollbar
*/
  std_cmd[0] = XtVaCreateWidget("Icon",
    labelWidgetClass, stdview_panel,
    XtNinternalHeight, (Dimension) 0,
    XtNinternalWidth, (Dimension) 0,
    XtNborderColor, (Pixel) appdata.fg,
    XtNfromVert, (Widget) stdview_menu_cmd,
    XtNbitmap, (Pixmap) leftarr,
    NULL);
  if (mono) set_mono(std_cmd[0]);
  add_pb_help(&xg->nhelpids.pb,
    std_cmd[0], "Stdize_NDev");

  sprintf(str, " Std Menu ");
  width = XTextWidth(appdata.font, str, strlen(str));

  stdview_sbar = XtVaCreateManagedWidget("Scrollbar",
    scrollbarWidgetClass, stdview_panel,
    XtNfromVert, (Widget) stdview_menu_cmd,
    XtNfromHoriz, (Widget) std_cmd[0],
    XtNhorizDistance, (Dimension) 0,
    XtNwidth, (Dimension) width,
    XtNheight, (Dimension) 16,
    XtNorientation, (XtOrientation) XtorientHorizontal,
    NULL);
  if (mono) set_mono(stdview_sbar);
  add_sbar_help(&xg->nhelpids.sbar,
    stdview_sbar, "Stdize_NDev");
/*
 * The value of std_width ranges between .1 and 10.1 and this
 * function treats the length of the scrollbar as 1.0
*/
  XawScrollbarSetThumb(stdview_sbar, .1*(xg->std_width-.1), -1.);

  std_cmd[1] = XtVaCreateWidget("Icon",
    labelWidgetClass, stdview_panel,
    XtNinternalHeight, (Dimension) 0,
    XtNinternalWidth, (Dimension) 0,
    XtNborderColor, (Pixel) appdata.fg,
    XtNfromHoriz, (Widget) stdview_sbar,
    XtNfromVert, (Widget) stdview_menu_cmd,
    XtNhorizDistance, (Dimension) 0,
    XtNbitmap, (Pixmap) rightarr,
    NULL);
  if (mono) set_mono(std_cmd[1]);
  add_pb_help(&xg->nhelpids.pb,
    std_cmd[1], "Stdize_NDev");

  XtManageChildren(std_cmd, 2);
/*
 * label to record multiple of scale parameter around location parameter
*/
  (void) sprintf(lab, "%4.1f", xg->std_width);
  stdview_label = XtVaCreateManagedWidget("StdizeLabel",
    labelWidgetClass,  stdview_panel,
    XtNfromVert, (Widget) stdview_sbar,
    XtNlabel, (String) lab,
    NULL);
  if (mono) set_mono(stdview_label);

  XtAddCallback(stdview_sbar, XtNjumpProc,
    (XtCallbackProc) scale_param_cback, (XtPointer) xg);

  XtAddEventHandler(std_cmd[0], ButtonPressMask, FALSE,
    (XtEventHandler) scale_param_leftarr_cback, (XtPointer) xg);
  XtAddEventHandler(std_cmd[1], ButtonPressMask, FALSE,
    (XtEventHandler) scale_param_rightarr_cback, (XtPointer) xg);
}

void
scaling_on(xg)
  xgobidata *xg;
{
  if (xg->prev_plot_mode == SCALE_MODE && xg->plot_mode != SCALE_MODE)
  {
    /*
     * Remove event handler for button presses in the workspace widget.
    */
    XtRemoveEventHandler(xg->workspace,
      XtAllEvents, TRUE,
      (XtEventHandler) scale_button_event, (XtPointer) xg);
    xg->is_scaling = False;
    map_scaling(xg, False);
    XUndefineCursor(display, XtWindow(xg->workspace));
  }
  else if (xg->prev_plot_mode != SCALE_MODE &&
           xg->plot_mode == SCALE_MODE)
  {
    XDefineCursor(display, XtWindow(xg->workspace), scale_cursor);
    /*
     * Event handler for button presses in the workspace widget.
    */
    XtAddEventHandler(xg->workspace, ButtonPressMask | ButtonReleaseMask,
      FALSE, (XtEventHandler) scale_button_event, (XtPointer) xg);
    xg->is_scaling = 1;
    (void) XtAppAddWorkProc(app_con, RunWorkProcs, (XtPointer) NULL);

    map_scaling(xg, True);
  }
}

