#include "cthugha.h"
#include "sound.h"

#include <stdio.h>
#include <unistd.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <fcntl.h>

char sound_file_name[512];

FILE * sound_file;

int sound_exec_init(void) {
    char txt[512]; int l = 0;
    int d; char s[512];

    if( (sound_file = popen(sound_file_name, "r")) == NULL ) {
	printfee("Can not popen sound program `%s' for reading.", sound_file_name);
	return 1;
    }

    /*
     * program should first write some informational messages 
     * 'CTH start' really starts the sound.
     */
    do {
	fgets(txt, 512, sound_file);
	printfv(10, txt);

	if( sscanf(txt, "CTH speed: %d", &d) == 1) {
	    sound_options->speed = d;
	}
	if( sscanf(txt, "CTH channels: %d", &d) == 1) {
	    sound_options->channels = d;
	}
	if( sscanf(txt, "CTH format: %s", s) == 1) {
	    if(strncasecmp(s, "S16_LE", 6) == 0) {
		sound_options->bps = 16;
	    }
	}
	if(feof(sound_file) || (l++ > 1000)) {
	    printfe("Sound program `%s' has not started properly.\n", sound_file_name);
	    return 1;
	}
    } while( strncmp(txt, "CTH start", 9) != 0);
    printfv(4, "Playing...\n");

    return 0;
}

int sound_exec_read(void) {
    unsigned char sound_buffer[sound_bsize * sound_options->channels * sound_options->bps];

    /* read sound from pipe */
    fread(sound_buffer, sound_options->channels * sound_options->bps * sound_bsize, 1, sound_file);

    /* play the sound */
#if USE_DSP == 1
    if(sound_use[snddev_dsp_w])
	sound_dsp_write(sound_buffer);
#endif

    /* check for end of file */
    if(feof(sound_file)) { 
	printfv(4, "Playing again...\n");
	pclose(sound_file);		/* close pipe and */
	sound_exec_init();		/* start again */
    }
    
    sound_convert(sound_buffer, sound_options->channels, sound_options->bps);
    
    return 0;
}

int sound_exec_update(void) {
    return 0;
}

int sound_exec_exit(void) {
    pclose(sound_file);
#if USE_DSP == 1
    sound_dsp_exit();
#endif
    return 0;
}

