/*
 * $Id: list.h,v 1.5 1996/08/16 10:36:23 too Stab $
 *
 * Author: Tomi Ollila <too@ajk.tele.fi>
 *
 * 	Copyright (c) 1994 TELE/MoDa
 * 	    All rights reserved
 *
 * Created: Fri Jun 17 14:17:17 1994 too
 * Last modified: Fri Aug 16 13:35:55 1996 too
 *
 * HISTORY
 * $Log: list.h,v $
 * Revision 1.5  1996/08/16 10:36:23  too
 * Removed list argument cast to (struct List *) in Scan_List_BEGIN() macro.
 *
 * Revision 1.4  1996/07/11 15:20:41  too
 * Added declarations of insNode[SP]
 *
 * Revision 1.3  1996/06/04 11:43:36  too
 * modified
 *
 * Revision 1.2  1994/09/26  08:34:48  too
 * Added Scan_List -macros.
 *
 * Revision 1.1  1994/08/20  16:24:30  too
 * Initial revision
 *
 */

#ifndef LIST_H
#define LIST_H

#ifndef NULL
#define NULL 0
#endif

typedef struct Node {
  struct Node * ln_Succ;
  struct Node * ln_Pred;
} Node;

typedef struct List {
  struct Node * lh_Head;
  struct Node * lh_Tail;
  struct Node * lh_TailPred;
} List;

#define emptyList(list) ((list)->lh_TailPred == (struct Node *)(list))

#ifndef USE_INLINE_FUNCTIONS

void newList(struct List * list);
void swapLists(struct List * list1, struct List * list2);
void remNode(struct Node * node);
void insNodeP(struct Node * node, struct Node * new);
void insNodeS(struct Node * node, struct Node * new);
void addHead(struct List * list, struct Node * node);
void addTail(struct List * list, struct Node * node);
struct Node * remHead(struct List * list);
struct Node * remTail(struct List * list);
struct Node * remHeadQ(struct List * list);
struct Node * remTailQ(struct List * list);

#else

INLINE void
newList(struct List * list)
{
  list->lh_Head = (struct Node *)&list->lh_Tail;
  list->lh_Tail = NULL;
  list->lh_TailPred = (struct Node *)&list->lh_Head;
}

INLINE void
swapLists(struct List * list1, struct List * list2)
{
  struct List tmplist = *list1;

  if (emptyList(list2))
    newList(list1);
  else
    *list1 = *list2;

  if (emptyList(&tmplist))
    newList(list2);
  else
    *list2 = tmplist;
}

  
INLINE void
remNode(register struct Node * node)
{
  register struct Node *node2;

  node2 = node->ln_Succ;
  node = node->ln_Pred;
  node->ln_Succ = node2;
  node2->ln_Pred = node;
}

INLINE void
addTail(struct List * list, struct Node * node)
{
  list->lh_TailPred->ln_Succ = node;
  node->ln_Pred = list->lh_TailPred;
  node->ln_Succ = (struct Node *)&list->lh_Tail;
  list->lh_TailPred = node;
}

INLINE void
addHead(struct List * list, struct Node * node)
{
  list->lh_Head->ln_Pred = node;
  node->ln_Succ = list->lh_Head;
  node->ln_Pred = (struct Node *)&list->lh_Head;
  list->lh_Head = node;
}

INLINE struct Node *
remHead(struct List * list)
{
  struct Node * node = list->lh_Head;
  if (node->ln_Succ == NULL)
    return NULL;

  list->lh_Head = node->ln_Succ;
  node->ln_Succ->ln_Pred = (struct Node *)&list->lh_Head;

  return node;
}
    
INLINE struct Node *
remTail(struct List * list)
{
  struct Node * node = list->lh_TailPred;
  if (node == (struct Node *)list)
    return NULL;
  
  list->lh_TailPred = node->ln_Pred;
  node->ln_Pred->ln_Succ = (struct Node *)&list->lh_TailPred;

  return node;
}

INLINE struct Node *
remHeadQ(struct List * list)
{
  struct Node * node = list->lh_Head;
  
  list->lh_Head = node->ln_Succ;
  node->ln_Succ->ln_Pred = (struct Node *)&list->lh_Head;

  return node;
}
    
INLINE struct Node *
remTailQ(struct List * list)
{
  struct Node * node = list->lh_TailPred;

  list->lh_TailPred = node->ln_Pred;
  node->ln_Pred->ln_Succ = (struct Node *)&list->lh_TailPred;

  return node;
}

#endif /* USE_INLINE_FUNCTIONS */

/*
 * Last Modified: Mon Sep 12 03:07:20 1994 too
 *
 * New and greatly improved list scanning macros. flags is interpreted as
 * follows:
 * 0: scan forward, do not cache next node.
 * 1: scan backward, do not cache previous node.
 * 2: scan forward, cache next node.
 * 3: scan backward, cache previous node.
 *
 * Note: nXt is dead code if no nodes are cached and is/should be
 *	 removed by the compiler (At least gcc 2.5.7 does this).
 *
 * Use these macros in your programs as you are using do - while keywords
 * i.e. if you have only one statement between Scan_List_begin and
 * Scan_List_End, you don't have to use `{' and `}' but otherwise enclose
 * statents between those. These macros also behave well in emacs c-mode.
 * break and continue work as in block of a `for' -statement.
 */

#ifndef TRACE
#define TRACE(x, y)
#endif

#ifndef TRCF_SCANLIST
#define TRCF_SCANLIST 0
#endif

#define Scan_List_BEGIN(list, type, node, flags) do { \
   type node; \
   struct Node * nXt; \
   TRACE(TRCF_SCANLIST, ("Scanning list %s\n", #list)); \
   for (node = flags & 1? (type)(list)->lh_TailPred: \
			  (type)(list)->lh_Head; \
	(nXt = flags & 1? ((struct Node *)node)->ln_Pred:  \
			  ((struct Node *)node)->ln_Succ) != NULL; \
	node = flags & 2? (type)nXt: \
			  flags & 1? (type)((struct Node *)node)->ln_Pred: \
				     (type)((struct Node *)node)->ln_Succ)

#define Scan_List_END } while (0)

#if 0

struct NameNode {
  struct Node node;
  char * lnn_Name;
};

start()
{
  struct List * foo;

  Scan_List_BEGIN(foo, struct NameNode *, node, 3)
    node->lnn_Name = "foo";
  Scan_List_END;
}

#endif

#endif /* LIST_H */

