#ifndef __SOUND_H_
#define __SOUND_H_

#ifdef __SOUND_C_
#define EXTERN
#else
#define EXTERN extern
#endif

/* audio related stuff */
#define AUDIO_SAMPLE_FREQ	(22050) /* used by solaris.c */
#define AUDIO_SAMPLE_LOWFREQ	(8000) /* used by solaris.c */
#define AUDIO_SAMPLE_BITS	(8) 
#define AUDIO_BUFSIZE_BITS	(8)
#define AUDIO_NUM_VOICES	(16)

/* ideally should be set to some whole divider of the system timer,
   since the system timer of most unix systems has a freq of 100 we use 50 */
#ifndef AUDIO_TIMER_FREQ
#define AUDIO_TIMER_FREQ	(50)
#endif

#define NUM_FRAGS	5
#define LOG_2_FRAG	10	/* Fragment size of 1024 (log base 2 of 
				   1024 is 10), increase to 11 if sound 
				   clicks a lot. Also note that this 
				   assumes that the frame rate will be
				   at least 44 frames per second on
				   average.  If the actual frame rate
				   is lower, you will want to make this
				   number larger */
#define FRAG_SIZE  (1<<(LOG_2_FRAG))

#define AUDIO_BUFF_SIZE ((NUM_FRAGS)*(FRAG_SIZE))

#if ( defined linux || defined sgi ) && defined USE_TIMER
#warning "You'll get better sound by disable of USE_TIMER makefile.unix feature"
/* #undef USE_TIMER */
#endif

typedef struct sample_t
{
	int loop_stream;
	float vol;
	float freq_fac;
	unsigned char *end_data_pt;
	unsigned char *data;
	struct sample_t *next_sample;
}SAMPLE_T;

typedef struct voice_t
{
	unsigned char *current_data_pt;
	float pos_frac;
	SAMPLE_T *sample;
}VOICE_T;

EXTERN	int	   	audio_fd;

EXTERN	int	   	audio_sample_freq; 
EXTERN	int	   	audio_timer_freq; 

#undef EXTERN
#endif
