/*
 * Linux Dependent system file 
*/

#ifdef linux

#define __LINUX_C

#include <sys/time.h>
#include <unistd.h>
#include <math.h>
#include "xmame.h"
#include "sound.h"
#include "lin2ulaw.h"

#ifdef USE_JOYSTICK
#include <linux/joystick.h>
struct 	 JS_DATA_TYPE joy_data,joy_orig;
int	 joy_fd; /* joystick file descriptor */
#endif

#define USE_AUDIO 0
#define USE_DSP   1

static int linux_sound_device;
/*
 * Put anything here you need to do when the program is started.
 * Return 0 if initialization was successful, nonzero otherwise.
 */

int sysdep_init ()
{
	int result;
	/**********  initialize joystick device */
#ifdef USE_JOYSTICK
#ifdef I386_JOYSTICK
    	if (use_joystick) {
		printf ("Linux Joystick interface initialization...\n");
		if ((joy_fd = open ("/dev/js0", O_RDONLY | O_NONBLOCK)) < 0) {
		  printf ("Couldn't open joystick device /dev/js0 \n");
		  printf ("Be sure to joystick module is instaled\n");
		  use_joystick = FALSE;
		}
	else if ( read(joy_fd,&joy_orig,sizeof(struct JS_DATA_TYPE)) < 0) {
	  	 printf ("Cannot read joystic device.sorry\n");
	 	 exit(1);
		}
		/* mask x e y pos to skip "flickering" */
		if (! swapjoyaxis) {
		    joy_orig.x >>=joyfilter;
		    joy_orig.y >>=joyfilter;
		} else {
		    int a = (joy_orig.y >> joyfilter);
		    joy_orig.y = (joy_orig.x >> joyfilter);
		    joy_orig.x = a;
		}

    	}
#endif
#endif
	/********* * initialize sound */
    	if (play_sound) {
	    int linux_sound_init(void);
	    int linux_audio_init(void);
	    linux_sound_device=USE_DSP;
	    result = -1;
	    if ( !strcmp(audiodevice,"/dev/dsp") ) result=linux_sound_init();
	    if ( !strcmp(audiodevice,"/dev/audio") ) result=linux_audio_init();
	    if(result<0) fprintf(stderr,"Sound device init failed. Sound disabled\n");	
	}
	return (TRUE);
}


/* put here anything you need to do when the program is started. Return 0 if */
/* initialization was successful, nonzero otherwise. */
int linux_sound_init(void) {
	int format = AFMT_U8;	
	int stereo = 0;
	int frag = LOG_2_FRAG + (NUM_FRAGS << 16);
	fprintf(stderr,"Linux Sound Driver initialization... \n");
	if((audio_fd = open(audiodevice,O_WRONLY,0)) < 0) {
		perror("/dev/dsp");
		play_sound = 0;
		return -1;
	} 
	if (ioctl(audio_fd,SNDCTL_DSP_SETFMT,&format) < 0) {
		perror("SNDCTL_DSP_SETFMT");
		play_sound = 0;
	} 
	if (ioctl(audio_fd,SNDCTL_DSP_STEREO,&stereo) < 0) {
                perror("SNDCTL_DSP_STEREO");
                play_sound = 0;
        } 
	if (ioctl(audio_fd,SNDCTL_DSP_SPEED,&audio_sample_freq) < 0) {
                perror("SNDCTL_DSP_SPEED");
                play_sound = 0;
        } 
	if (ioctl(audio_fd,SNDCTL_DSP_SETFRAGMENT,&frag) < 0) {
                perror("SNDCTL_DSP_SETFRAGMENT");
                play_sound = 0;
	}

	if(play_sound == 0) { close(audio_fd); return (-1); }

       linux_sound_device=USE_DSP;
	fprintf(stderr,"Audio device %s set to 8bit linear mono %dHz\n",
		audiodevice,audio_sample_freq);
        return 0;   
}

/* 
 * Support /dev/audio  8000 Hz, 8bit, mono, uLaw 
 * Thanks to Osamu Kurati for their patch to allow selection of /dev/audio
 * as audio device
 */
int linux_audio_init(void) {
       static char *comment = "XMAME";
       unsigned long hdr_size, data_size;
       unsigned long encoding, sample_rate, channels;

       fprintf(stderr,"Linux Sound Driver /dev/audio initialization... \n");

       if((audio_fd = open("/dev/audio",O_WRONLY,0)) < 0) {
               perror("/dev/audio");
               play_sound = 0;
               return -1;
       } 
       /***** Sun Magic *****/
       (void) write(audio_fd,".snd",4); 

       /* header size */
       hdr_size = 24 + strlen(comment); /***** 24 is generic header size *****/
       (void) write(audio_fd,&hdr_size,4);

       /* data size */
       data_size = ((unsigned long)(~0)); /***** unknown data size *****/
       (void) write(audio_fd,&data_size,4);

       encoding = 1; /***** linear uLaw *****/
       (void) write(audio_fd,&encoding,4);

       /* * set sampling rate */
       sample_rate = audio_sample_freq;
       (void) write(audio_fd,&sample_rate,4);

        /*
         * set channels
         */
       channels = 1; /***** monoral *****/
       (void) write(audio_fd,&channels,4);
       
       linux_sound_device=USE_AUDIO;
       fprintf(stderr,"Audio device %s set to 8bit uLaw mono %dHz\n",
	       audiodevice, audio_sample_freq);
       return 0;   
}
  
/*
 * Cleanup routines to be executed when the program is terminated.
 */

void sysdep_exit (void) {
	if (play_sound)	{
                int n;
                /* stop and release voices */
                for (n = 0; n < AUDIO_NUM_VOICES; n++) osd_stop_sample(n);
		close(audio_fd);
        }
#ifdef USE_JOYSTICK
  	if (use_joystick)	close (joy_fd);
#endif
}

#define abs(x) ( ( (x) >= 0 )? (x) : -(x) )
/* inline int abs(int x) {if (x>=0) return (x); return -(x); } */

long sysdep_get_audio_freespace() {
       audio_buf_info info;
       int i;
       static struct timeval tv1,tv2;
       struct timezone tz2;
       int run_n;
       double elapsed,num;

       switch (linux_sound_device) {
        case USE_DSP:
           i=ioctl(audio_fd,SNDCTL_DSP_GETOSPACE,&info);
           if (i<0) { perror("SNDCTL_DSP_GETOSPACE"); return -1; }
           return (long)(info.bytes);
	   break;
        case USE_AUDIO:
           gettimeofday(&tv2,&tz2);
           elapsed = (tv2.tv_sec - tv1.tv_sec) +
			 (tv2.tv_usec - tv1.tv_usec) * 1.0e-6;
           num = elapsed *  audio_sample_freq;
           run_n = num;
           if (run_n < 0 || run_n > AUDIO_BUFF_SIZE) run_n = 0;
           tv1 = tv2;
           return(run_n);
	   break;
       }
       return 0; /* should not occurs */
}

int 
sysdep_play_audio (byte * buf, int bufsize)
{
   unsigned char *p;
   char *q;
   int i;
   switch (linux_sound_device) {
    case USE_DSP:
	return write(audio_fd,buf,bufsize);
	break;
    case USE_AUDIO:
       p = buf;
       q = (char *) buf;
       for(i=0; i<bufsize; i++){
         *q++ = (char) linearToUlaw[(u16) (*p^0x80)<<8];
         p++;
       }
       return write(audio_fd,buf, bufsize);
       break;
   }
   return 0; /* should never occur */
}

#endif
/****** end of Linux dependent code; DO NOT WRITE BELOW THIS LINE *********/
