/*
** Copyright (c) Massachusetts Institute of Technology 1994-1997.
**          All Rights Reserved.
**          Unpublished rights reserved under the copyright laws of
**          the United States.
**
** THIS MATERIAL IS PROVIDED AS IS, WITH ABSOLUTELY NO WARRANTY EXPRESSED
** OR IMPLIED.  ANY USE IS AT YOUR OWN RISK.
**
** This code is distributed freely and may be used freely under the 
** following conditions:
**
**     1. This notice may not be removed or altered.
**
**     2. Works derived from this code are not distributed for
**        commercial gain without explicit permission from MIT 
**        (for permission contact lclint-request@larch.lcs.mit.edu).
*/
/*
** interfaceNodeList.c
**
** based on list_template.c
**
** where T has T_equal (or change this) and T_unparse
*/

# include "lclintMacros.nf"
# include "llbasic.h"

/*@only@*/ interfaceNodeList
interfaceNodeList_new ()
{
  interfaceNodeList s = (interfaceNodeList) dmalloc (sizeof (*s));

  s->nelements = 0;
  s->nspacelow = interfaceNodeListGROWLOW;
  s->nspacehigh = interfaceNodeListGROWHI;
  s->elementsroot = (interfaceNode *) dmalloc (sizeof (*s->elements)
					       * interfaceNodeListBASESIZE);
  s->elements = s->elementsroot + interfaceNodeListGROWLOW;

  return (s);
}

static void
interfaceNodeList_grow (interfaceNodeList s)
{
  int i;
  interfaceNode *newelements; 
  
  newelements = (interfaceNode *) dmalloc 
    (sizeof (*newelements) * (s->nelements + interfaceNodeListBASESIZE));

  for (i = 0; i < s->nelements; i++)
    {
      newelements[i + interfaceNodeListGROWLOW] = s->elements[i];
    }
  
  s->nspacelow = interfaceNodeListGROWLOW;
  s->nspacehigh = interfaceNodeListGROWHI; 
  
  sfree (s->elementsroot);  
  s->elementsroot = newelements;

  s->elements = newelements + s->nspacelow;
}

interfaceNodeList
interfaceNodeList_addh (interfaceNodeList s, interfaceNode el)
{
  llassert (interfaceNodeListGROWHI > 0);

  if (s->nspacehigh <= 0)
    interfaceNodeList_grow (s);

  s->nspacehigh--;
  s->elements[s->nelements] = el;
  s->nelements++;

  return s;
}

void 
interfaceNodeList_addl (interfaceNodeList s, /*@keep@*/ interfaceNode el)
{
  llassert (interfaceNodeListGROWLOW > 0);

  if (s->nspacelow <= 0)
    interfaceNodeList_grow (s);

  s->nspacelow--;
  s->elements--;
  s->elements[0] = el;
  s->nelements++;
}

void
interfaceNodeList_free (interfaceNodeList s)
{
  int i;

  for (i = 0; i < s->nelements; i++)
    {
      interfaceNode_free (s->elements[i]);
    }

  sfree (s->elementsroot);
  sfree (s);
}
