/*
** Copyright (c) Massachusetts Institute of Technology 1994-1997.
**          All Rights Reserved.
**          Unpublished rights reserved under the copyright laws of
**          the United States.
**
** THIS MATERIAL IS PROVIDED AS IS, WITH ABSOLUTELY NO WARRANTY EXPRESSED
** OR IMPLIED.  ANY USE IS AT YOUR OWN RISK.
**
** This code is distributed freely and may be used freely under the 
** following conditions:
**
**     1. This notice may not be removed or altered.
**
**     2. Works derived from this code are not distributed for
**        commercial gain without explicit permission from MIT 
**        (for permission contact lclint-request@larch.lcs.mit.edu).
*/
# ifndef IMPORTNODELIST_H
# define IMPORTNODELIST_H

typedef /*@only@*/ importNode o_importNode;

abst_typedef struct _importNodeList
{
  int nelements;
  int nspace;
  /*@reldef@*/ /*@relnull@*/ o_importNode *elements;
} *importNodeList ;

/*@iter importNodeList_elements (sef importNodeList x, yield exposed importNode el); @*/
# define importNodeList_elements(x, m_el) \
   { int m_ind; importNode *m_elements = &((x)->elements[0]); \
       for (m_ind = 0 ; m_ind < (x)->nelements; m_ind++) \
	 { importNode m_el = *(m_elements++);

# define end_importNodeList_elements }}

extern /*@only@*/ importNodeList importNodeList_new (void);
extern importNodeList 
  importNodeList_add (/*@returned@*/ importNodeList p_s, /*@only@*/ importNode p_el) ;

extern /*@only@*/ cstring importNodeList_unparse (importNodeList p_s) ;
extern void importNodeList_free (/*@only@*/ importNodeList p_s) ;

/*@constant int importNodeListBASESIZE;@*/
# define importNodeListBASESIZE SMALLBASESIZE

# else
# error "Multiple include"
# endif




