package biss.jde;

import biss.FileLib;
import biss.awt.LeveledObject;
import biss.awt.Leveler;
import java.io.File;
import java.util.Enumeration;
import java.util.Observable;
import java.util.Observer;
import java.util.Vector;

/**
 * logical view to browse through the code structure of a single method
 *
 * (C) 1996,97 BISS GmbH Germany, see file 'LICENSE.BISS-AWT' for details
 * @author P.C.Mehlitz
 */
public class MethodBrowser
  implements Observer, Leveler
{
	MethodViewer View = new MethodViewer();
	FoldedStmt Mthd;
	FoldedStmt SelStmt;
	CompileOutputDlg OutputDlg;

public MethodBrowser ( String mthdSource ) {
	registerObserver();

	parseMethod( mthdSource);
}

public Vector getLeveledList ( Object foldedStmt ) {
	Vector list = new Vector(50);

	traverseStmt( (FoldedStmt)foldedStmt, 0, list);

	return list;
}

public static void main ( String[] args ) {
	String src = FileLib.getFileDataAsString( new File(args[0]) );
	MethodBrowser b = new MethodBrowser( src);
}

void parseMethod ( String mthdSrc ) {
	MthdParser p = new MthdParser( mthdSrc);
	p.storeOutput();

	try {
		Mthd = p.parseMethod();
		updatePanes();
	}
	catch ( ParseException x ) {
		p.reportException( x);
		showCompileOutput( p.getOutBuffer().toString());
	}	
}

void registerObserver () {
	View.StmtPane.OsDrawObject.addObserver( this);
	View.StmtPane.OsSelection.addObserver( this);
}

void selectStmt ( FoldedStmt stmt ) {
	SelStmt = stmt;
	if ( SelStmt != null )
		View.TxtPane.setContents( stmt.Prolog);
	else
		View.TxtPane.setContents( null);
}

void showCompileOutput ( String txt ) {
	if ( OutputDlg == null )
		OutputDlg = new CompileOutputDlg( this); 

	OutputDlg.setTitle( "Method Analyze Output");
	OutputDlg.setContents( txt);
}

void traverseStmt( FoldedStmt stmt, int level, Vector list) {
	LeveledObject.add( list, stmt, level);

	if ( stmt.SubStmts != null ) {
		for ( Enumeration e=stmt.SubStmts.elements(); e.hasMoreElements(); )
			traverseStmt( (FoldedStmt)e.nextElement(), level+1, list);
	}
}

public void update ( Observable obs, Object arg ) {
	if ( obs == View.StmtPane.OsDrawObject ) {
		FoldedStmt stmt = (FoldedStmt) View.StmtPane.DrawObject;
		if ( (stmt.Name != null) && (stmt.Paren != null) )
			DrawSupport.drawFoldedStmt( View.StmtPane,
		                            stmt.Name, stmt.Paren, stmt.PrologLabel);
	}
	else if ( obs == View.StmtPane.OsSelection ){
		LeveledObject lo = (LeveledObject) arg;
		if ( lo != null)
			selectStmt( (FoldedStmt)lo.getObject());
		else
			selectStmt( null);
	}
}

void updatePanes () {

	if ( Mthd == null ) {
		View.StmtPane.setContents( null, this);
		return;
	}

	View.StmtPane.setContents( Mthd, this);
}
}
