package biss.jde;

import biss.CLPrintStream;
import biss.StringLib;
import biss.VectorSorter;
import biss.awt.List;
import biss.awt.SelfDrawingObject;
import java.io.ByteArrayOutputStream;
import java.io.PrintStream;
import java.util.BitSet;
import java.util.Vector;

/**
 * model class describing a java method
 *
 * (C) 1996,97 BISS GmbH Germany, see file 'LICENSE.BISS-AWT' for details
 * @author P.C.Mehlitz
 */
class Method
  extends FieldDecl
  implements SelfDrawingObject, Mod
{
	static MethodSorter Sorter = new MethodSorter();
	public static BitSet PossibleMods;
	String Name;
	String Parms;
	Vector Exceptions;
	String Body;

static {
	PossibleMods = new BitSet( NMods);
	PossibleMods.set( PUBLIC);
	PossibleMods.set( PROTECTED);
	PossibleMods.set( PRIVATE);
	PossibleMods.set( STATIC);
	PossibleMods.set( FINAL);
	PossibleMods.set( ABSTRACT);
	PossibleMods.set( NATIVE);
	PossibleMods.set( SYNCHRONIZED);
}

public Method ( BitSet mods, String resType, String name ) {
	Mods = mods;
	Type = resType;
	Name = name;
}

static String allDefinitions ( Vector list, boolean withCmt, boolean withMods ) {
	int n, i, len;

	if ( list == null || (n = list.size()) == 0 ) return null;
	for ( i=0, len=0; i<n; i++ )
		len += ((Method)list.elementAt(i)).Body.length() + 20;
	ByteArrayOutputStream o = new ByteArrayOutputStream( len);
	PrintStream s = new PrintStream( o);

	for ( i=0;;) {
		((Method) list.elementAt(i++)).printOn( s, withCmt, withMods);
		if ( i == n ) break;
		s.println();
	}

	return o.toString();
}

public String definition () {
	return Body;
}

public void 	drawSelfIn ( Object pane ){
	DrawSupport.drawMethod( (List) pane, Type, Name, Parms, Mods);
}

public boolean equals ( Object other ) {
	Method mth = (Method) other;
	return (mth != null) && (Id.equals( mth.Id));
}

public void format ( MethodFormatter mf ) {
	String newBody;

	if ( Body != null && Body.length() > 0 ) {
		MethodFormatter form = (mf != null) ? mf : new MethodFormatter();

		newBody = form.format( Body);
		Body = newBody;
	}
}

public static String getTemplate () { 
	return "<type> <name> () {\n\n}";
}

public boolean isPropperlyIndented () {
	int i = Body.length() - 1;
	char c = Body.charAt( i);

	if ( c == '}' ) {
		c = Body.charAt( i-1);
		if ( c != '\n' )
			return false;
	}

	return true;
}

public int  	maxDrawWidth(){
	return DrawSupport.Cx * 120;
}

boolean mergeWith ( Method other ) {
	if ( !Id.equals( other.Id ) )
		return false;

	Type = other.Type;
	if ( other.hasMods() )
		Mods = other.Mods;

	Body = other.Body;
	if ( Comment == null || other.Comment != null )
		Comment = other.Comment;
	Parms = other.Parms;
	Exceptions = other.Exceptions;

	return true;
}

public void printOn ( PrintStream s, boolean withCmt, boolean withMods ) {
	if ( s instanceof CLPrintStream )
		Line = ((CLPrintStream)s).Line;

	if ( withCmt ) printCommentOn( s);
	if ( withMods ) printModsOn( s);
	s.println( Body);
}

public void setBody ( String body ) {
	Body = body;
}

public void setExceptions ( Vector exceptions ) {
	Exceptions = exceptions;
}

public void setParms ( String parms ) {
	Parms = parms;
}

public void setSignature ( String sig ) {
	Id = Name + sig;
}

static Method staticInit ( String body ) {
	BitSet mods = new BitSet( NMods);
	mods.set( STATIC);

	Method mth = new Method ( mods, "", "<clinit>");
	mth.setBody( body);
	mth.Id = mth.Name;
	mth.Parms = "";
	return mth;
}

public boolean usesData ( String id ) {
	return (Body != null && StringLib.indexOfId( Body, id) >= 0);
}
}

class MethodSorter
  implements VectorSorter
{

public int compare ( Object a, Object b ) {
	return ((Method)a).Id.compareTo( ((Method)b).Id);
}
}
