package biss.awt;

import java.applet.Applet;
import java.applet.AppletContext;
import java.applet.AppletStub;
import java.applet.AudioClip;
import java.awt.Image;
import java.net.URL;
import java.util.Enumeration;
import java.util.Vector;

/**
 * very crude and preliminary class to test the java.awt.peer role of
 * biss.awt classes. Has to be called like:
 *          java biss.awt.AppletViewer <AppletClass>
 * (i.e. with the class name instead of the html file). It does not
 * provide any parameter mechanism yet.
 * Will be extended towards standard 'appletviewer' compatibility
 *
 * (C) 1996,97 BISS GmbH Germany, see file 'LICENSE.BISS-AWT' for details
 * @author J.H.Mehlitz
 */
public class AppletViewer
  extends TopWindow
  implements AppletStub, AppletContext
{
	Applet App;
	Vector Apps = new Vector();
	String AppCls;
	URL Base;

public AppletViewer ( String aClass) {
	super( "AppletViewer: " + aClass);
	try {
		AppCls = aClass;
		Class c = Class.forName( aClass);
		App = (Applet) c.newInstance();
		App.setStub( this);
		Apps.addElement( App);
		add( "Center", App);
		openIn( 100, 100, 300, 300);
		init();
	}
	catch( Throwable t) {
		System.out.println( t);
	}
}

public void appletResize ( int width, int height) {
	System.out.println( "appletResize");
}

public Applet getApplet ( String name) {
	return App;
}

public AppletContext getAppletContext () {
	return this;
}

public Enumeration getApplets () {
	return Apps.elements();
}

public AudioClip getAudioClip ( URL url) {
	return null;
}

public URL getCodeBase () {
	return Base;
}

public URL getDocumentBase () {
	return Base;
}

public Image getImage ( URL url) {
	return Awt.DefToolkit.getImage( url );
}

public String getParameter ( String name) {
	// System.out.println( name);
	return null;
}

void init(){
	try {
		String curDir = System.getProperty( "user.dir");
		Base = new URL( "file", "localhost", curDir + "/" );
		App.init();
		App.start();
	}
	catch( Throwable t) {}
}

public boolean isActive () {
	return true;
}

public static void main ( String[] args) {
	if ( args.length == 0)
		System.out.println( "usage: AppletViewer <AppletClassName>");
	else
		new AppletViewer( args[0]);
}

public void showDocument ( URL url) {
}

public void showDocument ( URL url, String target) {
}

public void showStatus ( String status) {
}
}
