/*
	Copyright (C) 1994	Edward Der-Hua Liu, Hsin-Chu, Taiwan
*/

#include <stdio.h>
#include "xi.h"
#include <sys/types.h>
#include <X11/keysym.h>

int *idx; /* sorted index pointing to the phrase */ 
static u_char *ph;	/* key string, phrase string  : C style */
static u_short kmap[128]; /* hash,  point to idx array  */
			  /* 0xffff if the key is undefined */
			  /* 65535 phrases can be defined */
extern char *tabfname[];
extern void ClrShowArea( int x );
extern void change_window_name(char *str);

static int phn=0,tttest=0;
static int s_h,e_h,ic;
char *ss,*tt,vv[512];
static int press_spc=0;

static u_char inch[40];
static int cin;
static int pg_idx,vvv_idx,vvvv_idx,mic;
extern void gotoxy(int x, int y);
int v=0;

void ClrInArea()
{       int i;
        gotoxy(InAreaX,MROW-1);
        for(i=0;i<cin+1;i++)
                xprintf("         ");
        mic=cin=0;
        press_spc=tttest=0;
} 

static int qcmp_voc(a, b)
 int *a, *b;
{
return strcmp(&ph[*a],&ph[*b]);
}

extern void *malloc(size_t size);
extern void *realloc(void *ptr, size_t size);
extern void SORTFUNC(void *base, size_t nmemb, size_t size,
              int (*compar)(const void *, const void *));
extern void bzero(void *s, int n);

char InitVocBox(int usenow)
{
FILE *fp;
char tt[1024];
int i,j;
int mfree;
int phsize;
int len;
char *p,*q;
static char count = 0;
char *vocbox_fname=tabfname[11];


if (ph) {
	ClrInArea();
        gotoxy(0,MROW-1);
        xprintf(" iwj");
	change_window_name("VocBox");
        return 1;
}

if ((fp=fopen(vocbox_fname,"r"))==NULL&&!count) {
	printf("[5mERROR![0m vocbox: Cannot open voxbox file %s\n\n",
	   vocbox_fname);
	count = 1;
	return -1;
} else if ( count == 1 )
	return -1;

ClrInArea();


while (!feof(fp)) {
	fgets(tt,sizeof(tt),fp);
	phn++;
}
phn++;

if (!(idx=(int *)malloc(phn*sizeof(u_char *)))) {
	error("phrase.c: malloc error");
	return -1;
}

if (!(ph=(u_char *)malloc(phsize=1024))) {
	error("phrase.c: malloc error");
	return -1;
}
mfree=phn=0;
fseek(fp,0,0);
while (!feof(fp)) {
  fgets(tt,sizeof(tt),fp);
  p=tt;
  len=strlen(tt);
  if (len && tt[len-1]=='\n') tt[len-1]=0;
  if (tt[0]=='#') continue;
  while (*p==9||*p==' ') p++;
  if (!*p) continue;
  q=p;
  while (*q!=9 && *q!=' ' && *q) q++;
  if (!*q) continue;
  len=q-p+1;  /* must include \000 */
  if (len >=phsize-mfree) {
	phsize+=1024;
	if ((ph=(char *)realloc(ph,phsize))==NULL) {
		error("phrase.c: realloc err");
		return -1;
	}
  }
  *(q++)=0;
  strcpy(&ph[mfree],p);
  idx[phn++]=mfree;
  mfree+=len;
  while (*q==9||*q==' ') q++;
  if (*q=='\n') *q=0;
  len=strlen(q);
  if (*q && *(q+len-1)==13) { 
	len--; *(q+len)=0;
  }
  if (len >=phsize-mfree) {
	phsize+=1024;
	if ((ph=(char *)realloc(ph,phsize))==NULL) {
		error("phrase.c: realloc err");
		return -1;
	}
  }
  strcpy(&ph[mfree],q);
  mfree+=len+1;
}

SORTFUNC(idx,phn,sizeof(idx[0]),qcmp_voc);

fclose(fp);
{
char d[128];
bzero(d,sizeof(d));
for(i=0;i<128;i++)kmap[i]=0xffff;
for(i=0;i<phn;i++) {		
	j=ph[idx[i]];
#if	0
	printf("%s  %s\n",&ph[idx[i]],&ph[idx[i]]+strlen(&ph[idx[i]])+1);
#endif	0
	if (!d[j]) {
		kmap[j]=i;
		d[j]=1;
	}

}
kmap[127]=phn;
for(i=126;i>=0;i--) if (kmap[i]==0xffff) kmap[i]=kmap[i+1];

}

printf("xcin:  vocbox: file path is    %s\n\n", vocbox_fname);

if (usenow) {

gotoxy(0,MROW-1);
xprintf(" iwj");
ClrShowArea( 1 );
}
return 1;
} /* InitPhrase */


void DispInputArea()
{
int f,i;
extern char fullchar[];
gotoxy(InAreaX,MROW-1);
for(i=0;i<cin;i++) {
  f=(int)(inch[i]-' ')<<1;
  xprintf("%c%c",fullchar[f],fullchar[f+1]);
}
xprintf("  ");

}

extern void putstr(u_char *s);
extern void ClrSelArea();
extern void bell();

int feedkey_vocbox(int key)
{
int i/*,j*/;
extern int cursor_x;

switch (key) {
	case XK_Escape:
		if (cin) {
			ClrSelArea();
			ClrInArea();
			return 1;
		} else return 0;
  case XK_BackSpace:
#if     DELETE_K
  case XK_Delete:
#endif
		tttest=0;
		mic=0;
		ClrSelArea();
		if (cin>0) { 
			cin--; 
			break; 
		}
		else return 0;
	case '<':
		if (vvv_idx==pg_idx||!press_spc) return 1;
                ClrSelArea();
                xprintf(" ");
                i=vvv_idx-9;
                ic=0;
                while(i<e_h&&cursor_x<40 && ic<9 &&
                !strcmp(ss=&ph[idx[i]],inch)) {
                        tt=ss+strlen(ss)+1;
                        strcpy(vv,tt);
                        vv[6]=0;
                        i++;
                        ic++;
                        xprintf("%d%s ",ic,vv);
                }
                vvvv_idx=i;
                mic=ic;
                vvv_idx=vvvv_idx-((vvvv_idx-pg_idx)%9 ?
                                 (vvvv_idx-pg_idx)%9:9);
		if ( !strcmp(&ph[idx[vvv_idx-1]],inch)) {
			if (!strcmp(&ph[idx[vvvv_idx]],inch)) {
				gotoxy(40,0);
				xprintf("<\\>");
			}
			else {
				gotoxy(41,0);
				xprintf("<");
			}
		}
		else if (!strcmp(&ph[idx[vvvv_idx]],inch)) {
			gotoxy(41,0);
			xprintf(">");
		}
		return 1;
	case '>':
		if(!press_spc) return 1;
		if (ic<9) {v=1;vvvv_idx=pg_idx;}
		ClrSelArea();
		xprintf(" ");
		i=vvvv_idx;
		ic=0;
		while(i<e_h&&cursor_x<40 && ic<9 &&
		!strcmp(ss=&ph[idx[i]],inch)) {
			tt=ss+strlen(ss)+1;
			strcpy(vv,tt);
			vv[6]=0;
			i++;
			ic++;
			xprintf("%d%s ",ic,vv);
		}

		vvvv_idx=i;
		mic=ic;
		vvv_idx=vvvv_idx-((vvvv_idx-pg_idx)%9 ?
				 (vvvv_idx-pg_idx)%9:9);
                if ( !strcmp(&ph[idx[vvv_idx-1]],inch)) {
                        if (!strcmp(&ph[idx[vvvv_idx]],inch)) {
				gotoxy(40,0);
                                xprintf("<\\>");
			}
                        else {
				gotoxy(41,0);
                                xprintf("<");
			}
                }
		else if (!strcmp(&ph[idx[vvvv_idx]],inch)) {
			gotoxy(41,0);
			xprintf(">");
		}

		if (v) { v=0;vvv_idx=pg_idx;}
		return 1;
	case ' ':
		if ( tttest ) {
			putstr(&ph[idx[vvv_idx]]+
                                strlen(&ph[idx[vvv_idx]])+1);
			ClrSelArea();
			ClrInArea();
			return 1;
		}
		if (cin>0) {
			pg_idx=0;
			inch[cin]=0;
			s_h=kmap[inch[0]];
			e_h=kmap[inch[0]+1];
			for(i=s_h;i<e_h;i++)
			if (!strcmp(&ph[idx[i]],inch))
				break;
			if (i==e_h) {
				bell();
				return 1;
			}
			if (i==phn-1 || strcmp(&ph[idx[i+1]],inch)) {
				putstr(&ph[idx[i]]+strlen(&ph[idx[i]])+1);
				ClrInArea();
				cin=0;
				return 1;
			}
			ic=0;
			pg_idx=i;
			vvv_idx=i;
			gotoxy(1,0);
			while(i<e_h&&cursor_x<40 && ic<9 &&
				!strcmp(ss=&ph[idx[i]],inch)) {
				tt=ss+strlen(ss)+1;
				strcpy(vv,tt);
				vv[6]=0;
				i++;
				ic++;
				xprintf("%d%s ",ic,vv);
			}
			if(!strcmp(&ph[idx[i]],inch)) {
				gotoxy(41,0);
				xprintf(">");
			}
			vvvv_idx=i;
			mic=ic;	
			press_spc=1;
			tttest=1;
			return 1;
		}
		return 0;
	default:
		if (key < ' ' || key > 0x7e) return 0;
		if (mic) {
			i=key-'1';
			if (i<0||i>=mic) {
				if ( press_spc) {
					putstr(&ph[idx[vvv_idx]]+
					strlen(&ph[idx[vvv_idx]])+1);
					mic=0;
					ClrSelArea();
					ClrInArea();
					goto next_word;
				}
				return 0;
			}
			putstr(&ph[idx[vvv_idx+i]]+
				strlen(&ph[idx[vvv_idx+i]])+1);
			mic=0;
			ClrSelArea();
			ClrInArea();
			return 1;
		} 
next_word:
		if (cin<14) inch[cin++]=key;

}

DispInputArea();
return 1;
}
