
#ifdef CFGDEF
#define XSV(t,a,b) t a = b;
#else
#define XSV(t,a,b) extern t a;
#endif

#ifndef NO_CONFIGURE
#ifdef CFGDEF
#define XIV(t,a,b) t a = b;
#else
#define XIV(t,a,b) extern t a;
#endif
#else
#ifdef CFGDEF
#define XIV(t,a,b)
#else
#define XIV(t,a,b) static const t a = b;  // I hope this can be optimized away ?
#endif
#endif

#ifndef CFGDEF
typedef enum {
#ifdef CONFIG_LOOK_WIN95
    lookWin95,
#endif
#ifdef CONFIG_LOOK_MOTIF
    lookMotif,
#endif
#ifdef CONFIG_LOOK_WARP3
    lookWarp3,
#endif
#ifdef CONFIG_LOOK_WARP4
    lookWarp4,
#endif
#ifdef CONFIG_LOOK_NICE
    lookNice,
#endif
#ifdef CONFIG_LOOK_PIXMAP
    lookPixmap,
#endif
    // !!! TODO: lookWin31
    lookMAX
} WMLook;
#endif

XIV(int, clickFocus                   , 1)
XIV(int, raiseOnFocus                 , 1)
XIV(int, focusOnClickClient           , 1)
XIV(int, raiseOnClickClient           , 1)
XIV(int, raiseOnClickButton           , 1)
XIV(int, raiseOnClickFrame            , 1)
XIV(int, raiseOnClickTitleBar         , 1)
XIV(int, passFirstClickToClient       , 1)
XIV(int, focusOnMap                   , 1)
XIV(int, focusOnMapTransient          , 1)
XIV(int, pointerColormap              , 0)
XIV(int, sizeMaximized                , 0)
XIV(int, taskBarAtTop                 , 0)
XIV(int, showTaskBar                  , 1)
XIV(int, showTaskBarClock             , 1)
XIV(int, showMailBoxStatus            , 1)
XIV(int, showMoveSizeStatus           , 1)
XIV(int, beepOnNewMail                , 0)
XIV(int, warpPointer                  , 0)
XIV(int, opaqueMove                   , 0)
XIV(int, opaqueResize                 , 0)
XIV(int, win95keys                    , 0)
XIV(int, taskBarShowWorkspaces        , 0)
XIV(int, taskBarShowAllWindows        , 0)
XIV(int, minimizeToDesktop            , 0)
XIV(int, prettyClock                  , 1)
XIV(int, manualPlacement              , 0)
XIV(WMLook, wmLook                    , CONFIG_DEFAULT_LOOK)
XIV(unsigned int, wsBorderX           , 6)
XIV(unsigned int, wsBorderY           , 6)
XIV(unsigned int, wsDlgBorderX        , 2)
XIV(unsigned int, wsDlgBorderY        , 2)
XIV(unsigned int, wsTitleBar          , 20)
XIV(unsigned int, wsCornerX           , 24)
XIV(unsigned int, wsCornerY           , 24)
XIV(unsigned int, ClickMotionDistance , 5)
XIV(unsigned int, MultiClickTime      , 400)
XIV(unsigned int, ToolTipDelay        , 1000)
XIV(unsigned int, EdgeResistance      , 32)
XIV(unsigned int, useXButton          , 1)
XSV(const char *, themeName                 , CONFIG_DEFAULT_THEME)
XSV(const char *, titleFontName             , "-adobe-helvetica-bold-r-*-*-*-120-*-*-*-*-*-*")
XSV(const char *, menuFontName              , "-adobe-helvetica-bold-r-*-*-*-120-*-*-*-*-*-*")
XSV(const char *, statusFontName            , "-adobe-courier-bold-r-*-*-*-120-*-*-*-*-*-*")
XSV(const char *, switchFontName            , "-adobe-courier-bold-r-*-*-*-120-*-*-*-*-*-*")
XSV(const char *, normalTaskBarFontName     , "-adobe-helvetica-medium-r-*-*-*-120-*-*-*-*-*-*")
XSV(const char *, activeTaskBarFontName     , "-adobe-helvetica-bold-r-*-*-*-120-*-*-*-*-*-*")
XSV(const char *, windowListFontName        , "-adobe-helvetica-medium-r-*-*-*-120-*-*-*-*-*-*")
XSV(const char *, toolTipFontName           , "-adobe-helvetica-medium-r-*-*-*-120-*-*-*-*-*-*")
XSV(const char *, clockFontName             , "-adobe-courier-bold-r-*-*-*-140-*-*-*-*-*-*")
XSV(const char *, xpmPath                   , XPM_PATH)
XSV(const char *, iconPath                  , ICON_PATH)
XSV(const char *, mailBoxPath               , 0)
XSV(const char *, mailCommand               , 0)
XSV(const char *, lockCommand               , 0)
XSV(const char *, clockCommand              , 0)
XSV(const char *, fmtTime                   , "%H:%M:%S")
XSV(const char *, fmtDate                   , "%y %m %d")
XSV(const char *, clrActiveBorder           , "rgb:C0/C0/C0")
XSV(const char *, clrInactiveBorder         , "rgb:C0/C0/C0")
XSV(const char *, clrNormalButton           , "rgb:C0/C0/C0")
XSV(const char *, clrNormalButtonText       , "rgb:00/00/00")
XSV(const char *, clrActiveTitleBar         , "rgb:00/00/A0")
XSV(const char *, clrInactiveTitleBar       , "rgb:80/80/80")
XSV(const char *, clrActiveTitleBarText     , "rgb:FF/FF/FF")
XSV(const char *, clrInactiveTitleBarText   , "rgb:00/00/00")
XSV(const char *, clrNormalMenu             , "rgb:C0/C0/C0")
XSV(const char *, clrActiveMenuItem         , "rgb:00/00/A0")
XSV(const char *, clrActiveMenuItemText     , "rgb:FF/FF/FF")
XSV(const char *, clrNormalMenuItemText     , "rgb:00/00/00")
XSV(const char *, clrDisabledMenuItemText   , "rgb:80/80/80")
XSV(const char *, clrMoveSizeStatus         , "rgb:C0/C0/C0")
XSV(const char *, clrMoveSizeStatusText     , "rgb:00/00/00")
XSV(const char *, clrQuickSwitch            , "rgb:C0/C0/C0")
XSV(const char *, clrQuickSwitchText        , "rgb:00/00/00")
XSV(const char *, clrDefaultTaskBar         , "rgb:C0/C0/C0")
XSV(const char *, clrNormalTaskBarApp       , "rgb:C0/C0/C0")
XSV(const char *, clrNormalTaskBarAppText   , "rgb:00/00/00")
XSV(const char *, clrActiveTaskBarApp       , "rgb:E0/E0/E0")
XSV(const char *, clrActiveTaskBarAppText   , "rgb:00/00/00")
XSV(const char *, clrMinimizedTaskBarApp    , "rgb:A0/A0/A0")
XSV(const char *, clrMinimizedTaskBarAppText, "rgb:00/00/00")
XSV(const char *, clrScrollBar              , "rgb:A0/A0/A0")
XSV(const char *, clrScrollBarArrow         , "rgb:C0/C0/C0")
XSV(const char *, clrScrollBarSlider        , "rgb:C0/C0/C0")
XSV(const char *, clrListBox                , "rgb:C0/C0/C0")
XSV(const char *, clrListBoxText            , "rgb:00/00/00")
XSV(const char *, clrListBoxSelected        , "rgb:80/80/80")
XSV(const char *, clrListBoxSelectedText    , "rgb:00/00/00")
XSV(const char *, clrToolTip                , "rgb:E0/E0/00")
XSV(const char *, clrToolTipText            , "rgb:00/00/00")
XSV(const char *, clrClock                  , "rgb:00/00/00")
XSV(const char *, clrClockText              , "rgb:00/FF/00")

#if defined(CFGDEF) && !defined(NO_CONFIGURE)

static struct {
    const char *option;
    int *value;
} bool_options[] = {
    { "ClickToFocus", &clickFocus },
    { "RaiseOnFocus", &raiseOnFocus },
    { "FocusOnClickClient", &focusOnClickClient },
    { "RaiseOnClickClient", &raiseOnClickClient },
    { "RaiseOnClickTitleBar", &raiseOnClickTitleBar },
    { "RaiseOnClickButton", &raiseOnClickButton },
    { "RaiseOnClickFrame", &raiseOnClickFrame },
    { "PassFirstClickToClient", &passFirstClickToClient },
    { "FocusOnMap", &focusOnMap },
    { "FocusOnMapTransient", &focusOnMapTransient },
    { "PointerColormap", &pointerColormap },
    { "SizeMaximized", &sizeMaximized },
    { "TaskBarAtTop" , &taskBarAtTop },
    { "ShowTaskBar", &showTaskBar },
    { "ShowTaskBarClock", &showTaskBarClock },
    { "PrettyClock", &prettyClock },
    { "ShowMailBoxStatus", &showMailBoxStatus },
    { "BeepOnNewMail", &beepOnNewMail },
    { "ShowMoveSizeStatus", &showMoveSizeStatus },
    { "MinimizeToDesktop", &minimizeToDesktop },
    { "WarpPointer" , &warpPointer },
    { "OpaqueMove", &opaqueMove },
    { "OpaqueResize", &opaqueResize },
    { "Win95Keys", &win95keys },
    { "TaskBarShowWorkspaces", &taskBarShowWorkspaces },
    { "TaskBarShowAllWindows", &taskBarShowAllWindows },
    { "ManualPlacement", &manualPlacement },
#ifdef DEBUG
    { "debug", &debug },
    { "debug_z", &debug_z },
#endif
};

static struct {
    const char *option;
    unsigned int *value;
    int min, max;
} uint_options[] = {
    { "ShowXButton", &useXButton, 0, 2 },
    { "BorderSizeX", &wsBorderX, 0, 128 },
    { "BorderSizeY", &wsBorderY, 0, 128 },
    { "DlgBorderSizeX", &wsDlgBorderX, 0, 128 },
    { "DlgBorderSizeY", &wsDlgBorderY, 0, 128 },
    { "TitleBarHeight", &wsTitleBar, 0, 128 },
    { "CornerSizeX", &wsCornerX, 0, 64 },
    { "CornerSizeY", &wsCornerY, 0, 64 },
    { "ClickMotionDistance", &ClickMotionDistance, 0, 32 },
    { "MultiClickTime", &MultiClickTime, 0, 5000 },
    { "ToolTipDelay", &ToolTipDelay, 0, 5000 },
    { "EdgeResistance", &EdgeResistance, 0, 10000 }
};

static struct {
    const char *option;
    const char **value;
    int initial;
} string_options[] = {
    //    { "display", &displayName, 1 },
    { "Theme", &themeName, 1 },
    { "TitleFontName", &titleFontName, 1 },
    { "MenuFontName", &menuFontName, 1 },
    { "StatusFontName", &statusFontName, 1 },
    { "QuickSwitchFontName", &switchFontName, 1 },
    { "NormalTaskBarFontName", &normalTaskBarFontName, 1 },
    { "ActiveTaskBarFontName", &activeTaskBarFontName, 1 },
    { "WindowListFontName", &windowListFontName, 1 },
    { "ToolTipFontName", &toolTipFontName, 1 },
    { "ClockFontName", &clockFontName, 1 },
    { "LibPath", &xpmPath, 1 },
    { "IconPath", &iconPath, 1 },
    { "MailBoxPath", &mailBoxPath, 1 },
    { "MailCommand", &mailCommand, 1 },
    { "LockCommand", &lockCommand, 1 },
    { "ClockCommand", &clockCommand, 1 },
    { "TimeFormat", &fmtTime, 1 },
    { "DateFormat", &fmtDate, 1 },
    { "ColorActiveBorder", &clrActiveBorder, 1 },
    { "ColorNormalBorder", &clrInactiveBorder, 1 },
    { "ColorNormalButton", &clrNormalButton, 1 },
    { "ColorNormalButtonText", &clrNormalButtonText, 1 },
    { "ColorActiveTitleBar", &clrActiveTitleBar, 1 },
    { "ColorNormalTitleBar", &clrInactiveTitleBar, 1 },
    { "ColorActiveTitleBarText", &clrActiveTitleBarText, 1 },
    { "ColorNormalTitleBarText", &clrInactiveTitleBarText, 1 },
    { "ColorNormalMenu", &clrNormalMenu, 1 },
    { "ColorActiveMenuItem", &clrActiveMenuItem, 1 },
    { "ColorActiveMenuItemText", &clrActiveMenuItemText, 1 },
    { "ColorNormalMenuItemText", &clrNormalMenuItemText, 1 },
    { "ColorDisabledMenuItemText", &clrDisabledMenuItemText, 1 },
    { "ColorMoveSizeStatus", &clrMoveSizeStatus, 1 },
    { "ColorMoveSizeStatusText", &clrMoveSizeStatusText, 1 },
    { "ColorQuickSwitch", &clrQuickSwitch, 1 },
    { "ColorQuickSwitchText", &clrQuickSwitchText, 1 },
    { "ColorDefaultTaskBar", &clrDefaultTaskBar, 1 },
    { "ColorNormalTaskBarApp", &clrNormalTaskBarApp, 1 },
    { "ColorNormalTaskBarAppText", &clrNormalTaskBarAppText, 1 },
    { "ColorActiveTaskBarApp", &clrActiveTaskBarApp, 1 },
    { "ColorActiveTaskBarAppText", &clrActiveTaskBarAppText, 1 },
    { "ColorMinimizedTaskBarApp", &clrMinimizedTaskBarApp, 1 },
    { "ColorMinimizedTaskBarAppText", &clrMinimizedTaskBarAppText, 1 },
    { "ColorScrollBar", &clrScrollBar, 1 },
    { "ColorScrollBarArrow", &clrScrollBarArrow, 1 },
    { "ColorScrollBarSlider", &clrScrollBarSlider, 1 },
    { "ColorListBox", &clrListBox, 1 },
    { "ColorListBoxText", &clrListBoxText, 1 },
    { "ColorListBoxSelection", &clrListBoxSelected, 1 },
    { "ColorListBoxSelectionText", &clrListBoxSelectedText, 1 }
};

#define ACOUNT(x) (sizeof(x)/sizeof(x[0]))
#endif

#undef XIV
#undef XSV
