/*
 * IceWM
 *
 * Copyright (C) 1997,98 Marko Macek
 *
 * Clock
 */

#include "icewm.h"

YClock::YClock(YWindow *aParent, Window win): YWindow(aParent, win) {
    selected = 0;
    clockTimer = new YTimer();
    clockTimer->setListener(this);
    clockTimer->setInterval(500);
    clockTimer->startTimer();
    {
        char s[64];
        time_t newTime = time(NULL);
        struct tm *t = localtime(&newTime);
        int len, w;
        
        len = strftime(s, sizeof(s), fmtTime, t);
        w = calcWidth(s, len);
        if (!prettyClock)
            w += 4;
        setSize(w, 20);
    }
}

YClock::~YClock() {
    delete clockTimer; clockTimer = 0;
}

void YClock::handleCrossing(const XCrossingEvent &crossing) {
    if (crossing.type == EnterNotify) {
        char s[128];
        time_t newTime = time(NULL);
        struct tm *t = localtime(&newTime);
        int len;
        
        len = strftime(s, sizeof(s), fmtDate, t);

        setToolTip(s);
    }
    YWindow::handleCrossing(crossing);
}

void YClock::handleClick(const XButtonEvent &down, const XButtonEvent &up, int count) {
    if (down.button == 1 && up.button == 1) {
        if (count == 2) {
            if (clockCommand != 0)
                runCommand(clockCommand);
        }
    }
}

void YClock::paint(Graphics &g, int /*x*/, int /*y*/, unsigned int /*width*/, unsigned int /*height*/) {
    unsigned int x = 0;
    char s[64];
    time_t newTime = time(NULL);
    struct tm *t = localtime(&newTime);
    int len, i;

    len = strftime(s, sizeof(s), fmtTime, t);

    if (prettyClock) {
        i = 0;
        for (i = 0; x < width(); i++) {
            YPixmap *p;
            if (i < len)
                p = getPixmap(s[i]);
            else
                p = PixSpace;
            if (p) {
                g.drawPixmap(p, x, 0);
                x += p->width();
            } else if (i >= len) {
                g.setColor(clockBg);
                g.fillRect(x, 0, width() - x, height());
                break;
            }
        }
    } else {
        int y =  (height() - 1 - clockFont->height()) / 2
            + clockFont->ascent();
        
        g.setColor(clockBg);
        g.fillRect(0, 0, width(), height());
        g.setColor(clockFg);
        g.setFont(clockFont);
        g.drawChars(s, 0, len, 2, y);
    }
}

bool YClock::handleTimer(YTimer *t) {
    assert(t == clockTimer);
    repaint();
    return true;
}

YPixmap *YClock::getPixmap(char c) {
    YPixmap *pix = 0;
    switch (c) {
    case '0':
    case '1':
    case '2':
    case '3':
    case '4':
    case '5':
    case '6':
    case '7':
    case '8':
    case '9':
        pix = PixNum[c - '0'];
        break;
    case ' ':
        pix = PixSpace;
        break;
    case ':':
        pix = PixColon;
        break;
    case '/':
        pix = PixSlash;
        break;
    case '.':
        pix = PixDot;
        break;
    case 'p':
    case 'P':
        pix = PixP;
        break;
    case 'a':
    case 'A':
        pix = PixA;
        break;
    case 'm':
    case 'M':
        pix = PixM;
        break;
    }
    return pix;
}

int YClock::calcWidth(char *s, int count) {
    if (!prettyClock)
        return XTextWidth(clockFont->getFontStruct(), s, count);
    else {
        int len = 0;

        while (count--) {
            YPixmap *p = getPixmap(*s++);
            if (p)
                len += p->width();
        }
        return len;
    }
}
