/*
 *--------------------------------*-C-*---------------------------------
 * File:        unicode-dump.c
 *
 * Copyright (c) 1993 Steve Kilban <steve_kilbane@gec-epl.co.uk>
 * Copyright (c) 1997 Guylhem Aznar <guylhem@danmark.linux.eu.org>
 *
 *  This program is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU General Public License version
 *  2 as published by the Free Software Foundation.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *----------------------------------------------------------------------
 */

/*
 * unicode.c - convert between utf strings and hex numbers.
 * implemented from the ascii/unicode manual page from plan 9.
 *      steve_kilbane@gec-epl.co.uk
 */

#include <string.h>
#include <ctype.h>

int main(int argc, char *argv[])
{
	unsigned short c1, c2;
	char s[4];		/* maximum bytes per rune + 1 */
	int l;
	int optn = 0, optt = 0;

	if (argc > 1 && argv[1][0] == '-') {
		switch (argv[1][1]) {
		case 't':
			optt++;
			break;
		case 'n':
			optn++;
			break;
		default:
			printf("Unknown option !\nUsage : unicode-dump FROM-TO\nFor exemple : unicode-dump 0000-0154\n");
			exit(1);
		}
		argc--;
		argv++;
	}
	while (argc > 1) {
		char *dash;
		if (isxdigit(argv[1][0]) && !optn) {
			if (dash = strchr(argv[1], '-')) {
				*dash++ = 0;
				c1 = strtol(argv[1], (char **) 0, 16);
				c2 = strtol(dash, (char **) 0, 16);
			} else {
				c1 = c2 = strtol(argv[1], (char **) 0, 16);
			}
			while (c1 <= c2) {
				l = runetochar(s, &c1);
				s[l] = 0;
				if (optt)
					printf("%s", s);
				else {
					printf("%04x %s%c", c1, s,
					     (c1 + 1) % 8 ? '\t' : '\n');
				}
				c1++;
			}
		} else {
			int l;
			char *s = argv[1];

			while (*s) {
				l = chartorune(&c1, s);
				s += l;
				printf("%x\n", c1);
			}
		}
		argv++;
		argc--;
	}
	if (optt)
		printf("\n");
	return 0;
}
